/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.docker.ui.CheckboxTreeAndListGroup;
import org.eclipse.linuxtools.internal.docker.ui.Messages;
import org.eclipse.linuxtools.internal.docker.ui.MinimizedFileSystemElement;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ContainerFileSelectionDialog
extends SelectionDialog {
    private FileSystemElement root;
    private IImportStructureProvider structureProvider;
    static final String FILE_SELECTION_DIALOG = "org.eclipse.ui.ide.file_selection_dialog_context";
    CheckboxTreeAndListGroup selectionGroup;
    private boolean expandAllOnOpen = false;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 500;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    static final String SELECT_ALL_TITLE = "SelectionDialog_selectLabel";
    static final String DESELECT_ALL_TITLE = "SelectionDialog_deselectLabel";

    public ContainerFileSelectionDialog(Shell parentShell, FileSystemElement fileSystemElement, IImportStructureProvider structureProvider, String message) {
        super(parentShell);
        this.setTitle(Messages.getString("FileSelectionDialog_title"));
        this.root = fileSystemElement;
        this.structureProvider = structureProvider;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(Messages.getString("FileSelectionDialog_message"));
        }
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(128);
        composite.setData((Object)data);
        Button selectButton = new Button(buttonComposite, 8);
        selectButton.setText(Messages.getString(SELECT_ALL_TITLE));
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> this.selectionGroup.setAllSelections(true));
        selectButton.addSelectionListener(listener);
        Button deselectButton = new Button(buttonComposite, 8);
        deselectButton.setText(Messages.getString(DESELECT_ALL_TITLE));
        listener = SelectionListener.widgetSelectedAdapter(e -> this.selectionGroup.setAllSelections(false));
        deselectButton.addSelectionListener(listener);
    }

    private void checkInitialSelections() {
        for (FileSystemElement currentElement : this.getInitialElementSelections()) {
            if (currentElement.isDirectory()) {
                this.selectionGroup.initialCheckTreeItem(currentElement);
                continue;
            }
            this.selectionGroup.initialCheckListItem(currentElement);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, FILE_SELECTION_DIALOG);
    }

    public void create() {
        super.create();
        this.initializeDialog();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        FileSystemElement input = new FileSystemElement("", null, true);
        input.addChild(this.root);
        this.root.setParent(input);
        this.selectionGroup = new CheckboxTreeAndListGroup(composite, input, this.getFolderProvider(), this.getDynamicFolderProvider(), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getFileProvider(), (ILabelProvider)new WorkbenchLabelProvider(), 0, 500, 250);
        ICheckStateListener listener = event -> this.getOkButton().setEnabled(this.selectionGroup.getCheckedElementCount() > 0);
        WorkbenchViewerComparator comparator = new WorkbenchViewerComparator();
        this.selectionGroup.setTreeComparator((ViewerComparator)comparator);
        this.selectionGroup.setListComparator((ViewerComparator)comparator);
        this.selectionGroup.addCheckStateListener(listener);
        this.addSelectionButtons(composite);
        return composite;
    }

    public boolean getExpandAllOnOpen() {
        return this.expandAllOnOpen;
    }

    private ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof FileSystemElement) {
                    return ((FileSystemElement)o).getFiles().getChildren(o);
                }
                return new Object[0];
            }
        };
    }

    private ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof FileSystemElement) {
                    return ((FileSystemElement)o).getFolders().getChildren(o);
                }
                return new Object[0];
            }
        };
    }

    private ITreeContentProvider getDynamicFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    return ((MinimizedFileSystemElement)((Object)o)).getFolders(ContainerFileSelectionDialog.this.structureProvider).getChildren(o);
                }
                if (o instanceof FileSystemElement) {
                    return ((FileSystemElement)o).getFolders().getChildren(o);
                }
                return new Object[0];
            }
        };
    }

    private void initializeDialog() {
        if (this.getInitialElementSelections().isEmpty()) {
            this.getOkButton().setEnabled(false);
        } else {
            this.checkInitialSelections();
        }
        this.selectionGroup.aboutToOpen();
        if (this.expandAllOnOpen) {
            this.selectionGroup.expandAll();
        }
    }

    protected void okPressed() {
        Iterator resultEnum = this.selectionGroup.getAllCheckedListItems();
        ArrayList list = new ArrayList();
        while (resultEnum.hasNext()) {
            list.add(resultEnum.next());
        }
        this.setResult(list);
        super.okPressed();
    }

    public void setExpandAllOnOpen(boolean expandAll) {
        this.expandAllOnOpen = expandAll;
    }
}

