/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;
import org.eclipse.linuxtools.internal.rpmstubby.parser.RubyGemParser;

public class GemModel {
    private static final String FIX_ME = "#FIXME";
    private static final String SUMMARY = "summary";
    private static final String RUBYGEMS_VERSION = "rubygems_version";
    private static final String REQUIRE_PATHS = "require_paths";
    private static final String DEPENDENCY = "add_dependency";
    private static final String DEVELOPMENT_DEPENDENCY = "add_development_dependency";
    private static final String RUNTIME_DEPENDENCY = "add_runtime_dependency";
    private static final String HOMEPAGE = "homepage";
    private static final String[] SINGLE_VALUES = new String[]{"description", "name", "version", "license", "summary", "rubygems_version", "homepage"};
    private RubyGemParser rubyGemParser;

    public GemModel(IFile file) {
        try {
            this.rubyGemParser = new RubyGemParser(file);
        }
        catch (IOException | CoreException e) {
            StubbyLog.logError(e);
        }
    }

    private String getValue(String attr) {
        List<String> list = this.rubyGemParser.getValueList(attr);
        String rc = "";
        boolean single = false;
        String[] stringArray = SINGLE_VALUES;
        int n = SINGLE_VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.equals(attr)) {
                single = true;
                break;
            }
            ++n2;
        }
        rc = !list.isEmpty() && single ? list.get(0) : FIX_ME;
        return rc;
    }

    public List<String> getDependencies(String key) {
        ArrayList<String> rc = new ArrayList<String>();
        List<String> temp = this.rubyGemParser.getValueList(key);
        if (!temp.isEmpty()) {
            for (String tmp : temp) {
                rc.add(tmp.replaceFirst("(?:%q|%Q)(?:([\\W])([^\\W]+)[\\W])", "$2").replaceAll("(\"|'|\\[|\\])", "").replace(",", ""));
            }
        }
        return rc;
    }

    public List<String> getInstallRequiresList() {
        List<String> rc = this.getDependencies(DEPENDENCY);
        rc.addAll(this.getDependencies(RUNTIME_DEPENDENCY));
        return this.getDependencies(DEPENDENCY);
    }

    public List<String> getBuildRequiresList() {
        return this.getDependencies(DEVELOPMENT_DEPENDENCY);
    }

    public String getSimplePackageName() {
        return this.getValue("name");
    }

    public String getPackageName() {
        String simpleName = this.getSimplePackageName();
        if (simpleName.startsWith("rubygem-")) {
            return simpleName;
        }
        return "rubygem-" + simpleName;
    }

    public String getVersion() {
        String version = this.getValue("version");
        if (!this.hasDigits(version)) {
            version = "1 #FIXME";
        }
        return version;
    }

    public String getGemVersion() {
        String version = this.getValue(RUBYGEMS_VERSION);
        if (!this.hasDigits(version)) {
            version = FIX_ME;
        }
        return version;
    }

    public boolean hasDigits(String str) {
        return str.matches(".*\\d.*");
    }

    public String getSummary() {
        return this.getValue(SUMMARY);
    }

    public String getLicense() {
        String license = this.getValue("license");
        List<String> list = this.rubyGemParser.getValueList("licenses");
        if (license.equals(FIX_ME) && !list.isEmpty()) {
            license = "";
            for (String str : list) {
                license = license.concat(String.valueOf(str) + ", ");
                license = license.replaceAll("(\"|')", "");
            }
            license = license.substring(0, license.length() - 2);
        }
        return license;
    }

    public String getURL() {
        return this.getValue(HOMEPAGE);
    }

    public String getDescription() {
        return this.getValue("description");
    }

    public List<String> getRequirePaths() {
        ArrayList<String> rc = new ArrayList<String>();
        List<String> temp = this.rubyGemParser.getValueList(REQUIRE_PATHS);
        if (!temp.isEmpty()) {
            for (String tmp : temp) {
                rc.add(tmp.replaceFirst("(?:%q|%Q)(?:([\\W])([^\\W]+)[\\W])", "$2").replaceAll("(\"|'|\\[|\\])", "").replace(",", ""));
            }
        }
        return rc;
    }
}

