/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifHeapTreeNode;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifOutput;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifPidMenuAction;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifSnapshot;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifTreeViewer;
import org.eclipse.linuxtools.internal.valgrind.massif.Messages;
import org.eclipse.linuxtools.internal.valgrind.massif.charting.ChartEditorInput;
import org.eclipse.linuxtools.internal.valgrind.massif.charting.HeapChart;
import org.eclipse.linuxtools.valgrind.ui.IValgrindToolView;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class MassifViewPart
extends ViewPart
implements IValgrindToolView {
    private static final String TITLE_STACKS = Messages.getString("MassifViewPart.Stacks");
    private static final String TITLE_EXTRA = Messages.getString("MassifViewPart.Extra_Heap");
    private static final String TITLE_USEFUL = Messages.getString("MassifViewPart.Useful_Heap");
    private static final String TITLE_TOTAL = Messages.getString("MassifViewPart.Total");
    private static final String TITLE_TIME = Messages.getString("MassifViewPart.Time");
    private static final String TITLE_NUMBER = Messages.getString("MassifViewPart.Snapshot");
    private static final String TREE_ACTION = "org.eclipse.linuxtools.valgrind.massif.treeAction";
    public static final String CHART_ACTION = "org.eclipse.linuxtools.valgrind.massif.chartAction";
    public static final String PID_ACTION = "org.eclipse.linuxtools.valgrind.massif.pidAction";
    private MassifOutput output;
    private Integer pid;
    private Composite top;
    private StackLayout stackLayout;
    private TableViewer viewer;
    private MassifTreeViewer treeViewer;
    private MassifHeapTreeNode[] nodes;
    private String chartName;
    private static final int COLUMN_SIZE = 125;
    private Action treeAction;
    private MassifPidMenuAction pidAction;
    private List<ChartEditorInput> chartInputs;

    public void createPartControl(Composite parent) {
        String[] columnTitles;
        this.chartInputs = new ArrayList<ChartEditorInput>();
        this.top = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.top.setLayout((Layout)this.stackLayout);
        this.top.setLayoutData((Object)new GridData(1808));
        this.viewer = new TableViewer(this.top, 66308);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        String[] stringArray = columnTitles = new String[]{TITLE_NUMBER, TITLE_TIME, TITLE_TOTAL, TITLE_USEFUL, TITLE_EXTRA, TITLE_STACKS};
        int n = columnTitles.length;
        int n2 = 0;
        while (n2 < n) {
            String columnTitle = stringArray[n2];
            TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
            column.getColumn().setText(columnTitle);
            column.getColumn().setWidth(125);
            column.getColumn().setResizable(true);
            column.getColumn().addSelectionListener(this.getHeaderListener());
            ++n2;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MassifLabelProvider());
        this.treeViewer = new MassifTreeViewer(this.top);
        this.treeViewer.getViewer().getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.addDoubleClickListener(event -> {
            MassifSnapshot snapshot = (MassifSnapshot)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (snapshot.getType() != MassifSnapshot.SnapshotType.EMPTY) {
                this.treeAction.setChecked(true);
                this.setTopControl(this.treeViewer.getViewer().getControl());
                this.treeViewer.getViewer().setSelection((ISelection)new StructuredSelection((Object)snapshot.getRoot()), true);
                this.treeViewer.getViewer().expandToLevel((Object)snapshot.getRoot(), -1);
            }
        });
        this.stackLayout.topControl = this.viewer.getControl();
        this.top.layout();
    }

    private String getUnitString(MassifSnapshot[] snapshots) {
        String result;
        MassifSnapshot snapshot = snapshots[0];
        switch (snapshot.getUnit()) {
            case BYTES: {
                result = "B";
                break;
            }
            case INSTRUCTIONS: {
                result = "i";
                break;
            }
            default: {
                result = "ms";
            }
        }
        return result;
    }

    private SelectionListener getHeaderListener() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            TableColumn column = (TableColumn)e.widget;
            Table table = this.viewer.getTable();
            if (column.equals(table.getSortColumn())) {
                int direction = table.getSortDirection() == 128 ? 1024 : 128;
                table.setSortDirection(direction);
            } else {
                table.setSortDirection(128);
            }
            table.setSortColumn(column);
            this.viewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object o1, Object o2) {
                    Table table = ((TableViewer)viewer).getTable();
                    int direction = table.getSortDirection();
                    MassifSnapshot s1 = (MassifSnapshot)o1;
                    MassifSnapshot s2 = (MassifSnapshot)o2;
                    TableColumn column = table.getSortColumn();
                    long result = column.getText().equals(TITLE_NUMBER) ? s1.getNumber() - s2.getNumber() : (column.getText().startsWith(TITLE_TIME) ? s1.getTime() - s2.getTime() : (column.getText().equals(TITLE_TOTAL) ? s1.getTotal() - s2.getTotal() : (column.getText().equals(TITLE_USEFUL) ? s1.getHeapBytes() - s2.getHeapBytes() : (column.getText().equals(TITLE_EXTRA) ? s1.getHeapExtra() - s2.getHeapExtra() : s1.getStacks() - s2.getStacks()))));
                    long l = result = direction == 128 ? result : -result;
                    if (result > Integer.MAX_VALUE) {
                        result = Integer.MAX_VALUE;
                    } else if (result < Integer.MIN_VALUE) {
                        result = Integer.MIN_VALUE;
                    }
                    return (int)result;
                }
            });
        });
    }

    public IAction[] getToolbarActions() {
        this.pidAction = new MassifPidMenuAction(this);
        this.pidAction.setId(PID_ACTION);
        Action chartAction = new Action(Messages.getString("MassifViewPart.Display_Heap_Allocation"), 1){

            public void run() {
                ChartEditorInput input = MassifViewPart.this.getChartInput(MassifViewPart.this.pid);
                if (input != null) {
                    MassifViewPart.this.displayChart(input);
                }
            }
        };
        chartAction.setId(CHART_ACTION);
        chartAction.setImageDescriptor((ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.linuxtools.valgrind.massif", (String)"icons/linecharticon.gif").get());
        chartAction.setToolTipText(Messages.getString("MassifViewPart.Display_Heap_Allocation"));
        this.treeAction = new Action(Messages.getString("MassifViewPart.Show_Heap_Tree"), 2){

            public void run() {
                if (this.isChecked()) {
                    MassifViewPart.this.stackLayout.topControl = MassifViewPart.this.treeViewer.getViewer().getControl();
                    MassifViewPart.this.top.layout();
                } else {
                    MassifViewPart.this.stackLayout.topControl = MassifViewPart.this.viewer.getControl();
                    MassifViewPart.this.top.layout();
                }
            }
        };
        this.treeAction.setId(TREE_ACTION);
        this.treeAction.setImageDescriptor((ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.linuxtools.valgrind.massif", (String)"icons/call_hierarchy.gif").get());
        this.treeAction.setToolTipText(Messages.getString("MassifViewPart.Show_Heap_Tree"));
        return new IAction[]{this.pidAction, chartAction, this.treeAction};
    }

    private void createChart(MassifSnapshot[] snapshots) {
        String title = String.valueOf(this.chartName) + " [PID: " + this.pid + "]";
        HeapChart chart = new HeapChart(snapshots, title);
        String name = this.getInputName(title);
        ChartEditorInput input = new ChartEditorInput(chart, this, name, this.pid);
        this.chartInputs.add(input);
        this.displayChart(input);
    }

    private void displayChart(ChartEditorInput chartInput) {
        Display.getDefault().syncExec(() -> {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.openEditor((IEditorInput)chartInput, "org.eclipse.linuxtools.valgrind.massif.chartEditor");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        });
    }

    private String getInputName(String description) {
        String launchName;
        try {
            launchName = description.substring(0, description.indexOf("[massif"));
        }
        catch (IndexOutOfBoundsException e) {
            launchName = "(No chart title)";
        }
        return launchName.trim();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void refreshView() {
        if (this.output != null && this.pid != null) {
            MassifSnapshot[] snapshots = this.output.getSnapshots(this.pid);
            this.pidAction.setPids(this.output.getPids());
            if (snapshots != null) {
                this.viewer.setInput((Object)snapshots);
                String timeWithUnit = String.valueOf(TITLE_TIME) + " (" + this.getUnitString(snapshots) + ")";
                TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    if (column.getText().startsWith(TITLE_TIME)) {
                        column.setText(timeWithUnit);
                    }
                    this.viewer.getTable().layout(true);
                    ++n2;
                }
                MassifSnapshot[] detailed = this.getDetailed(snapshots);
                this.nodes = new MassifHeapTreeNode[detailed.length];
                int i = 0;
                while (i < detailed.length) {
                    this.nodes[i] = detailed[i].getRoot();
                    ++i;
                }
                this.treeViewer.getViewer().setInput((Object)this.nodes);
                if (snapshots.length > 0) {
                    ChartEditorInput input = this.getChartInput(this.pid);
                    if (input == null) {
                        this.createChart(snapshots);
                    } else {
                        this.displayChart(input);
                    }
                }
            }
        }
    }

    public void dispose() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            for (IEditorInput iEditorInput : this.chartInputs) {
                IEditorPart part = page.findEditor(iEditorInput);
                if (part == null) continue;
                page.closeEditor(part, false);
            }
        }
        super.dispose();
    }

    public void setTopControl(Control control) {
        this.stackLayout.topControl = control;
        this.top.layout(true);
    }

    public void setOutput(MassifOutput output) {
        this.output = output;
    }

    public MassifOutput getOutput() {
        return this.output;
    }

    public void setPid(Integer pid) {
        this.pid = pid;
    }

    public Integer getPid() {
        return this.pid;
    }

    public MassifSnapshot[] getSnapshots() {
        return this.output != null && this.pid != null ? this.output.getSnapshots(this.pid) : null;
    }

    public TableViewer getTableViewer() {
        return this.viewer;
    }

    public MassifTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setChartName(String chartName) {
        this.chartName = chartName;
    }

    private MassifSnapshot[] getDetailed(MassifSnapshot[] snapshots) {
        ArrayList<MassifSnapshot> list = new ArrayList<MassifSnapshot>();
        MassifSnapshot[] massifSnapshotArray = snapshots;
        int n = snapshots.length;
        int n2 = 0;
        while (n2 < n) {
            MassifSnapshot snapshot = massifSnapshotArray[n2];
            if (snapshot.getType() != MassifSnapshot.SnapshotType.EMPTY) {
                list.add(snapshot);
            }
            ++n2;
        }
        return list.toArray(new MassifSnapshot[list.size()]);
    }

    private ChartEditorInput getChartInput(Integer pid) {
        ChartEditorInput result = null;
        for (ChartEditorInput input : this.chartInputs) {
            if (!input.getPid().equals(pid)) continue;
            result = input;
        }
        return result;
    }

    private static class MassifLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private MassifLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            if (columnIndex == 0) {
                MassifSnapshot snapshot = (MassifSnapshot)element;
                switch (snapshot.getType()) {
                    case EMPTY: {
                        break;
                    }
                    case DETAILED: 
                    case PEAK: {
                        image = ((ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.linuxtools.valgrind.massif", (String)"icons/call_hierarchy.gif").get()).createImage();
                    }
                }
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            MassifSnapshot snapshot = (MassifSnapshot)element;
            DecimalFormat df = new DecimalFormat("#,##0");
            switch (columnIndex) {
                case 0: {
                    return df.format(snapshot.getNumber());
                }
                case 1: {
                    return df.format(snapshot.getTime());
                }
                case 2: {
                    return df.format(snapshot.getTotal());
                }
                case 3: {
                    return df.format(snapshot.getHeapBytes());
                }
                case 4: {
                    return df.format(snapshot.getHeapExtra());
                }
            }
            return df.format(snapshot.getStacks());
        }

        public Font getFont(Object element) {
            Font font = null;
            MassifSnapshot snapshot = (MassifSnapshot)element;
            switch (snapshot.getType()) {
                case EMPTY: 
                case DETAILED: {
                    break;
                }
                case PEAK: {
                    font = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
                }
            }
            return font;
        }
    }
}

