/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.pde.BNDInstructions;
import org.eclipse.m2e.pde.MavenTargetDependency;
import org.eclipse.m2e.pde.MavenTargetLocation;
import org.eclipse.m2e.pde.MavenTargetRepository;
import org.eclipse.m2e.pde.MissingMetadataMode;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetLocationFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenTargetLocationFactory
implements ITargetLocationFactory {
    public ITargetLocation getTargetLocation(String type, String serializedXML) throws CoreException {
        try {
            MissingMetadataMode mode;
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(serializedXML.getBytes(StandardCharsets.UTF_8)));
            Element location = document.getDocumentElement();
            try {
                mode = MissingMetadataMode.valueOf(location.getAttribute("missingManifest").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                mode = MissingMetadataMode.ERROR;
            }
            String dependencyScope = location.getAttribute("includeDependencyScope");
            ArrayList<MavenTargetDependency> dependencies = new ArrayList<MavenTargetDependency>();
            ArrayList<MavenTargetRepository> repositories = new ArrayList<MavenTargetRepository>();
            NodeList dependencyNodeList = location.getElementsByTagName("dependency");
            int dependencyLength = dependencyNodeList.getLength();
            if (dependencyLength == 0) {
                dependencies.add(this.parseDependency(location));
            } else {
                int i = 0;
                while (i < dependencyLength) {
                    Node item = dependencyNodeList.item(i);
                    if (item instanceof Element) {
                        dependencies.add(this.parseDependency((Element)item));
                    }
                    ++i;
                }
            }
            NodeList repositoryNodeList = location.getElementsByTagName("repository");
            int repositoryLength = repositoryNodeList.getLength();
            int i = 0;
            while (i < repositoryLength) {
                Node item = repositoryNodeList.item(i);
                if (item instanceof Element) {
                    Element element = (Element)item;
                    repositories.add(new MavenTargetRepository(this.getText("id", element), this.getText("url", element)));
                }
                ++i;
            }
            NodeList instructionsNodeList = location.getElementsByTagName("instructions");
            NodeList excludesNodeList = location.getElementsByTagName("exclude");
            ArrayList<BNDInstructions> instructions = new ArrayList<BNDInstructions>();
            ArrayList<String> excludes = new ArrayList<String>();
            int instructionsLength = instructionsNodeList.getLength();
            int i2 = 0;
            while (i2 < instructionsLength) {
                Node item = instructionsNodeList.item(i2);
                if (item instanceof Element) {
                    Element instructionElement = (Element)item;
                    instructions.add(new BNDInstructions(instructionElement.getAttribute("reference"), instructionElement.getTextContent()));
                }
                ++i2;
            }
            int excludesLength = excludesNodeList.getLength();
            int i3 = 0;
            while (i3 < excludesLength) {
                Node item = excludesNodeList.item(i3);
                if (item instanceof Element) {
                    excludes.add(((Element)item).getTextContent());
                }
                ++i3;
            }
            return new MavenTargetLocation(dependencies, repositories, mode, dependencyScope, Boolean.parseBoolean(location.getAttribute("includeSource")), instructions, excludes);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, MavenTargetLocationFactory.class.getPackage().getName(), e.getMessage(), (Throwable)e));
        }
    }

    private MavenTargetDependency parseDependency(Element element) {
        String artifactId = this.getText("artifactId", element);
        String groupId = this.getText("groupId", element);
        String version = this.getText("version", element);
        String artifactType = this.getText("type", element);
        String classifier = this.getText("classifier", element);
        return new MavenTargetDependency(groupId, artifactId, version, artifactType, classifier);
    }

    private String getText(String tagName, Element location) {
        NodeList nodeList = location.getElementsByTagName(tagName);
        int i = 0;
        while (i < nodeList.getLength()) {
            String textContent = nodeList.item(i).getTextContent();
            if (textContent != null) {
                return textContent;
            }
            ++i;
        }
        return "";
    }
}

