/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.util.HashSet;
import org.eclipse.ocl.examples.eventmanager.framework.Registration;
import org.eclipse.ocl.examples.eventmanager.util.Bag;
import org.eclipse.ocl.examples.eventmanager.util.SingleSetAsBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterTableEntry {
    private SingleSetAsBag<Registration>[] registrations;
    private SingleSetAsBag<Registration>[] negatedRegistrations;
    private int numberOfRegistrationSets;

    FilterTableEntry(int numberOfFilterTables) {
        this.registrations = new SingleSetAsBag[1 << numberOfFilterTables];
        this.negatedRegistrations = new SingleSetAsBag[1 << numberOfFilterTables];
    }

    boolean isEmpty() {
        return this.numberOfRegistrationSets == 0;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("  yesSetSizes:");
        int i = 0;
        while (i < this.registrations.length) {
            if (this.registrations[i] != null) {
                result.append("\n   registrations[" + i + "].size()=");
                result.append(this.registrations[i].size());
            }
            ++i;
        }
        result.append("\n  noSetSizes: ");
        i = 0;
        while (i < this.negatedRegistrations.length) {
            if (this.negatedRegistrations[i] != null) {
                result.append("\n   negatedRegistrations[" + i + "].size()=");
                result.append(this.negatedRegistrations[i].size());
            }
            ++i;
        }
        return result.toString();
    }

    public void addRegistrations(Registration registration) {
        this.addRegistrationTo(registration, this.registrations);
    }

    public void addNegatedRegistrations(Registration registration) {
        this.addRegistrationTo(registration, this.negatedRegistrations);
    }

    private void addRegistrationTo(Registration registration, SingleSetAsBag<Registration>[] registrationSetArray) {
        int bitSet = registration.getBitSetForTablesRegisteredWith();
        SingleSetAsBag<Registration> registrationSet = registrationSetArray[bitSet];
        if (registrationSet == null) {
            registrationSetArray[bitSet] = registrationSet = new SingleSetAsBag(new HashSet());
            ++this.numberOfRegistrationSets;
        }
        registrationSet.getWrappedSet().add(registration);
    }

    public void remove(Registration registration) {
        this.removeFromRegistrationSet(registration, this.registrations);
        this.removeFromRegistrationSet(registration, this.negatedRegistrations);
    }

    private void removeFromRegistrationSet(Registration registration, SingleSetAsBag<Registration>[] registrationSetArray) {
        int bitSet = registration.getBitSetForTablesRegisteredWith();
        SingleSetAsBag<Registration> bag = registrationSetArray[bitSet];
        if (bag != null && bag.getWrappedSet().remove(registration)) {
            --this.numberOfRegistrationSets;
        }
    }

    public Bag<Registration> getYesSet(int bitSetForTableCombination) {
        return this.registrations[bitSetForTableCombination];
    }

    public Bag<Registration> getNoSet(int bitSetForTableCombination) {
        return this.negatedRegistrations[bitSetForTableCombination];
    }

    public Bag<Registration>[] getYesSets() {
        return this.registrations;
    }

    public Bag<Registration>[] getNoSets() {
        return this.negatedRegistrations;
    }
}

