/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.launching.impl;

import org.eclipse.core.internal.events.NotificationManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.launching.LaunchTask;
import org.eclipse.oomph.setup.launching.LaunchingPackage;
import org.eclipse.oomph.setup.launching.LaunchingPlugin;
import org.eclipse.oomph.setup.launching.impl.Messages;
import org.eclipse.oomph.setup.log.ProgressLog;
import org.eclipse.oomph.util.PropertyFile;
import org.eclipse.osgi.util.NLS;

public class LaunchTaskImpl
extends SetupTaskImpl
implements LaunchTask {
    private static final PropertyFile HISTORY = new PropertyFile(LaunchingPlugin.INSTANCE.getStateLocation().append("launch-history.properties").toFile());
    protected static final String LAUNCHER_EDEFAULT = null;
    protected String launcher = LAUNCHER_EDEFAULT;
    protected static final boolean RUN_EVERY_STARTUP_EDEFAULT = false;
    protected boolean runEveryStartup = false;

    protected LaunchTaskImpl() {
    }

    protected EClass eStaticClass() {
        return LaunchingPackage.Literals.LAUNCH_TASK;
    }

    public String getLauncher() {
        return this.launcher;
    }

    public void setLauncher(String newLauncher) {
        String oldLauncher = this.launcher;
        this.launcher = newLauncher;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldLauncher, (Object)this.launcher));
        }
    }

    public boolean isRunEveryStartup() {
        return this.runEveryStartup;
    }

    public void setRunEveryStartup(boolean newRunEveryStartup) {
        boolean oldRunEveryStartup = this.runEveryStartup;
        this.runEveryStartup = newRunEveryStartup;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldRunEveryStartup, this.runEveryStartup));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getLauncher();
            }
            case 11: {
                return this.isRunEveryStartup();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setLauncher((String)newValue);
                return;
            }
            case 11: {
                this.setRunEveryStartup((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setLauncher(LAUNCHER_EDEFAULT);
                return;
            }
            case 11: {
                this.setRunEveryStartup(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return LAUNCHER_EDEFAULT == null ? this.launcher != null : !LAUNCHER_EDEFAULT.equals(this.launcher);
            }
            case 11: {
                return this.runEveryStartup;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (launcher: ");
        result.append(this.launcher);
        result.append(", runEveryStartup: ");
        result.append(this.runEveryStartup);
        result.append(')');
        return result.toString();
    }

    public int getProgressMonitorWork() {
        return 10;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        String property;
        String launcher = this.getLauncher();
        Trigger trigger = context.getTrigger();
        return trigger != Trigger.STARTUP || this.isRunEveryStartup() || (property = HISTORY.getProperty(launcher, null)) == null;
    }

    public void perform(final SetupTaskContext context) throws Exception {
        IFile file;
        Path path;
        ILaunchManager launchManager;
        String launcher = this.getLauncher();
        ILaunchConfiguration targetLaunchConfiguration = LaunchTaskImpl.getLaunchConfiguration(launcher, launchManager = DebugPlugin.getDefault().getLaunchManager());
        if (targetLaunchConfiguration == null) {
            context.log(Messages.LaunchTaskImpl_LauncherNotFoundWaiting_message);
            IJobManager jobManager = Job.getJobManager();
            jobManager.join(NotificationManager.class, context.getProgressMonitor(true));
            context.log(Messages.LaunchTaskImpl_RefreshFinished_message);
            targetLaunchConfiguration = LaunchTaskImpl.getLaunchConfiguration(launcher, launchManager);
        }
        if (targetLaunchConfiguration == null && (path = new Path(launcher)).segmentCount() >= 2 && (file = EcorePlugin.getWorkspaceRoot().getFile((IPath)path)).isAccessible()) {
            targetLaunchConfiguration = launchManager.getLaunchConfiguration(file);
        }
        if (targetLaunchConfiguration == null) {
            throw new Exception(NLS.bind((String)Messages.LaunchTaskImpl_LauncherNotFound_exception, (Object)launcher));
        }
        PreferencesUtil.PreferenceProperty launchPromptForErrorPreference = new PreferencesUtil.PreferenceProperty("/instance/org.eclipse.debug.ui/org.eclipse.debug.ui.cancel_launch_with_compile_errors");
        String oldValue = launchPromptForErrorPreference.get(null);
        try {
            launchPromptForErrorPreference.set("always");
            ILaunch launch = targetLaunchConfiguration.launch("run", null);
            IProcess[] processes = launch.getProcesses();
            if (processes.length > 0) {
                IProcess[] iProcessArray = processes;
                int n = processes.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess process = iProcessArray[n2];
                    IStreamsProxy streamsProxy = process.getStreamsProxy();
                    if (streamsProxy != null) {
                        IStreamMonitor errorStreamMonitor;
                        IStreamMonitor outputStreamMonitor = streamsProxy.getOutputStreamMonitor();
                        if (outputStreamMonitor != null) {
                            outputStreamMonitor.addListener(new IStreamListener(){

                                public void streamAppended(String text, IStreamMonitor monitor) {
                                    context.log(text.replace('\r', ' '));
                                }
                            });
                        }
                        if ((errorStreamMonitor = streamsProxy.getErrorStreamMonitor()) != null) {
                            errorStreamMonitor.addListener(new IStreamListener(){

                                public void streamAppended(String text, IStreamMonitor monitor) {
                                    context.log(text.replace('\r', ' '), ProgressLog.Severity.ERROR);
                                }
                            });
                        }
                    }
                    ++n2;
                }
                do {
                    Thread.sleep(1000L);
                    if (!context.isCanceled()) continue;
                    launch.terminate();
                    return;
                } while (!launch.isTerminated());
                HISTORY.setProperty(launcher, processes.length > 0 ? Integer.toString(processes[0].getExitValue()) : "-1");
                return;
            }
        }
        finally {
            launchPromptForErrorPreference.set(oldValue);
        }
    }

    private static ILaunchConfiguration getLaunchConfiguration(String launcher, ILaunchManager launchManager) throws CoreException {
        ILaunchConfiguration[] iLaunchConfigurationArray = launchManager.getLaunchConfigurations();
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            String name = launchConfiguration.getName();
            if (name.equals(launcher)) {
                return launchConfiguration;
            }
            ++n2;
        }
        return null;
    }
}

