/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.pde.impl;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.pde.PDEPackage;
import org.eclipse.oomph.setup.pde.TargetPlatformTask;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;

public class TargetPlatformTaskImpl
extends SetupTaskImpl
implements TargetPlatformTask {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final boolean ACTIVATE_EDEFAULT = true;
    protected boolean activate = true;
    private ITargetDefinition targetDefinition;

    protected TargetPlatformTaskImpl() {
    }

    protected EClass eStaticClass() {
        return PDEPackage.Literals.TARGET_PLATFORM_TASK;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldName, (Object)this.name));
        }
    }

    public boolean isActivate() {
        return this.activate;
    }

    public void setActivate(boolean newActivate) {
        boolean oldActivate = this.activate;
        this.activate = newActivate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldActivate, this.activate));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getName();
            }
            case 11: {
                return this.isActivate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setName((String)newValue);
                return;
            }
            case 11: {
                this.setActivate((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 11: {
                this.setActivate(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 11: {
                return !this.activate;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", activate: ");
        result.append(this.activate);
        result.append(')');
        return result.toString();
    }

    public int getProgressMonitorWork() {
        return 50;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        if (context.getTrigger() == Trigger.MANUAL) {
            return true;
        }
        String name = this.getName();
        this.targetDefinition = TargetPlatformUtil.getTargetDefinition((String)name);
        ITargetDefinition activeTargetDefinition = TargetPlatformUtil.getActiveTargetDefinition();
        if (this.targetDefinition == null || !this.isActivate() || activeTargetDefinition == null || !this.targetDefinition.getHandle().equals(activeTargetDefinition.getHandle())) {
            SetupUtil.getResolvingTargetDefinitions((SetupTaskContext)context).add(name);
            return true;
        }
        return false;
    }

    public void perform(SetupTaskContext context) throws Exception {
        if (this.targetDefinition == null) {
            this.targetDefinition = TargetPlatformUtil.getTargetDefinition((String)this.getName());
        }
        if (this.targetDefinition != null) {
            if (this.isActivate()) {
                TargetPlatformUtil.activateTargetDefinition((ITargetDefinition)this.targetDefinition, (IProgressMonitor)context.getProgressMonitor(true));
            } else {
                TargetPlatformUtil.resolveTargetDefinition((ITargetDefinition)this.targetDefinition, (IProgressMonitor)context.getProgressMonitor(true));
            }
        }
    }
}

