/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.AbstractServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;

public class ServiceUtilsForSelection
extends AbstractServiceUtils<ISelection> {
    private static ServiceUtilsForSelection instance = new ServiceUtilsForSelection();

    private ServiceUtilsForSelection() {
    }

    public static ServiceUtilsForSelection getInstance() {
        return instance;
    }

    public ServicesRegistry getServiceRegistry(ISelection from) throws ServiceException {
        if (from instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)from;
            for (Object selectedElement : selection) {
                EObject selectedEObject = EMFHelper.getEObject(selectedElement);
                if (selectedEObject == null) continue;
                return ServiceUtilsForEObject.getInstance().getServiceRegistry(selectedEObject);
            }
        }
        throw new ServiceException("Cannot retrieve the ServiceRegistry");
    }
}

