/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.cdtinterface.ui;

import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.ui.cview.CViewLabelProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.photran.internal.cdtinterface.CDTInterfacePlugin;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.swt.graphics.Image;

public class FViewLabelProvider
extends CViewLabelProvider {
    private static final String FORTRAN_FILE_ICON = "icons/obj16/f_file_obj.gif";
    private Image fortranFileImage;

    public FViewLabelProvider(long textFlags, int imageFlags) {
        super(textFlags, imageFlags);
    }

    public Image getImage(Object element) {
        if (this.isFortranFile(element)) {
            return this.fortranFileImage();
        }
        return super.getImage(element);
    }

    private boolean isFortranFile(Object element) {
        if (element instanceof TranslationUnit && ((TranslationUnit)element).getFile() != null) {
            String fileName = ((TranslationUnit)element).getFile().getName();
            IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(fileName);
            return contentType.isKindOf(FortranCorePlugin.fortranContentType());
        }
        return false;
    }

    private Image fortranFileImage() {
        if (this.fortranFileImage == null) {
            this.fortranFileImage = CDTInterfacePlugin.getImageDescriptor(FORTRAN_FILE_ICON).createImage();
        }
        return this.fortranFileImage;
    }

    public void dispose() {
        if (this.fortranFileImage != null) {
            this.fortranFileImage.dispose();
        }
        super.dispose();
    }
}

