/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.startup;

import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.ui.FortranUIPlugin;
import org.eclipse.photran.internal.ui.startup.UIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public final class ShowReleaseNotes
implements IStartup {
    public void earlyStartup() {
        if (this.shouldShowReleaseNotes()) {
            this.openWebBrowser(this.setPreference());
        }
    }

    private boolean shouldShowReleaseNotes() {
        return !this.runningJUnitTests() && !this.releaseNotesHaveAlreadyBeenDisplayed();
    }

    private boolean runningJUnitTests() {
        if (FortranCorePlugin.inTestingMode()) {
            return true;
        }
        String app = System.getProperty("eclipse.application");
        return app != null && app.toLowerCase().contains("junit");
    }

    private boolean releaseNotesHaveAlreadyBeenDisplayed() {
        return this.photranVersion().toString().equals(this.getPreference());
    }

    private String getPreference() {
        return FortranPreferences.RELEASE_NOTES_SHOWN.getValue();
    }

    private String setPreference() {
        String lastVersion = this.getPreference();
        FortranPreferences.RELEASE_NOTES_SHOWN.setValue(this.photranVersion().toString());
        return lastVersion;
    }

    private void openWebBrowser(final String lastVersion) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().createBrowser(6, null, UIMessages.ShowReleaseNotes_WelcomeTitle, null).openURL(new URL(ShowReleaseNotes.this.getURL(lastVersion)));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private String getURL(String lastVersion) {
        Version version = this.photranVersion();
        return "http://www.eclipse.org/photran/welcome/" + version.getMajor() + "." + version.getMinor() + "/?version=" + version.toString() + "&os=" + Platform.getOS() + "&arch=" + Platform.getOSArch() + "&lastVersion=" + lastVersion;
    }

    private Version photranVersion() {
        return FortranUIPlugin.getDefault().getBundle().getVersion();
    }
}

