/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.core.engine.cachegrind;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.php.profile.core.data.ProfilerCallTrace;
import org.eclipse.php.profile.core.data.ProfilerCallTraceLayer;
import org.eclipse.php.profile.core.data.ProfilerData;
import org.eclipse.php.profile.core.data.ProfilerFileData;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;
import org.eclipse.php.profile.core.data.ProfilerGlobalData;
import org.eclipse.php.profile.core.engine.DefaultProfilerDB;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.core.engine.cachegrind.CacheGrindParser;

public class CacheGrindModelParser {
    private static final String MAIN = "{main}";
    private static final String PHP_INTERNAL = "php:internal";
    private static final String PHP_CLASS = "php";
    private static final String PHP_FILE = "PHP";
    private CacheGrindParser source;
    private ProfilerData model;
    private List<ProfilerData> models = new ArrayList<ProfilerData>();
    private int fileCounter = 1;
    private int functionCounter = 1;
    private int fileFunctionCounter = 1;
    private int timeIndex = 0;
    private Map<String, Integer> fileIds = new HashMap<String, Integer>();
    private Map<String, Integer> functionIds = new HashMap<String, Integer>();
    private Map<Integer, String> functionNames = new HashMap<Integer, String>();
    private Map<Integer, File> files = new HashMap<Integer, File>();
    private Map<Integer, Invocation> invocations = new HashMap<Integer, Invocation>();
    private File lastFile;
    private File callFile;
    private Invocation lastFunction;
    private Invocation lastCall;
    private Invocation mainCall;

    public CacheGrindModelParser(InputStream file) {
        this.source = new CacheGrindParser(file);
    }

    private File regFile(int id, String name) {
        File tmp;
        if (name != null && name.equals(PHP_INTERNAL)) {
            name = PHP_FILE;
        }
        if (id == -1) {
            if (this.fileIds.containsKey(name)) {
                return this.files.get(this.fileIds.get(name));
            }
            id = this.fileCounter--;
            File tmp2 = new File(id);
            tmp2.name = name;
            this.fileIds.put(name, id);
            this.files.put(id, tmp2);
            return tmp2;
        }
        if (this.files.containsKey(id)) {
            tmp = this.files.get(id);
        } else {
            tmp = new File(id);
            this.files.put(id, tmp);
        }
        if (name != null) {
            tmp.name = name;
        }
        return tmp;
    }

    public ProfilerData[] buildModel() throws IOException {
        this.model = new ProfilerData(new ProfilerGlobalData(), new ArrayList<ProfilerFileData>(), new ProfilerCallTrace());
        this.source.parse(new ParserListener());
        this.finishCurrent();
        return this.models.toArray(new ProfilerData[0]);
    }

    private void finishCurrent() {
        if (this.model.getGlobalData().getPath() == null) {
            return;
        }
        if (this.mainCall == null) {
            this.mainCall = this.lastFunction;
        }
        this.finishSubCalls();
        if (this.mainCall != null) {
            this.buildCallTree(this.mainCall);
        }
        ArrayList<String> fileNames = new ArrayList<String>(this.files.size());
        for (File file : this.files.values()) {
            if (file.name == null) {
                file.name = String.valueOf(file.index);
            }
            ProfilerFileData modelFile = new ProfilerFileData(file.name);
            for (Function fnc : file.functions.values()) {
                if (fnc.name == null) {
                    fnc.name = this.functionNames.get(fnc.index);
                    if (fnc.name == null) {
                        fnc.name = String.valueOf(fnc.index);
                    }
                }
                ProfilerFunctionData modelFnc = new ProfilerFunctionData(file.name);
                int i = fnc.name.indexOf("::");
                if (i == -1) {
                    i = fnc.name.indexOf("->");
                }
                if (i != -1) {
                    String className = fnc.name.substring(0, i);
                    String fName = fnc.name.substring(i + 2);
                    if (fName.equals(file.name)) {
                        modelFnc.setFunctionName(className + ':' + fName);
                    } else {
                        if (!file.name.equals(PHP_FILE) && !className.equals(PHP_CLASS)) {
                            modelFnc.setClassName(className);
                        }
                        modelFnc.setFunctionName(fName);
                    }
                } else {
                    modelFnc.setFunctionName(fnc.name);
                }
                modelFnc.setLineNumber(fnc.position);
                modelFnc.setCallsCount(fnc.calls);
                modelFnc.setTotalTimeMicroseconds(fnc.totalCost);
                modelFnc.setOwnTimeMicroseconds(fnc.cost);
                if (this.mainCall != null) {
                    modelFnc.setID(fnc.id == this.mainCall.function.id ? -1 : fnc.id);
                }
                modelFile.addFunction(modelFnc);
            }
            this.model.addFile(modelFile);
            fileNames.add(file.name);
        }
        this.model.getGlobalData().setFileCount(this.files.size());
        this.model.getGlobalData().setFileNames(fileNames.toArray(new String[0]));
        this.fileIds.clear();
        this.functionNames.clear();
        this.functionIds.clear();
        this.files.clear();
        this.invocations.clear();
        this.fileFunctionCounter = 1;
        this.functionCounter = 1;
        this.fileCounter = 1;
        this.timeIndex = 0;
        this.lastFile = null;
        this.lastFunction = null;
        this.mainCall = null;
    }

    private void finishSubCalls() {
        if (this.lastFunction == null || this.lastFunction.calls.isEmpty()) {
            return;
        }
        ListIterator<Invocation> it = this.lastFunction.calls.listIterator(this.lastFunction.calls.size());
        Invocation[] realCalls = new Invocation[this.lastFunction.calls.size()];
        while (it.hasPrevious()) {
            int index = it.previousIndex();
            Invocation call = it.previous();
            Invocation realCall = call.function.pendingInvocations.pop();
            realCall.position = call.position;
            realCalls[index] = realCall;
            realCall.function.calls += call.count;
        }
        this.lastFunction.calls = Arrays.asList(realCalls);
    }

    private void buildCallTree(Invocation inv) {
        ProfilerCallTraceLayer lr = new ProfilerCallTraceLayer();
        int id = inv == this.mainCall ? -1 : inv.function.id;
        lr.setCalledID(id);
        lr.setType(1);
        lr.setLine(inv.position);
        this.model.getCallTrace().addLayer(lr);
        for (Invocation sub : inv.calls) {
            this.buildCallTree(sub);
        }
        lr = new ProfilerCallTraceLayer();
        lr.setCalledID(id);
        lr.setTimestampMicroseconds(inv.cost);
        lr.setType(0);
        lr.setLine(inv.position);
        this.model.getCallTrace().addLayer(lr);
    }

    public static ProfilerDB[] build(FileInputStream stream) throws IOException {
        CacheGrindModelParser tmp = new CacheGrindModelParser(stream);
        ArrayList<DefaultProfilerDB> db = new ArrayList<DefaultProfilerDB>();
        ProfilerData[] profilerDataArray = tmp.buildModel();
        int n = profilerDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProfilerData model = profilerDataArray[n2];
            db.add(new DefaultProfilerDB(model, new Date()));
            ++n2;
        }
        return db.toArray(new ProfilerDB[0]);
    }

    private class File {
        public int index;
        public String name;
        public Map<Integer, Function> functions = new HashMap<Integer, Function>();

        public File(int index) {
            this.index = index;
        }
    }

    private class Function {
        public int index;
        public int id;
        public String name;
        public int position = -1;
        public int cost = 0;
        public int totalCost = 0;
        public int calls = 0;
        public Deque<Invocation> pendingInvocations = new ArrayDeque<Invocation>();

        public Function(int id, int index) {
            this.id = id;
            this.index = index;
        }
    }

    private class Invocation {
        public Function function;
        public List<Invocation> calls = new LinkedList<Invocation>();
        public int cost;
        public int position;
        public int count = 0;

        private Invocation() {
        }
    }

    private class ParserListener
    implements CacheGrindParser.CacheGrindParserListener {
        private ParserListener() {
        }

        @Override
        public void cmd(String cmd) {
            CacheGrindModelParser.this.finishCurrent();
            CacheGrindModelParser.this.model = new ProfilerData(new ProfilerGlobalData(), new LinkedList<ProfilerFileData>(), new ProfilerCallTrace());
            CacheGrindModelParser.this.models.add(CacheGrindModelParser.this.model);
            CacheGrindModelParser.this.model.getGlobalData().setPath(cmd);
            CacheGrindModelParser.this.model.getGlobalData().setOriginalURL(ProfilerGlobalData.URL_NOT_AVAILABLE_MSG);
        }

        @Override
        public void events(String[] events) {
            int pos = 0;
            String[] stringArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.equalsIgnoreCase("Time")) {
                    CacheGrindModelParser.this.timeIndex = pos;
                    break;
                }
                ++pos;
                ++n2;
            }
        }

        public int getTime(int[] values) {
            if (values.length <= CacheGrindModelParser.this.timeIndex) {
                return 0;
            }
            return values[CacheGrindModelParser.this.timeIndex] * 100;
        }

        @Override
        public void file(int id, String name) {
            CacheGrindModelParser.this.finishSubCalls();
            CacheGrindModelParser.this.lastFunction = null;
            CacheGrindModelParser.this.callFile = null;
            CacheGrindModelParser.this.lastCall = null;
            CacheGrindModelParser.this.lastFile = CacheGrindModelParser.this.regFile(id, name);
        }

        @Override
        public void function(int id, String name) {
            Function fnc;
            if (CacheGrindModelParser.this.lastFile == null) {
                return;
            }
            CacheGrindModelParser.this.lastFunction = null;
            CacheGrindModelParser.this.callFile = null;
            CacheGrindModelParser.this.lastCall = null;
            boolean main = false;
            if (id < 0) {
                if (!CacheGrindModelParser.this.functionIds.containsKey(name)) {
                    id = CacheGrindModelParser.this.functionCounter++;
                    CacheGrindModelParser.this.functionIds.put(name, id);
                    if (CacheGrindModelParser.MAIN.equals(name)) {
                        main = true;
                    }
                } else {
                    id = CacheGrindModelParser.this.functionIds.get(name);
                }
            } else if (name != null) {
                if (CacheGrindModelParser.MAIN.equals(name)) {
                    main = true;
                }
                CacheGrindModelParser.this.functionIds.put(name, id);
            }
            if (!CacheGrindModelParser.this.lastFile.functions.containsKey(id)) {
                fnc = new Function(CacheGrindModelParser.this.fileFunctionCounter++, id);
                CacheGrindModelParser.this.lastFile.functions.put(id, fnc);
            } else {
                fnc = CacheGrindModelParser.this.lastFile.functions.get(id);
            }
            if (name != null) {
                fnc.name = name;
                CacheGrindModelParser.this.functionNames.put(id, name);
            }
            CacheGrindModelParser.this.lastFunction = new Invocation();
            CacheGrindModelParser.this.lastFunction.function = fnc;
            fnc.pendingInvocations.push(CacheGrindModelParser.this.lastFunction);
            if (main) {
                CacheGrindModelParser.this.mainCall = CacheGrindModelParser.this.lastFunction;
            }
        }

        @Override
        public void cost(int pos, int[] events) {
            int cost = this.getTime(events);
            if (CacheGrindModelParser.this.lastCall != null) {
                CacheGrindModelParser.this.lastCall.position = pos;
                CacheGrindModelParser.this.lastFunction.function.totalCost += cost;
                CacheGrindModelParser.this.lastFunction.cost += cost;
            } else if (CacheGrindModelParser.this.lastFunction != null) {
                CacheGrindModelParser.this.lastFunction.function.position = pos;
                CacheGrindModelParser.this.lastFunction.function.cost += cost;
                CacheGrindModelParser.this.lastFunction.function.totalCost += cost;
                CacheGrindModelParser.this.lastFunction.cost += cost;
                CacheGrindModelParser.this.lastFunction.position = pos;
            }
        }

        @Override
        public void calls(int count, int[] values) {
            if (CacheGrindModelParser.this.lastCall != null) {
                CacheGrindModelParser.this.lastCall.count += count;
            }
        }

        @Override
        public void nextFile(int id, String name) {
            if (CacheGrindModelParser.this.lastFile == null) {
                return;
            }
            CacheGrindModelParser.this.callFile = CacheGrindModelParser.this.regFile(id, name);
        }

        @Override
        public void nextFunction(int id, String name) {
            Function fnc;
            if (CacheGrindModelParser.this.lastFile == null) {
                return;
            }
            if (CacheGrindModelParser.this.callFile == null) {
                CacheGrindModelParser.this.callFile = CacheGrindModelParser.this.lastFile;
            }
            if (id < 0) {
                if (!CacheGrindModelParser.this.functionIds.containsKey(name)) {
                    id = CacheGrindModelParser.this.functionCounter++;
                    CacheGrindModelParser.this.functionIds.put(name, id);
                } else {
                    id = CacheGrindModelParser.this.functionIds.get(name);
                }
            } else if (name != null) {
                CacheGrindModelParser.this.functionIds.put(name, id);
            }
            if (!CacheGrindModelParser.this.callFile.functions.containsKey(id)) {
                fnc = new Function(CacheGrindModelParser.this.fileFunctionCounter++, id);
                CacheGrindModelParser.this.callFile.functions.put(id, fnc);
            } else {
                fnc = CacheGrindModelParser.this.callFile.functions.get(id);
            }
            if (name != null) {
                fnc.name = name;
            }
            CacheGrindModelParser.this.lastCall = new Invocation();
            CacheGrindModelParser.this.lastCall.function = fnc;
            CacheGrindModelParser.this.lastFunction.calls.add(CacheGrindModelParser.this.lastCall);
            CacheGrindModelParser.this.callFile = null;
        }

        @Override
        public void summary(int[] sum) {
            CacheGrindModelParser.this.model.getGlobalData().setTimeMicroSeconds(this.getTime(sum));
        }
    }
}

