/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.php.internal.core.documentModel.parser.PHPSourceParser;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.internal.ui.compare.Messages;
import org.eclipse.php.internal.ui.editor.configuration.PHPStructuredTextViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.sse.core.internal.document.StructuredDocumentFactory;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.JobSafeStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class PHPTextMergeViewer
extends TextMergeViewer {
    private boolean useBasic = true;

    public PHPTextMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
    }

    public void setInput(Object input) {
        ICompareInput compareInput;
        ISharedDocumentAdapter sda;
        if (input instanceof ICompareInput && (sda = (ISharedDocumentAdapter)Adapters.adapt((Object)(compareInput = (ICompareInput)input).getLeft(), ISharedDocumentAdapter.class)) != null) {
            this.useBasic = sda.getDocumentKey((Object)compareInput.getLeft()) == null;
        }
        super.setInput(input);
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof StructuredTextViewer) {
            ((StructuredTextViewer)textViewer).configure((SourceViewerConfiguration)new PHPStructuredTextViewerConfiguration());
        }
    }

    protected String getDocumentPartitioning() {
        if (this.useBasic) {
            return super.getDocumentPartitioning();
        }
        return "org.eclipse.wst.sse.core.default_structured_text_partitioning";
    }

    public IDocumentPartitioner getDocumentPartitioner() {
        if (this.useBasic) {
            return super.getDocumentPartitioner();
        }
        return new PHPStructuredTextPartitioner();
    }

    protected void setupDocument(IDocument document) {
        super.setupDocument(this.createStructuredDocument(document));
    }

    public String getTitle() {
        return Messages.PHPTextMergeViewer_Viewer_Title;
    }

    protected SourceViewer createSourceViewer(Composite parent, int textOrientation) {
        if (this.useBasic) {
            return super.createSourceViewer(parent, textOrientation);
        }
        return new StructuredTextViewer(parent, (IVerticalRuler)new CompositeRuler(), null, false, textOrientation | 0x100 | 0x200){

            public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
                super.setDocument(PHPTextMergeViewer.this.createStructuredDocument(document), annotationModel, modelRangeOffset, modelRangeLength);
            }
        };
    }

    private IDocument createStructuredDocument(IDocument document) {
        if (this.useBasic) {
            return document;
        }
        IStructuredDocument newDoc = null;
        if (document instanceof IStructuredDocument) {
            newDoc = (IStructuredDocument)document;
        } else if (document != null) {
            newDoc = StructuredDocumentFactory.getNewStructuredDocumentInstance((RegionParser)new PHPSourceParser());
            newDoc.set(document.get());
            IDocumentPartitioner partitioner = this.getDocumentPartitioner();
            if (partitioner != null) {
                if (newDoc instanceof JobSafeStructuredDocument) {
                    ((JobSafeStructuredDocument)newDoc).setDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning", partitioner);
                } else {
                    newDoc.setDocumentPartitioner(partitioner);
                }
                partitioner.connect((IDocument)newDoc);
            }
        }
        return newDoc;
    }
}

