/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.internal.core.language.keywords.PHPKeywords;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;

public class FunctionHighlighting
extends AbstractSemanticHighlighting {
    @Override
    public AbstractSemanticApply getSemanticApply() {
        return new FunctionApply();
    }

    @Override
    protected void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(true).setItalicByDefault(true);
    }

    public String getDisplayName() {
        return Messages.FunctionHighlighting_0;
    }

    protected class FunctionApply
    extends AbstractSemanticApply {
        protected FunctionApply() {
        }

        public boolean visit(FunctionDeclaration functionDeclaration) {
            if (functionDeclaration.getParent().getType() != 42) {
                FunctionHighlighting.this.highlight((ASTNode)functionDeclaration.getFunctionName());
            }
            return true;
        }

        public boolean visit(FunctionInvocation functionInvocation) {
            Expression functionName = functionInvocation.getFunctionName().getName();
            int invocationParent = functionInvocation.getParent().getType();
            if (invocationParent != 43 && invocationParent != 53) {
                this.highlightFunctionName(functionName);
            }
            return true;
        }

        private void highlightFunctionName(Expression functionName) {
            if (functionName instanceof NamespaceName) {
                List segments = ((NamespaceName)functionName).segments();
                if (segments.size() > 0) {
                    Identifier segment = (Identifier)segments.get(segments.size() - 1);
                    FunctionHighlighting.this.highlight((ASTNode)segment);
                }
            } else if (functionName instanceof Identifier) {
                PHPKeywords keywords = PHPKeywords.getInstance((PHPVersion)functionName.getAST().apiLevel());
                String name = ((Identifier)functionName).getName();
                if (!keywords.getKeywordNames().contains(name.toLowerCase())) {
                    FunctionHighlighting.this.highlight((ASTNode)functionName);
                }
            } else if (!(functionName instanceof ParenthesisExpression)) {
                FunctionHighlighting.this.highlight((ASTNode)functionName);
            }
        }
    }
}

