/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.views.markers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.eclipse.condition.AbstractExtendedMarkersViewIsUpdating;
import org.eclipse.reddeer.eclipse.ui.markers.matcher.AbstractMarkerMatcher;
import org.eclipse.reddeer.eclipse.ui.problems.Problem;
import org.eclipse.reddeer.eclipse.ui.views.markers.AbstractMarkersSupportView;
import org.eclipse.reddeer.workbench.impl.view.AbstractView;

public class ProblemsView
extends AbstractMarkersSupportView {
    public ProblemsView() {
        super("Problems");
    }

    public List<Problem> getProblems(ProblemType problemType, AbstractMarkerMatcher ... matchers) {
        this.activate();
        new WaitUntil((WaitCondition)new ProblemsViewMarkerIsUpdating(), TimePeriod.SHORT, false);
        new WaitWhile((WaitCondition)new ProblemsViewMarkerIsUpdating());
        ArrayList<Problem> result = new ArrayList<Problem>();
        if (problemType.equals((Object)ProblemType.ERROR) || problemType.equals((Object)ProblemType.ALL)) {
            result.addAll(this.getMarkers(Problem.class, ProblemType.ERROR.toString(), matchers));
        }
        if (problemType.equals((Object)ProblemType.WARNING) || problemType.equals((Object)ProblemType.ALL)) {
            result.addAll(this.getMarkers(Problem.class, ProblemType.WARNING.toString(), matchers));
        }
        return result;
    }

    public static enum ProblemType {
        WARNING("Warnings"),
        ERROR("Errors"),
        ALL("ALL");

        String text;

        private ProblemType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static ProblemType fromString(String type) {
            if (type.equals("Warnings")) {
                return WARNING;
            }
            return ERROR;
        }
    }

    private class ProblemsViewMarkerIsUpdating
    extends AbstractExtendedMarkersViewIsUpdating {
        public ProblemsViewMarkerIsUpdating() {
            super((AbstractView)ProblemsView.this, org.eclipse.ui.internal.views.markers.ProblemsView.class);
        }
    }
}

