/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.requirement.matcher;

import java.lang.annotation.Annotation;
import org.eclipse.reddeer.junit.requirement.configuration.RequirementConfiguration;
import org.eclipse.reddeer.junit.util.ReflectionUtil;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;

public class RequirementMatcher
extends TypeSafeMatcher<RequirementConfiguration> {
    private Matcher<?> attributeValueMatcher;
    private String attributeName;
    private Class<? extends Annotation> configurationClass;

    public RequirementMatcher(Class<? extends Annotation> clazz, String attributeName, Matcher<?> attributeValue) {
        this.attributeValueMatcher = attributeValue;
        this.attributeName = attributeName;
        this.configurationClass = clazz;
    }

    public RequirementMatcher(Class<? extends Annotation> clazz, String attributeName, String attributeValue) {
        this(clazz, attributeName, (Matcher<?>)new IsEqual((Object)attributeValue));
    }

    public Class<? extends Annotation> getConfigurationClass() {
        return this.configurationClass;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setConfigurationClass(Class<? extends Annotation> configurationClass) {
        this.configurationClass = configurationClass;
    }

    public void describeTo(Description description) {
        description.appendText("matches requirement attribute '" + this.attributeName + "' against matcher " + this.attributeValueMatcher);
    }

    protected boolean matchesSafely(RequirementConfiguration item) {
        Object value = ReflectionUtil.getValue(item, this.attributeName);
        return this.attributeValueMatcher.matches(value);
    }
}

