/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;

public class FileSystemElement
implements IAdaptable {
    private String name;
    private Object fileSystemObject;
    private AdaptableList folders = null;
    private AdaptableList files = null;
    private boolean isDirectory = false;
    private FileSystemElement parent;
    private static final AdaptableList EMPTY_LIST = new AdaptableList(0);
    private WorkbenchAdapter workbenchAdapter = new WorkbenchAdapter(){

        public Object[] getChildren(Object o) {
            return FileSystemElement.this.getFolders().getChildren(o);
        }

        public Object getParent(Object o) {
            return FileSystemElement.this.parent;
        }

        public String getLabel(Object o) {
            return FileSystemElement.this.name;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            if (FileSystemElement.this.isDirectory()) {
                return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
            }
            return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(FileSystemElement.this.name);
        }
    };

    public FileSystemElement(String name, FileSystemElement parent, boolean isDirectory) {
        this.name = name;
        this.parent = parent;
        this.isDirectory = isDirectory;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void addChild(FileSystemElement child) {
        if (child.isDirectory()) {
            if (this.folders == null) {
                this.folders = new AdaptableList(1);
            }
            this.folders.add((IAdaptable)child);
        } else {
            if (this.files == null) {
                this.files = new AdaptableList(1);
            }
            this.files.add((IAdaptable)child);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this.workbenchAdapter;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getFileNameExtension() {
        int lastDot = this.name.lastIndexOf(46);
        return lastDot < 0 ? "" : this.name.substring(lastDot + 1);
    }

    public AdaptableList getFiles() {
        if (this.files == null) {
            return EMPTY_LIST;
        }
        return this.files;
    }

    public Object getFileSystemObject() {
        return this.fileSystemObject;
    }

    public AdaptableList getFolders() {
        if (this.folders == null) {
            return EMPTY_LIST;
        }
        return this.folders;
    }

    public String getName() {
        return this.name;
    }

    public FileSystemElement getParent() {
        return this.parent;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void removeFolder(FileSystemElement child) {
        if (this.folders == null) {
            return;
        }
        this.folders.remove((IAdaptable)child);
        child.setParent(null);
    }

    public void setFileSystemObject(Object value) {
        this.fileSystemObject = value;
    }

    public void setParent(FileSystemElement element) {
        this.parent = element;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.isDirectory()) {
            buf.append("Folder(");
        } else {
            buf.append("File(");
        }
        buf.append(this.name).append(")");
        if (!this.isDirectory()) {
            return buf.toString();
        }
        buf.append(" folders: ");
        buf.append(this.folders);
        buf.append(" files: ");
        buf.append(this.files);
        return buf.toString();
    }
}

