/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.diagram;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.CenterLabelStyle;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.CenteringStyle;
import org.eclipse.sirius.diagram.ui.business.api.query.EdgeQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.view.EdgeLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.LayoutData;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.edge.SlidableAnchor;
import org.eclipse.sirius.diagram.ui.part.SiriusLinkDescriptor;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.routers.RectilinearEdgeUtil;
import org.eclipse.sirius.diagram.ui.tools.internal.util.GMFNotationUtilities;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class ConnectionsFactory {
    private static final String EMPTY_TERMINAL = "";
    private Diagram gmfDiagram;
    private IViewProvider viewpointViewProvider;
    private String sourceTerminal;
    private String targetTerminal;
    private PointList pointList = new PointList();
    private Point sourceRefPoint = new Point(0, 0);
    private Point targetRefPoint = new Point(0, 0);
    private Routing routing;

    public ConnectionsFactory(Diagram gmfDiagram, IViewProvider viewpointViewProvider) {
        this.gmfDiagram = gmfDiagram;
        this.viewpointViewProvider = viewpointViewProvider;
    }

    public Edge createEdge(SiriusLinkDescriptor viewDescriptor, Map<EObject, View> domain2NotationMap) {
        Edge createdEdge = null;
        this.pointList = new PointList();
        View source = domain2NotationMap.get(viewDescriptor.getSource());
        View target = domain2NotationMap.get(viewDescriptor.getDestination());
        if (source != null && target != null && source.getElement() instanceof EdgeTarget && target.getElement() instanceof EdgeTarget) {
            PreferencesHint preferencesHint;
            boolean persisted;
            int index;
            String semanticHint;
            Diagram containerView;
            EdgeTarget sourceEdgeTarget = (EdgeTarget)source.getElement();
            EdgeTarget targetEdgeTarget = (EdgeTarget)target.getElement();
            IAdaptable semanticAdapter = viewDescriptor.getSemanticAdapter();
            Edge edge = this.viewpointViewProvider.createEdge(semanticAdapter, (View)(containerView = this.gmfDiagram), semanticHint = null, index = -1, persisted = true, preferencesHint = DiagramUIPlugin.DIAGRAM_PREFERENCES_HINT);
            if (edge != null) {
                this.updateFontHeight(edge);
                this.getAttributes(edge, sourceEdgeTarget, targetEdgeTarget, source, target);
                edge.setSource(source);
                edge.setTarget(target);
                this.setConnectionAnchors(edge);
                ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
                int numOfPoints = this.pointList.size();
                int i = 0;
                while (i < numOfPoints) {
                    Dimension s = this.pointList.getPoint(i).getDifference(this.sourceRefPoint);
                    Dimension t = this.pointList.getPoint(i).getDifference(this.targetRefPoint);
                    newBendpoints.add(new RelativeBendpoint(s.width, s.height, t.width, t.height));
                    i = (short)(i + 1);
                }
                RelativeBendpoints points = (RelativeBendpoints)edge.getBendpoints();
                points.setPoints(newBendpoints);
                if (this.routing != null) {
                    Style routingStyle = edge.getStyle(NotationPackage.Literals.ROUTING_STYLE);
                    routingStyle.eSet((EStructuralFeature)NotationPackage.Literals.ROUTING_STYLE__ROUTING, (Object)this.routing);
                }
                domain2NotationMap.put(viewDescriptor.getModelElement(), (View)edge);
                createdEdge = edge;
            } else {
                DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.ConnectionsFactory_edgeNotCreatedMsg, sourceEdgeTarget, targetEdgeTarget));
            }
        }
        return createdEdge;
    }

    private void updateFontHeight(Edge edge) {
        Style style = edge.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (style instanceof FontStyle) {
            DEdge dEdge;
            CenterLabelStyle centerLabelStyle;
            FontStyle fontStyle = (FontStyle)style;
            EObject element = edge.getElement();
            if (element instanceof DEdge && (centerLabelStyle = (dEdge = (DEdge)element).getOwnedStyle().getCenterLabelStyle()) != null) {
                int labelSize = centerLabelStyle.getLabelSize();
                fontStyle.setFontHeight(Math.max(labelSize, 1));
            }
        }
    }

    private void getAttributes(Edge edge, EdgeTarget sourceEdgeTarget, EdgeTarget targetEdgeTarget, View source, View target) {
        EObject element;
        if (edge.getElement() instanceof DEdge && (element = edge.getElement()) instanceof DEdge) {
            DEdge dEdge = (DEdge)element;
            EdgeLayoutData edgeLayoutData = SiriusLayoutDataManager.INSTANCE.getData(dEdge, false);
            if (edgeLayoutData != null) {
                EdgeLayoutData oppositeEdgeLayoutData = SiriusLayoutDataManager.INSTANCE.getOppositeEdgeLayoutData(edgeLayoutData, false);
                this.routing = edgeLayoutData.getRouting();
                if (oppositeEdgeLayoutData != null) {
                    this.getAttributesForSourceAndTargetMove(edgeLayoutData, oppositeEdgeLayoutData, edge, source, target);
                } else {
                    this.getAttributesForSourceOrTargetMove(edgeLayoutData, edge, source, target);
                }
            } else {
                Option<Rectangle> optionalSourceBounds = GMFHelper.getAbsoluteBounds(source);
                LayoutData sourceLayoutData = null;
                if (sourceEdgeTarget instanceof AbstractDNode) {
                    AbstractDNode sourceDNode = (AbstractDNode)sourceEdgeTarget;
                    sourceLayoutData = SiriusLayoutDataManager.INSTANCE.getData(sourceDNode);
                }
                Point firstClick = this.getFirstClick(sourceLayoutData, optionalSourceBounds);
                if (optionalSourceBounds.some()) {
                    PrecisionPoint sourceRelativeLocation = BaseSlidableAnchor.getAnchorRelativeLocation((Point)firstClick, (Rectangle)((Rectangle)optionalSourceBounds.get()));
                    this.sourceTerminal = GMFNotationUtilities.getTerminalString(sourceRelativeLocation.preciseX(), sourceRelativeLocation.preciseY());
                } else {
                    this.sourceTerminal = GMFNotationUtilities.getTerminalString(0.5, 0.5);
                }
                Option<Rectangle> optionaltargetBounds = GMFHelper.getAbsoluteBounds(target);
                LayoutData targetLayoutData = null;
                if (targetEdgeTarget instanceof AbstractDNode) {
                    AbstractDNode targetDNode = (AbstractDNode)targetEdgeTarget;
                    targetLayoutData = SiriusLayoutDataManager.INSTANCE.getData(targetDNode);
                }
                Point secondClick = this.getSecondClick(targetLayoutData, optionaltargetBounds);
                if (optionaltargetBounds.some()) {
                    PrecisionPoint targetRelativeLocation = BaseSlidableAnchor.getAnchorRelativeLocation((Point)secondClick, (Rectangle)((Rectangle)optionaltargetBounds.get()));
                    this.targetTerminal = GMFNotationUtilities.getTerminalString(targetRelativeLocation.preciseX(), targetRelativeLocation.preciseY());
                } else {
                    this.targetTerminal = GMFNotationUtilities.getTerminalString(0.5, 0.5);
                }
                PrecisionPoint sourceRelativeReference = SlidableAnchor.parseTerminalString(this.sourceTerminal);
                SlidableAnchor sourceAnchor = new SlidableAnchor(source, sourceRelativeReference);
                this.sourceRefPoint = sourceAnchor.getLocation(sourceAnchor.getReferencePoint());
                PrecisionPoint targetRelativeReference = SlidableAnchor.parseTerminalString(this.targetTerminal);
                SlidableAnchor targetAnchor = new SlidableAnchor(target, targetRelativeReference);
                this.targetRefPoint = targetAnchor.getLocation(targetAnchor.getReferencePoint());
                Optional srcConnectionBendpoint = GraphicalHelper.getIntersection((Point)this.sourceRefPoint, (Point)this.targetRefPoint, (Rectangle)((Rectangle)optionalSourceBounds.get()), (boolean)true);
                Optional tgtConnectionBendpoint = GraphicalHelper.getIntersection((Point)this.sourceRefPoint, (Point)this.targetRefPoint, (Rectangle)((Rectangle)optionaltargetBounds.get()), (boolean)false);
                if (srcConnectionBendpoint.isPresent() && tgtConnectionBendpoint.isPresent()) {
                    this.pointList.addPoint((Point)srcConnectionBendpoint.get());
                    this.pointList.addPoint((Point)tgtConnectionBendpoint.get());
                    EdgeQuery edgeQuery = new EdgeQuery(edge);
                    if (edgeQuery.isEdgeWithRectilinearRoutingStyle()) {
                        RectilinearEdgeUtil.centerEdgeEnds(this.pointList, this.sourceRefPoint, this.targetRefPoint, CenteringStyle.BOTH);
                    }
                } else {
                    this.pointList.addPoint(this.sourceRefPoint);
                    this.pointList.addPoint(this.targetRefPoint);
                }
            }
            this.pointList = RectilinearEdgeUtil.normalizeToStraightLineTolerance(this.pointList, 2);
        }
    }

    protected void getAttributesForSourceOrTargetMove(EdgeLayoutData edgeLayoutData, Edge edge, View source, View target) {
        this.sourceTerminal = edgeLayoutData.getSourceTerminal();
        if (EMPTY_TERMINAL.equals(this.sourceTerminal)) {
            this.sourceTerminal = GMFNotationUtilities.getTerminalString(0.5, 0.5);
        }
        this.targetTerminal = edgeLayoutData.getTargetTerminal();
        if (EMPTY_TERMINAL.equals(this.targetTerminal)) {
            this.targetTerminal = GMFNotationUtilities.getTerminalString(0.5, 0.5);
        }
        if (edgeLayoutData.getSourceRefPoint() != null) {
            this.sourceRefPoint = edgeLayoutData.getSourceRefPoint().getCopy();
        }
        if (edgeLayoutData.getTargetRefPoint() != null) {
            this.targetRefPoint = edgeLayoutData.getTargetRefPoint().getCopy();
        }
        if (edgeLayoutData.getPointList() != null) {
            GraphicalEditPart srceEditPart = (GraphicalEditPart)GMFHelper.getGraphicalEditPart(source).get();
            GraphicalEditPart tgtEditPart = (GraphicalEditPart)GMFHelper.getGraphicalEditPart(target).get();
            if (srceEditPart != null && tgtEditPart != null) {
                GraphicalHelper.screen2logical((Point)this.sourceRefPoint, (GraphicalEditPart)srceEditPart);
                GraphicalHelper.screen2logical((Point)this.targetRefPoint, (GraphicalEditPart)tgtEditPart);
                Rectangle optionalSourceBounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)srceEditPart);
                Optional srcConnectionBendpoint = GraphicalHelper.getIntersection((Point)this.sourceRefPoint, (Point)this.targetRefPoint, (Rectangle)optionalSourceBounds, (boolean)true);
                Rectangle optionaltargetBounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)tgtEditPart);
                Optional tgtConnectionBendpoint = GraphicalHelper.getIntersection((Point)this.sourceRefPoint, (Point)this.targetRefPoint, (Rectangle)optionaltargetBounds, (boolean)false);
                if (srcConnectionBendpoint.isPresent() && tgtConnectionBendpoint.isPresent()) {
                    EdgeQuery edgeQuery = new EdgeQuery(edge);
                    Routing routingStyle = edgeQuery.getRoutingStyle();
                    if (Routing.RECTILINEAR_LITERAL.equals(routingStyle) && srceEditPart != null && srceEditPart.equals(tgtEditPart)) {
                        this.pointList = RectilinearEdgeUtil.computeRectilinearBendpointsSameSourceAndTarget(optionalSourceBounds, srceEditPart.getFigure().getBounds().getRight(), 16);
                    } else if (Routing.RECTILINEAR_LITERAL.equals(routingStyle)) {
                        this.pointList = RectilinearEdgeUtil.computeRectilinearBendpoints(optionalSourceBounds, optionaltargetBounds, (Point)srcConnectionBendpoint.get(), (Point)tgtConnectionBendpoint.get());
                    } else {
                        this.pointList.addPoint((Point)srcConnectionBendpoint.get());
                        this.pointList.addPoint((Point)tgtConnectionBendpoint.get());
                    }
                }
            }
            if (this.pointList.size() == 0) {
                this.pointList = edgeLayoutData.getPointList();
            }
        }
    }

    private void getAttributesForSourceAndTargetMove(EdgeLayoutData edgeLayoutData, EdgeLayoutData oppositeEdgeLayoutData, Edge edge, View source, View target) {
        EdgeLayoutData layoutDataFromTarget;
        EdgeLayoutData layoutDataFromSource;
        if (edgeLayoutData.getTarget().getSourceNode().equals(edgeLayoutData.getParent().getTarget())) {
            layoutDataFromSource = edgeLayoutData;
            layoutDataFromTarget = oppositeEdgeLayoutData;
        } else {
            layoutDataFromSource = oppositeEdgeLayoutData;
            layoutDataFromTarget = edgeLayoutData;
        }
        this.sourceTerminal = layoutDataFromSource.getSourceTerminal();
        this.targetTerminal = layoutDataFromTarget.getTargetTerminal();
        if (layoutDataFromSource.getSourceRefPoint() != null) {
            this.sourceRefPoint = layoutDataFromSource.getSourceRefPoint();
        }
        if (layoutDataFromTarget.getTargetRefPoint() != null) {
            this.targetRefPoint = layoutDataFromTarget.getTargetRefPoint();
        }
        if (layoutDataFromSource.getPointList() != null) {
            this.pointList = layoutDataFromSource.getPointList();
            if (layoutDataFromTarget.getPointList() != null) {
                this.pointList.setPoint(layoutDataFromTarget.getPointList().getLastPoint(), this.pointList.size() - 1);
                if (this.pointList.size() > 2) {
                    this.pointList.setPoint(layoutDataFromTarget.getPointList().getPoint(1), 1);
                }
            }
            if (this.pointList.size() > 2 && layoutDataFromSource.getTargetRefPoint() != null) {
                Point targetRefPointFromSource = layoutDataFromSource.getTargetRefPoint();
                Dimension delta = this.targetRefPoint.getDifference(targetRefPointFromSource);
                int i = 1;
                while (i < this.pointList.size() - 1) {
                    this.pointList.setPoint(this.pointList.getPoint(i).translate(delta.width, delta.height), i);
                    ++i;
                }
            }
        }
    }

    private Point getFirstClick(LayoutData sourceLayoutData, Option<Rectangle> optionalSourceBounds) {
        Point firstClick = new Point(0, 0);
        if (sourceLayoutData == null) {
            if (optionalSourceBounds.some()) {
                firstClick = ((Rectangle)optionalSourceBounds.get()).getCenter();
            }
        } else {
            Point sourceLocation;
            firstClick = sourceLocation = sourceLayoutData.getLocation();
        }
        return firstClick;
    }

    private Point getSecondClick(LayoutData targetLayoutData, Option<Rectangle> optionaltargetBounds) {
        Point secondClick = new Point(0, 0);
        if (targetLayoutData == null) {
            if (optionaltargetBounds.some()) {
                secondClick = ((Rectangle)optionaltargetBounds.get()).getCenter();
            }
        } else {
            Point targetLocation;
            secondClick = targetLocation = targetLayoutData.getLocation();
        }
        return secondClick;
    }

    private void setConnectionAnchors(Edge edge) {
        IdentityAnchor a;
        Option<IdentityAnchor> optionalSourceIdentityAnchorOfBrother;
        EdgeQuery edgeQuery = new EdgeQuery(edge);
        if (edgeQuery.isEdgeOnTreeOnSourceSide() && (optionalSourceIdentityAnchorOfBrother = edgeQuery.getSourceAnchorOfFirstBrotherWithSameSource()).some()) {
            this.sourceTerminal = ((IdentityAnchor)optionalSourceIdentityAnchorOfBrother.get()).getId();
        }
        if (this.sourceTerminal != null) {
            if (this.sourceTerminal.length() == 0) {
                edge.setSourceAnchor(null);
            } else {
                a = (IdentityAnchor)edge.getSourceAnchor();
                if (a == null) {
                    a = NotationFactory.eINSTANCE.createIdentityAnchor();
                }
                a.setId(this.sourceTerminal);
                edge.setSourceAnchor((Anchor)a);
            }
        }
        if (edgeQuery.isEdgeOnTreeOnTargetSide()) {
            Option<IdentityAnchor> optionalTargetIdentityAnchorOfBrother = edgeQuery.getTargetAnchorOfFirstBrotherWithSameTarget();
            if (optionalTargetIdentityAnchorOfBrother.some()) {
                this.targetTerminal = ((IdentityAnchor)optionalTargetIdentityAnchorOfBrother.get()).getId();
            }
        } else if (edgeQuery.usedTreeRouter()) {
            this.targetTerminal = "(0.5,0.5)";
        }
        if (this.targetTerminal != null) {
            if (this.targetTerminal.length() == 0) {
                edge.setTargetAnchor(null);
            } else {
                a = (IdentityAnchor)edge.getTargetAnchor();
                if (a == null) {
                    a = NotationFactory.eINSTANCE.createIdentityAnchor();
                }
                a.setId(this.targetTerminal);
                edge.setTargetAnchor((Anchor)a);
            }
        }
    }
}

