/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionImpl;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.query.IllegalStateExceptionQuery;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.common.ui.tools.api.util.IObjectActionDelegateWrapper;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.business.internal.refresh.SiriusDiagramSessionEventBroker;
import org.eclipse.sirius.diagram.business.internal.refresh.SynchronizeGMFModelCommand;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.tools.api.command.ChangeLayerActivationCommand;
import org.eclipse.sirius.diagram.tools.api.command.DiagramCommandFactoryService;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.tools.api.command.view.HideDDiagramElement;
import org.eclipse.sirius.diagram.tools.api.command.view.HideDDiagramElementLabel;
import org.eclipse.sirius.diagram.tools.api.management.ToolChangeListener;
import org.eclipse.sirius.diagram.tools.api.management.ToolFilter;
import org.eclipse.sirius.diagram.tools.api.management.ToolManagement;
import org.eclipse.sirius.diagram.tools.internal.management.UpdateToolRecordingCommand;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.internal.command.RefreshDiagramOnOpeningCommand;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.listener.DiagramHeaderPostCommitListener;
import org.eclipse.sirius.diagram.ui.edit.internal.part.listener.RepresentationLinkPostCommitListener;
import org.eclipse.sirius.diagram.ui.edit.internal.part.listener.SynchronizedStatusPostCommitListener;
import org.eclipse.sirius.diagram.ui.edit.internal.part.listener.VisibilityPostCommitListener;
import org.eclipse.sirius.diagram.ui.internal.refresh.layout.SiriusCanonicalLayoutHandler;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.GMFDiagramUpdater;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorUtil;
import org.eclipse.sirius.diagram.ui.part.ValidateAction;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.palette.PaletteManager;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.delete.DeleteFromModelWithHookAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.delete.DeleteWithHookAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.HideDDiagramElementAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.HideDDiagramElementLabelAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.RevealElementsAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.RevealOutlineLabelsAction;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.EMFCommandFactoryUI;
import org.eclipse.sirius.diagram.ui.tools.internal.dnd.DragAndDropWrapper;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramCommandStack;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramEditorSessionListenerDelegate;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DOperationHistoryListener;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramDialectEditorDialogFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramOutlinePage;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.SiriusPaletteToolDropTargetListener;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.SiriusRulerComposite;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.ToolFilterForLockedDRepresentation;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.header.DiagramHeaderComposite;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.Tabbar;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.TabbarRefresher;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.SynchronizeStatusFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.part.DDiagramRootEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.handler.SiriusMouseWheelZoomHandler;
import org.eclipse.sirius.diagram.ui.tools.internal.menu.DiagramEditorContextMenuProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.menu.DiagramMenuUpdater;
import org.eclipse.sirius.diagram.ui.tools.internal.outline.QuickOutlineControl;
import org.eclipse.sirius.diagram.ui.tools.internal.outline.SiriusInformationPresenter;
import org.eclipse.sirius.diagram.ui.tools.internal.outline.SiriusQuickOutlineInformationProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.PaletteManagerImpl;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.PaletteToolChangeListener;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.SiriusPaletteViewer;
import org.eclipse.sirius.diagram.ui.tools.internal.part.SiriusDiagramGraphicalViewer;
import org.eclipse.sirius.diagram.ui.tools.internal.resource.CustomSiriusDocumentProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.views.outlineview.DiagramOutlineWithBookPages;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline.OutlineComparator;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline.OutlineContentProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline.OutlineLabelProvider;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.LockStatus;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.EditingDomainUndoContext;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.tools.api.permission.DRepresentationPermissionStatusListener;
import org.eclipse.sirius.tools.api.permission.DRepresentationPermissionStatusQuery;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditorDialogFactory;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.marker.TraceabilityMarkerNavigationProvider;
import org.eclipse.sirius.ui.business.api.editor.ISiriusEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInputFactory;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.internal.editor.SelectDRepresentationElementsListener;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class DDiagramEditorImpl
extends SiriusDiagramEditor
implements DDiagramEditor,
ISelectionListener,
SessionListener {
    public static final String ID = "org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID";
    protected IUndoContext undoContext;
    protected AdapterFactory adapterFactory;
    private Session session;
    private KeyHandler keyHandler;
    private TemplateTransferDragSourceListener paletteTransferDragSourceListener;
    private SiriusPaletteToolDropTargetListener paletteTransferDropTargetListener;
    private AbstractTransferDropTargetListener transferDropTargetListener;
    private IDiagramCommandFactoryProvider emfCommandFactoryProvider;
    private boolean isClosing;
    private IPermissionAuthority authority;
    private IAuthorityListener dRepresentationLockStatusListener;
    private final SessionManagerListener sessionManagerListener = new SessionHandlingForEditor(this);
    private TabbarRefresher tabbarPostCommitListener;
    private DiagramHeaderPostCommitListener diagramHeaderPostCommitListener;
    private VisibilityPostCommitListener visibilityPostCommitListener;
    private SynchronizedStatusPostCommitListener statusBarPostCommitListener;
    private RepresentationLinkPostCommitListener representationLinkPostCommitListener;
    private GMFDiagramUpdater gmfDiagramUpdater;
    private DialectEditorDialogFactory myDialogFactory = new DiagramDialectEditorDialogFactory(this);
    private IOperationHistoryListener operationHistoryListener;
    private PaletteManager paletteManager;
    private Tabbar tabbar;
    private DiagramMenuUpdater diagramMenuUpdater;
    private ScrollingGraphicalViewer sGViewer;
    private DiagramHeaderComposite diagramHeaderComposite;
    private ToolFilter toolFilterWhenRepresentationIsLocked = new ToolFilterForLockedDRepresentation();
    private Composite parentComposite;
    private SelectDRepresentationElementsListener selectElementsListener;
    private Job refreshJob;
    private int choice = 3;
    private PaletteToolChangeListener paletteToolChangeListener;
    private Optional<Boolean> isLastRefreshSucceeded = Optional.empty();

    public DDiagramEditorImpl() {
        this.operationHistoryListener = new DOperationHistoryListener(this);
    }

    public DDiagramEditorImpl(IOperationHistoryListener operationHistoryListener) {
        this.operationHistoryListener = operationHistoryListener;
    }

    public Optional<Boolean> isLastRepresentationRefreshSucceeded() {
        return this.isLastRefreshSucceeded;
    }

    public void close(boolean save) {
        Tabbar currentTabbar;
        ToolManagement toolManagement = DiagramPlugin.getDefault().getToolManagement(this.getDiagram());
        if (toolManagement != null) {
            toolManagement.removeToolChangeListener((ToolChangeListener)this.paletteToolChangeListener);
            DiagramPlugin.getPlugin().removeToolManagement(this.getDiagram());
        }
        if ((currentTabbar = this.getTabbar()) != null) {
            currentTabbar.closingInProgress();
        }
        if (this.refreshJob != null) {
            try {
                this.refreshJob.join();
            }
            catch (InterruptedException e) {
                DiagramPlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.sirius.diagram", Messages.DDiagramEditorImpl_refreshJobInterruptedMsg, (Throwable)e));
            }
        }
        this.disposeGraphicalListeners();
        DRepresentation representation = this.getRepresentation();
        if (representation != null) {
            this.getRepresentation().getUiState().getDecorationImage().clear();
        }
        this.enableSanityChecking(false);
        Display display = Display.getCurrent();
        if (display == null) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        if (!display.isDisposed()) {
            Optional.ofNullable(this.getSite()).map(IWorkbenchSite::getPage).ifPresent(page -> page.removeSelectionListener((ISelectionListener)this));
            Optional.ofNullable(this.getSite()).map(IWorkbenchSite::getWorkbenchWindow).map(IWorkbenchWindow::getSelectionService).ifPresent(selectionService -> selectionService.removeSelectionListener((ISelectionListener)this));
            display.asyncExec(() -> {
                try {
                    IWorkbenchPage page;
                    IWorkbenchPartSite site;
                    if (this.getGraphicalViewer() != null && !PlatformUI.getWorkbench().isClosing() && (site = this.getSite()) != null && (page = site.getPage()) != null) {
                        page.closeEditor((IEditorPart)this, save);
                    }
                }
                catch (IllegalStateException illegalStateException) {}
            });
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IEditorInput correctedInput = this.getCorrectedInput(input);
        if (correctedInput instanceof SessionEditorInput) {
            this.session = ((SessionEditorInput)correctedInput).getSession();
        }
        try {
            if (this.getSession() != null) {
                Collection sessions = SessionManager.INSTANCE.getSessions();
                if (sessions.isEmpty() && !this.isClosing) {
                    SessionManager.INSTANCE.addSessionsListener(this.sessionManagerListener);
                }
                this.isClosing = false;
                this.initUndoContext();
                SiriusDiagramSessionEventBroker.getInstance((Session)this.getSession());
            }
            super.init(site, correctedInput);
            if (this.getSession() != null) {
                this.getSession().addListener((SessionListener)this);
                IEditingSession editingSession = SessionUIManager.INSTANCE.getOrCreateUISession(this.getSession());
                editingSession.open();
                editingSession.attachEditor((ISiriusEditor)this);
            }
            this.initCommandFactoryProviders();
            this.notify(1);
            this.initPermissionAuthority();
            this.activateTransientLayers();
        }
        catch (NullPointerException e) {
            DiagramPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.diagram", Messages.DDiagramEditorImpl_noSessionMsg, (Throwable)e));
        }
    }

    private void activateTransientLayers() {
        DDiagram diagram = (DDiagram)this.getRepresentation();
        if (diagram != null && !diagram.isSetActivatedTransientLayers()) {
            ArrayList transientLayersToActivate = new ArrayList();
            LayerHelper.getInitialActiveLayers((DiagramDescription)diagram.getDescription(), (Collection)this.session.getSelectedViewpoints(false), new ArrayList(), transientLayersToActivate);
            org.eclipse.emf.common.command.CommandStack commandStack = this.session.getTransactionalEditingDomain().getCommandStack();
            transientLayersToActivate.stream().forEach(layer -> commandStack.execute((Command)new ChangeLayerActivationCommand(this.session.getTransactionalEditingDomain(), diagram, (Layer)layer, (IProgressMonitor)new NullProgressMonitor())));
        }
    }

    private void initUndoContext() {
        if (this.undoContext == null) {
            TransactionalEditingDomain domain = this.getEditingDomain();
            this.undoContext = domain != null ? (domain.getCommandStack() instanceof IWorkspaceCommandStack ? ((IWorkspaceCommandStack)domain.getCommandStack()).getDefaultUndoContext() : new EditingDomainUndoContext((EditingDomain)domain)) : new ObjectUndoContext((Object)this);
        }
    }

    private IEditorInput getCorrectedInput(IEditorInput input) {
        if (input instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            URI analysisURI = URI.createPlatformResourceURI((String)("/" + file.getProject().getName() + "/" + file.getProjectRelativePath()), (boolean)true);
            return new SessionEditorInputFactory().create(analysisURI);
        }
        return input;
    }

    public void createPartControl(Composite parent) {
        block7: {
            try {
                SessionEditorInput sessionEditorInput;
                IStatus status;
                super.createPartControl(parent);
                if (this.session == null && this.getEditorInput() instanceof SessionEditorInput && (status = (sessionEditorInput = (SessionEditorInput)this.getEditorInput()).getStatus()).getSeverity() >= 4) {
                    RootEditPart rootEditPart = this.getGraphicalViewer().getRootEditPart();
                    if (rootEditPart instanceof LayerManager) {
                        LayerManager layerManager = (LayerManager)rootEditPart;
                        IFigure layer = layerManager.getLayer((Object)"Printable Layers");
                        String message = MessageFormat.format(Messages.DDiagramEditorImpl_editorToBeClosedAndReopenedSinceContentIsNotAccessible, status.getMessage());
                        layer.add((IFigure)new Label(message));
                    }
                    return;
                }
                if (this.getEditingDomain() != null) {
                    this.tabbarPostCommitListener = new TabbarRefresher(this.getEditingDomain());
                    this.visibilityPostCommitListener = new VisibilityPostCommitListener(this.getDiagramEditPart());
                    this.statusBarPostCommitListener = new SynchronizedStatusPostCommitListener(this);
                    this.representationLinkPostCommitListener = new RepresentationLinkPostCommitListener(this);
                    if (this.isHeaderSectionEnabled()) {
                        this.diagramHeaderPostCommitListener = new DiagramHeaderPostCommitListener(this.getEditingDomain(), this.getDiagramHeader());
                    }
                    if (!this.getPermissionAuthority().canEditInstance((EObject)this.getRepresentation())) {
                        this.notify(14);
                    }
                }
            }
            catch (AssertionError | ClassCastException | IllegalArgumentException | NullPointerException e) {
                DiagramUIPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.diagram.ui", ((Throwable)e).getMessage(), (Throwable)e));
                Boolean response = SiriusEditPlugin.getPlugin().getUiCallback().askUserToRefreshTheDiagram();
                this.close(false);
                if (!response.booleanValue()) break block7;
                this.launchRefresh(true);
                DRepresentation currentDRepresentation = this.getRepresentation();
                Display.getCurrent().asyncExec(() -> DialectUIManager.INSTANCE.openEditor(this.session, currentDRepresentation, (IProgressMonitor)new NullProgressMonitor()));
            }
        }
    }

    protected PaletteViewer constructPaletteViewer() {
        SiriusPaletteViewer pv = new SiriusPaletteViewer();
        this.paletteTransferDragSourceListener = new TemplateTransferDragSourceListener((EditPartViewer)pv);
        pv.addDragSourceListener((TransferDragSourceListener)this.paletteTransferDragSourceListener);
        if (this.paletteManager != null) {
            TransactionalEditingDomain editingDomain = this.getSession().getTransactionalEditingDomain();
            UpdateToolRecordingCommand updateToolRecordingCommand = new UpdateToolRecordingCommand(editingDomain, (DDiagram)this.getDiagram().getElement(), true);
            editingDomain.getCommandStack().execute((Command)updateToolRecordingCommand);
            DiagramPlugin.getDefault().getToolManagement(this.getDiagram()).notifyToolChange();
        }
        return pv;
    }

    public void setTitleImage(Image titleImage) {
        super.setTitleImage(titleImage);
    }

    private void initPermissionAuthority() {
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(diagram.getElement());
            this.dRepresentationLockStatusListener = new DRepresentationPermissionStatusListener((DSemanticDecorator)((DSemanticDiagram)diagram.getElement()), (SessionListener)this);
            permissionAuthority.addAuthorityListener(this.dRepresentationLockStatusListener);
            if (!permissionAuthority.canEditInstance((EObject)this.getRepresentation())) {
                this.notify(14);
            } else if (LockStatus.LOCKED_BY_ME.equals((Object)permissionAuthority.getLockStatus(this.getDiagram().getElement()))) {
                this.notify(12);
            }
        }
    }

    @Override
    public IDiagramCommandFactoryProvider getEmfCommandFactoryProvider() {
        return this.emfCommandFactoryProvider;
    }

    @Override
    public void setEmfCommandFactoryProvider(IDiagramCommandFactoryProvider emfCommandFactoryProvider) {
        this.emfCommandFactoryProvider = emfCommandFactoryProvider;
        this.configureCommandFactoryProviders();
    }

    protected KeyHandler getKeyHandler() {
        if (this.keyHandler == null && this.session != null) {
            this.keyHandler = super.getKeyHandler();
            ActionRegistry registry = this.getActionRegistry();
            DeleteFromModelWithHookAction deleteFromModelAction = new DeleteFromModelWithHookAction((IWorkbenchPart)this);
            deleteFromModelAction.init();
            registry.registerAction((IAction)deleteFromModelAction);
            DeleteWithHookAction deleteAction = new DeleteWithHookAction((IWorkbenchPart)this);
            deleteAction.setText(DiagramUIMessages.DiagramEditor_Delete_from_Diagram);
            registry.registerAction((IAction)deleteAction);
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'\u0004', (int)100, (int)262144), this.getActionRegistry().getAction((Object)"deleteFromModelAction"));
        }
        return this.keyHandler;
    }

    private void modelerDescriptionFilesLoaded() {
        if (this.isAutoRefresh()) {
            this.refreshJob = new Job(Messages.DDiagramEditorImpl_refreshJobLabel){

                protected IStatus run(IProgressMonitor monitor) {
                    DDiagramEditorImpl.this.launchRefresh(false);
                    return Status.OK_STATUS;
                }
            };
            this.refreshJob.schedule();
        }
    }

    private void initCommandFactoryProviders() {
        this.emfCommandFactoryProvider = DiagramCommandFactoryService.getInstance().getNewProvider();
        this.configureCommandFactoryProviders();
    }

    private void configureCommandFactoryProviders() {
        TransactionalEditingDomain domain = this.getEditingDomain();
        if (domain != null) {
            IDiagramCommandFactory diagramCommandFactory = this.emfCommandFactoryProvider.getCommandFactory(domain);
            diagramCommandFactory.setUserInterfaceCallBack((UICallBack)new EMFCommandFactoryUI());
        }
    }

    protected TransactionalEditingDomain createEditingDomain() {
        if (this.getSession() != null) {
            return this.getSession().getTransactionalEditingDomain();
        }
        return null;
    }

    protected void hookGraphicalViewer() {
        super.hookGraphicalViewer();
        this.paletteManager = new PaletteManagerImpl((EditDomain)this.getEditDomain());
        ToolManagement toolManagement = DiagramPlugin.getDefault().getToolManagement(this.getDiagram());
        if (toolManagement != null) {
            this.paletteToolChangeListener = new PaletteToolChangeListener(this.getPaletteManager(), this.getDiagram());
            toolManagement.addToolChangeListener((ToolChangeListener)this.paletteToolChangeListener);
            if (this.getSession() != null) {
                TransactionImpl t = new TransactionImpl(this.session.getTransactionalEditingDomain(), false, Collections.EMPTY_MAP);
                try {
                    t.start();
                    UpdateToolRecordingCommand updateToolRecordingCommand = new UpdateToolRecordingCommand(this.session.getTransactionalEditingDomain(), (DDiagram)this.getDiagram().getElement(), true);
                    if (updateToolRecordingCommand.canExecute()) {
                        updateToolRecordingCommand.execute();
                    }
                    t.commit();
                    toolManagement.notifyToolChange();
                }
                catch (InterruptedException | RollbackException e) {
                    DiagramPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.diagram", Messages.DDiagramEditorImpl_updateToolFailure, e));
                }
            }
        }
        this.paletteTransferDropTargetListener = new SiriusPaletteToolDropTargetListener((EditPartViewer)this.getGraphicalViewer());
        this.getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)this.paletteTransferDropTargetListener);
        if (this.getSession() != null) {
            IInterpreter interpreter = this.getSession().getInterpreter();
            InterpreterRegistry.prepareImportsFromSession((IInterpreter)interpreter, (Session)this.getSession());
        }
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.selectElementsListener = new SelectDRepresentationElementsListener((DialectEditor)this, false);
    }

    public void dispose() {
        PaletteViewer paletteViewer;
        IEditingSession editingSession;
        this.isClosing = true;
        if (this.getTabbar() != null) {
            this.getTabbar().dispose();
            this.setTabbar(null);
        }
        this.disposeGraphicalListeners();
        Diagram diagram = this.getDiagram();
        if (diagram != null && diagram.eResource() != null) {
            ToolManagement toolManagement = DiagramPlugin.getDefault().getToolManagement(diagram);
            if (toolManagement != null) {
                toolManagement.removeToolChangeListener((ToolChangeListener)this.paletteToolChangeListener);
                DiagramPlugin.getPlugin().removeToolManagement(diagram);
            }
            if (this.dRepresentationLockStatusListener != null) {
                IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(diagram.getElement());
                permissionAuthority.removeAuthorityListener(this.dRepresentationLockStatusListener);
            }
        }
        SessionManager.INSTANCE.removeSessionsListener(this.sessionManagerListener);
        this.dRepresentationLockStatusListener = null;
        if (this.getSession() != null) {
            this.getSession().removeListener((SessionListener)this);
        }
        if (this.selectElementsListener != null) {
            this.selectElementsListener.dispose();
            this.selectElementsListener = null;
        }
        if (this.getGraphicalViewer() != null) {
            this.getGraphicalViewer().removeDropTargetListener((TransferDropTargetListener)this.transferDropTargetListener);
        }
        if (this.getDiagram() != null && this.getSession() != null && (editingSession = SessionUIManager.INSTANCE.getUISession(this.getSession())) != null) {
            editingSession.detachEditor((ISiriusEditor)this, this.choice == 1);
        }
        if (this.getSite() != null) {
            this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        }
        this.getOperationHistory().removeOperationHistoryListener(this.operationHistoryListener);
        if (this.adapterFactory instanceof IDisposable) {
            ((IDisposable)this.adapterFactory).dispose();
        }
        if ((paletteViewer = this.getPaletteViewerProvider().getEditDomain().getPaletteViewer()) != null) {
            paletteViewer.removeDragSourceListener((TransferDragSourceListener)this.paletteTransferDragSourceListener);
            this.getGraphicalViewer().removeDropTargetListener((TransferDropTargetListener)this.paletteTransferDropTargetListener);
        }
        if (this.paletteManager != null) {
            this.paletteManager.dispose();
            this.paletteManager = null;
        }
        if (this.sGViewer != null) {
            if (this.sGViewer.getControl() != null) {
                this.sGViewer.getControl().dispose();
            }
            this.sGViewer = null;
        }
        IUndoContext savedUndoContext = this.getUndoContext();
        this.setUndoContext((IUndoContext)new UndoContext());
        super.dispose();
        this.setUndoContext(savedUndoContext);
        this.stopDiagramEventBrokerListener(this.getEditingDomain());
        this.removeSelfFromListeners();
    }

    private void removeSelfFromListeners() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        Optional fieldValueWithoutException = ReflectionHelper.getFieldValueWithoutException((Object)selectionService, (String)"listeners");
        if (selectionService != null && fieldValueWithoutException.isPresent()) {
            if (fieldValueWithoutException.filter(ListenerList.class::isInstance).isPresent()) {
                selectionService.removeSelectionListener((ISelectionListener)this);
            }
        }
    }

    public void persistViewerSettings() {
        if (this.getDiagramEditPart() != null) {
            super.persistViewerSettings();
        }
    }

    protected void disposeGraphicalListeners() {
        this.disposePostCommitListener();
        if (this.gmfDiagramUpdater != null) {
            this.gmfDiagramUpdater.dispose();
            this.gmfDiagramUpdater = null;
        }
    }

    private void disposePostCommitListener() {
        if (this.tabbarPostCommitListener != null) {
            this.tabbarPostCommitListener.dispose();
            this.tabbarPostCommitListener = null;
        }
        if (this.visibilityPostCommitListener != null) {
            this.visibilityPostCommitListener.dispose();
            this.visibilityPostCommitListener = null;
        }
        if (this.statusBarPostCommitListener != null) {
            this.statusBarPostCommitListener.dispose();
            this.statusBarPostCommitListener = null;
        }
        if (this.diagramHeaderPostCommitListener != null) {
            this.diagramHeaderPostCommitListener.dispose();
            this.diagramHeaderPostCommitListener = null;
        }
        if (this.representationLinkPostCommitListener != null) {
            this.representationLinkPostCommitListener.dispose();
            this.representationLinkPostCommitListener = null;
        }
    }

    protected void configureGraphicalViewer() {
        if (this.getDiagram() != null) {
            super.configureGraphicalViewer();
            DiagramEditorContextMenuProvider provider = new DiagramEditorContextMenuProvider((IWorkbenchPart)this, (EditPartViewer)this.getDiagramGraphicalViewer());
            this.getDiagramGraphicalViewer().setContextMenu((MenuManager)provider);
            this.getSite().registerContextMenu("org.eclipse.gmf.runtime.diagram.ui.DiagramEditorContextMenu", (MenuManager)provider, (ISelectionProvider)this.getDiagramGraphicalViewer());
            this.getOperationHistory().addOperationHistoryListener(this.operationHistoryListener);
        } else {
            this.workspaceViewerPreferenceStore = new PreferenceStore();
            if (this.getDiagramGraphicalViewer() instanceof DiagramGraphicalViewer) {
                ((DiagramGraphicalViewer)this.getDiagramGraphicalViewer()).hookWorkspacePreferenceStore((IPreferenceStore)this.getWorkspaceViewerPreferenceStore());
            }
        }
    }

    private DiagramOutlinePage initOutline() {
        IObjectActionDelegateWrapper[] outlinePopupMenuActions = new IObjectActionDelegateWrapper[]{new IObjectActionDelegateWrapper(new HideDDiagramElementAction(HideDDiagramElement.HIDE_ELEMENT_LABEL), HideDDiagramElement.HIDE_ELEMENT_LABEL){

            public ImageDescriptor getImageDescriptor() {
                return ((IAction)this.getWrappedAction()).getImageDescriptor();
            }

            public boolean isEnabled() {
                Object selectedObject;
                if (this.currentSelection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)this.currentSelection).getFirstElement()) instanceof DDiagramElement) {
                    boolean isHidden = !new DDiagramElementQuery((DDiagramElement)selectedObject).isHidden();
                    boolean wrappedActionEnabled = ((IAction)this.getWrappedAction()).isEnabled();
                    return isHidden && wrappedActionEnabled;
                }
                return false;
            }
        }, new IObjectActionDelegateWrapper(new HideDDiagramElementLabelAction(HideDDiagramElementLabel.HIDE_LABEL), HideDDiagramElementLabel.HIDE_LABEL){

            public ImageDescriptor getImageDescriptor() {
                return ((IAction)this.getWrappedAction()).getImageDescriptor();
            }

            public boolean isEnabled() {
                boolean result = false;
                if (this.currentSelection instanceof IStructuredSelection) {
                    Option<DDiagramElement> optionTarget;
                    Object selectedObject = ((IStructuredSelection)this.currentSelection).getFirstElement();
                    if (selectedObject instanceof DDiagramElement) {
                        DDiagramElementQuery query = new DDiagramElementQuery((DDiagramElement)selectedObject);
                        result = query.canHideLabel() && !query.isLabelHidden();
                    } else if (selectedObject instanceof AbstractDDiagramElementLabelItemProvider && (optionTarget = ((AbstractDDiagramElementLabelItemProvider)((Object)selectedObject)).getDiagramElementTarget()).some()) {
                        DDiagramElementQuery query = new DDiagramElementQuery((DDiagramElement)optionTarget.get());
                        result = query.canHideLabel() && !query.isLabelHidden();
                    }
                }
                return result;
            }
        }, new IObjectActionDelegateWrapper(new RevealElementsAction(), Messages.RevealOutlineElementsAction_label){

            public ImageDescriptor getImageDescriptor() {
                return ((IAction)this.getWrappedAction()).getImageDescriptor();
            }

            public boolean isEnabled() {
                Object selectedObject;
                if (this.currentSelection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)this.currentSelection).getFirstElement()) instanceof DDiagramElement) {
                    return new DDiagramElementQuery((DDiagramElement)selectedObject).isHidden();
                }
                return false;
            }
        }, new IObjectActionDelegateWrapper(new RevealOutlineLabelsAction(), Messages.RevealOutlineLabelsAction_label){

            public ImageDescriptor getImageDescriptor() {
                return ((IAction)this.getWrappedAction()).getImageDescriptor();
            }

            public boolean isEnabled() {
                boolean result = false;
                if (this.currentSelection instanceof IStructuredSelection) {
                    Option<DDiagramElement> optionTarget;
                    Object selectedObject = ((IStructuredSelection)this.currentSelection).getFirstElement();
                    if (selectedObject instanceof DDiagramElement) {
                        DDiagramElementQuery query = new DDiagramElementQuery((DDiagramElement)selectedObject);
                        result = query.isLabelHidden();
                    } else if (selectedObject instanceof AbstractDDiagramElementLabelItemProvider && (optionTarget = ((AbstractDDiagramElementLabelItemProvider)((Object)selectedObject)).getDiagramElementTarget()).some()) {
                        DDiagramElementQuery query = new DDiagramElementQuery((DDiagramElement)optionTarget.get());
                        result = query.isLabelHidden();
                    }
                }
                return result;
            }
        }};
        DiagramOutlinePage outline = null;
        outline = this.isOldUIEnabled() ? new DiagramOutlineWithBookPages(this.getDiagramEditPart().getModel(), this.getGraphicalViewer(), outlinePopupMenuActions) : new DiagramOutlinePage(this.getDiagramEditPart() != null ? this.getDiagramEditPart().getModel() : null, (IBaseLabelProvider)new OutlineLabelProvider(), new OutlineContentProvider(), new OutlineComparator(), this.getGraphicalViewer(), outlinePopupMenuActions);
        outline.setDiagramWorkbenchPart((IDiagramWorkbenchPart)this);
        return outline;
    }

    public void setFocus() {
        if (this.getDiagram() != null) {
            super.setFocus();
            for (EditPart editPart : this.getDiagramGraphicalViewer().getRootEditPart().getChildren()) {
                Optional<DSemanticDiagram> optionalSemanticElement;
                if (!editPart.isActive() || !(editPart instanceof AbstractDDiagramEditPart) || !(optionalSemanticElement = this.getDSemanticDiagram((GraphicalEditPart)editPart)).isPresent() || !this.isSemanticDiagramOK(optionalSemanticElement.get())) continue;
                if (SessionManager.INSTANCE.getSession(optionalSemanticElement.get().getTarget()) != null) {
                    this.myDialogFactory.editorWillBeClosedInformationDialog(this.getSite().getShell());
                    this.close(false);
                }
                return;
            }
            if (this.getOperationHistory() != null) {
                this.getOperationHistory().addOperationHistoryListener(this.operationHistoryListener);
            }
            this.setEclipseWindowTitle();
        }
    }

    private boolean isSemanticDiagramOK(DSemanticDiagram semanticDiagram) {
        return semanticDiagram != null && (semanticDiagram.eResource() == null || semanticDiagram.getTarget() == null || semanticDiagram.getTarget().eResource() == null);
    }

    private Optional<DSemanticDiagram> getDSemanticDiagram(GraphicalEditPart editPart) {
        EObject resolveSemanticElement;
        block3: {
            resolveSemanticElement = null;
            try {
                resolveSemanticElement = editPart.resolveSemanticElement();
            }
            catch (IllegalStateException e) {
                if (new IllegalStateExceptionQuery(e).isAConnectionLostException()) break block3;
                throw e;
            }
        }
        if (resolveSemanticElement instanceof DSemanticDiagram) {
            return Optional.of((DSemanticDiagram)resolveSemanticElement);
        }
        return Optional.empty();
    }

    private void setEclipseWindowTitle() {
        String title = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getText();
        int end = title.lastIndexOf(".aird#");
        int end2 = title.lastIndexOf(" - ");
        if (end > -1) {
            title = String.valueOf(title.substring(0, end + 5)) + this.getPartName() + title.substring(end2);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setText(title);
        }
    }

    protected ScrollingGraphicalViewer createScrollingGraphicalViewer() {
        return new SiriusDiagramGraphicalViewer();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.isClosing) {
            return;
        }
        super.selectionChanged(part, selection);
        if (this.getTabbar() != null) {
            this.getTabbar().selectionChanged(part, selection);
        }
        if (this.diagramMenuUpdater != null) {
            this.diagramMenuUpdater.selectionChanged(part, selection);
        }
        if (this == part) {
            return;
        }
        if (this.isDiagramOutlinePage(part) && selection instanceof IStructuredSelection) {
            List selected = ((IStructuredSelection)selection).toList();
            ArrayList result = new ArrayList(selected.size());
            IDiagramGraphicalViewer viewer = this.getDiagramGraphicalViewer();
            if (viewer != null) {
                for (Object object : selected) {
                    Option<DDiagramElement> diagramElementTarget;
                    if (object instanceof EObject) {
                        try {
                            String elementID = EMFCoreUtil.getProxyID((EObject)((EObject)object));
                            List concernedEditParts = viewer.findEditPartsForElement(elementID, IGraphicalEditPart.class);
                            result.addAll(concernedEditParts);
                        }
                        catch (IllegalStateException illegalStateException) {
                            if (!DiagramUIPlugin.getPlugin().isDebugging()) continue;
                            DiagramUIPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.diagram.ui", Messages.DDiagramEditorImpl_cdoServerConnectionPbMsg));
                        }
                        continue;
                    }
                    if (!(object instanceof AbstractDDiagramElementLabelItemProvider) || !(diagramElementTarget = ((AbstractDDiagramElementLabelItemProvider)((Object)object)).getDiagramElementTarget()).some()) continue;
                    String elementID = EMFCoreUtil.getProxyID((EObject)((EObject)diagramElementTarget.get()));
                    List concernedEditParts = viewer.findEditPartsForElement(elementID, IGraphicalEditPart.class);
                    result.addAll(Sets.newHashSet((Iterable)Iterables.filter((Iterable)concernedEditParts, AbstractDiagramNameEditPart.class)));
                }
                if (!result.isEmpty()) {
                    try {
                        this.getDiagramGraphicalViewer().reveal((EditPart)result.get(0));
                        this.getDiagramGraphicalViewer().setSelection((ISelection)new StructuredSelection(result));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            }
        }
    }

    private boolean isDiagramOutlinePage(IWorkbenchPart part) {
        GraphicalViewer graphicalViewer;
        IPage page;
        if (part instanceof ContentOutline && (page = ((ContentOutline)part).getCurrentPage()) instanceof DiagramOutlinePage && (graphicalViewer = this.getGraphicalViewer()) != null) {
            Control control = ((DiagramOutlinePage)page).getEditor();
            return control == graphicalViewer.getControl();
        }
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    @Override
    public Session getSession() {
        if (this.session == null) {
            this.session = new EObjectQuery((EObject)this.getDiagram()).getSession();
        }
        return this.session;
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (this.getSession() != null) {
            this.setDocumentProvider((IDocumentProvider)DiagramUIPlugin.getPlugin().getDocumentProvider(this.getSession().getTransactionalEditingDomain()));
        } else {
            this.setDocumentProvider((IDocumentProvider)new CustomSiriusDocumentProvider());
        }
    }

    protected IDocumentProvider getDocumentProvider(IEditorInput input) {
        if (input instanceof IFileEditorInput || input instanceof URIEditorInput) {
            return DiagramUIPlugin.getPlugin().getDocumentProvider(this.getSession().getTransactionalEditingDomain());
        }
        return super.getDocumentProvider(input);
    }

    public DiagramEditPart getDiagramEditPart() {
        if (this.getGraphicalViewer() == null) {
            return null;
        }
        return super.getDiagramEditPart();
    }

    @Override
    public IPermissionAuthority getPermissionAuthority() {
        if (this.authority == null) {
            this.authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(this.getEditingDomain().getResourceSet());
        }
        return this.authority;
    }

    public boolean needsRefresh(int propId) {
        boolean result = false;
        if (propId == 258) {
            if (this.isAutoRefresh()) {
                result = true;
            }
        } else if (propId == 259) {
            result = true;
        }
        return result;
    }

    public void validateRepresentation() {
        ValidateAction.runValidation(this.getDiagramEditPart(), (View)this.getDiagram());
    }

    public void notify(int changeKind) {
        DDiagramEditorSessionListenerDelegate dDiagramEditorSessionListenerDelegate = new DDiagramEditorSessionListenerDelegate(this, this.toolFilterWhenRepresentationIsLocked, changeKind);
        if (Display.getCurrent() == null && changeKind != 4) {
            EclipseUIUtil.displayAsyncExec((Runnable)dDiagramEditorSessionListenerDelegate);
        } else {
            dDiagramEditorSessionListenerDelegate.run();
        }
        switch (changeKind) {
            case 16: {
                this.modelerDescriptionFilesLoaded();
                break;
            }
        }
    }

    public void firePropertyChangeInUIThread(final int notificationKind) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EObject element;
                Diagram diagram;
                if (notificationKind == 1 && (diagram = DDiagramEditorImpl.this.getDiagram()) != null && (element = diagram.getElement()) instanceof DSemanticDiagram) {
                    String editorName = DialectUIManager.INSTANCE.getEditorName((DRepresentation)((DSemanticDiagram)element));
                    DDiagramEditorImpl.this.setPartName(editorName);
                }
                DDiagramEditorImpl.this.firePropertyChange(notificationKind);
            }
        };
        if (Display.getCurrent() == null) {
            EclipseUIUtil.displayAsyncExec((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    private boolean isAutoRefresh() {
        return new DRepresentationQuery(this.getRepresentation()).isAutoRefresh();
    }

    private void launchRefresh(boolean opening) {
        try {
            Diagram gmfDiag = this.getDiagram();
            if (gmfDiag != null) {
                EObject eObject = gmfDiag.getElement();
                RefreshRepresentationsCommand command = null;
                if (eObject instanceof DSemanticDiagram) {
                    DSemanticDiagram dDiagram = (DSemanticDiagram)eObject;
                    if (opening) {
                        CompoundCommand compoundCommand = new CompoundCommand();
                        RefreshDiagramOnOpeningCommand refreshOnOpeningCmd = new RefreshDiagramOnOpeningCommand(this.getEditingDomain(), dDiagram);
                        compoundCommand.append((Command)refreshOnOpeningCmd);
                        compoundCommand.setLabel(refreshOnOpeningCmd.getLabel());
                        CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(gmfDiag);
                        SynchronizeGMFModelCommand synchronizeGMFModel = new SynchronizeGMFModelCommand(this.getEditingDomain(), canonicalSynchronizer);
                        compoundCommand.append((Command)synchronizeGMFModel);
                        command = compoundCommand;
                    } else {
                        command = new RefreshRepresentationsCommand(this.getEditingDomain(), (IProgressMonitor)new NullProgressMonitor(), new DRepresentation[]{dDiagram});
                    }
                    this.getEditingDomain().getCommandStack().execute((Command)command);
                }
            }
            this.isLastRefreshSucceeded = Optional.of(Boolean.TRUE);
        }
        catch (AssertionError | ClassCastException | IllegalArgumentException | NullPointerException e) {
            DiagramPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.diagram", MessageFormat.format(Messages.DDiagramEditorImpl_error_representationRefresh, this.getRepresentation().getName()), (Throwable)e));
            this.isLastRefreshSucceeded = Optional.of(Boolean.FALSE);
        }
    }

    protected void handleEditorInputChanged() {
        super.handleEditorInputChanged();
        if (this.isAutoRefresh()) {
            this.launchRefresh(false);
        }
    }

    @Override
    public Object getAdapter(Class type) {
        Object adapter = null;
        if (type == IDiagramCommandFactoryProvider.class) {
            adapter = this.emfCommandFactoryProvider;
        } else if (type == IContentOutlinePage.class) {
            adapter = this.initOutline();
        } else if (type == EditingDomain.class || type == TransactionalEditingDomain.class) {
            adapter = this.getEditingDomain();
        } else if (type == IDiagramWorkbenchPart.class) {
            adapter = this;
        }
        return adapter != null || this.session == null ? adapter : super.getAdapter(type);
    }

    @Override
    public TransactionalEditingDomain getEditingDomain() {
        if (this.getSession() != null) {
            return this.getSession().getTransactionalEditingDomain();
        }
        return null;
    }

    protected String getEditingDomainID() {
        if (this.getSession() != null) {
            return this.getSession().getTransactionalEditingDomain().getID();
        }
        return null;
    }

    protected void createGraphicalViewer(Composite parent) {
        this.diagramMenuUpdater = new DiagramMenuUpdater((IDiagramWorkbenchPart)this);
        this.parentComposite = this.createParentComposite(parent);
        if (!this.isOldUIEnabled() && this.session != null) {
            this.setTabbar(new Tabbar(this.parentComposite, (IDiagramWorkbenchPart)this));
        }
        this.createHeaderSection(this.parentComposite);
        this.createMainDiagramSection(this.parentComposite);
        this.getGraphicalControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Optional<SynchronizeStatusFigure> syncStatusFigure;
                if (DDiagramEditorImpl.this.getDiagramGraphicalViewer().getRootEditPart() instanceof DiagramRootEditPart && (syncStatusFigure = SynchronizeStatusFigure.getDiagramSynchronizeStatusFigure((DiagramRootEditPart)DDiagramEditorImpl.this.getDiagramGraphicalViewer().getRootEditPart())).isPresent()) {
                    syncStatusFigure.get().updateLocation();
                }
            }
        });
    }

    private boolean isOldUIEnabled() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram.ui", SiriusDiagramUiPreferencesKeys.PREF_OLD_UI.name(), false, null);
    }

    private void createMainDiagramSection(Composite composite) {
        Composite mainSection = new Composite(composite, 0);
        mainSection.setLayoutData((Object)new GridData(1808));
        mainSection.setLayout((Layout)new FillLayout());
        this.createOriginalGraphicalViewer(mainSection);
    }

    private void createHeaderSection(Composite composite) {
        if (this.isHeaderSectionEnabled()) {
            this.diagramHeaderComposite = new DiagramHeaderComposite(composite, (IDiagramWorkbenchPart)this);
        }
    }

    private Composite createParentComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    public boolean isHeaderSectionEnabled() {
        boolean result = false;
        DRepresentation representation = this.getRepresentation();
        if (representation instanceof DDiagram) {
            result = new DDiagramGraphicalQuery((DDiagram)representation).isHeaderSectionEnabled();
        }
        return result;
    }

    protected Control getGraphicalControl() {
        return this.parentComposite;
    }

    public Tabbar getTabbar() {
        return this.tabbar;
    }

    protected void setTabbar(Tabbar tabbar) {
        this.tabbar = tabbar;
    }

    protected void createOriginalGraphicalViewer(Composite parent) {
        this.setRulerComposite(new SiriusRulerComposite(parent, 0));
        this.sGViewer = this.createScrollingGraphicalViewer();
        this.sGViewer.createControl((Composite)this.getRulerComposite());
        this.setGraphicalViewer((GraphicalViewer)this.sGViewer);
        this.hookGraphicalViewer();
        this.configureGraphicalViewer();
        this.initializeGraphicalViewer();
        this.getRulerComposite().setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
        if (this.sGViewer.getRootEditPart() instanceof DDiagramRootEditPart) {
            DDiagramRootEditPart rootEditPart = (DDiagramRootEditPart)this.sGViewer.getRootEditPart();
            rootEditPart.getZoomManager().setZoomLevelContributions(Arrays.asList(ZoomManager.FIT_ALL, ZoomManager.FIT_HEIGHT, ZoomManager.FIT_WIDTH));
        }
    }

    protected void setGraphicalViewer(GraphicalViewer viewer) {
        viewer.setProperty(ID, (Object)this);
        super.setGraphicalViewer(viewer);
    }

    protected void initializeGraphicalViewerContents() {
        super.initializeGraphicalViewerContents();
        this.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)262144), (Object)SiriusMouseWheelZoomHandler.SINGLETON);
    }

    protected void initializeGraphicalViewer() {
        if (this.getDiagram() != null) {
            if (this.getSession() != null && this.session.getSiriusPreferences().isRefreshOnRepresentationOpening()) {
                this.launchRefresh(true);
            }
            super.initializeGraphicalViewer();
            DiagramEditPart diagramEditPart = this.getDiagramEditPart();
            if (diagramEditPart != null) {
                SiriusCanonicalLayoutHandler.launchArrangeCommand(diagramEditPart);
            }
            this.transferDropTargetListener = new DDiagramEditorTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), (Transfer)LocalSelectionTransfer.getTransfer());
            this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)this.transferDropTargetListener);
            if (this.getDiagramHeader() != null) {
                this.getDiagramHeader().setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
                this.getDiagramHeader().rebuildHeaderSection();
            }
        }
    }

    protected void configureDiagramEditDomain() {
        DefaultEditDomain editDomain = this.getEditDomain();
        if (editDomain != null) {
            CommandStack stack = editDomain.getCommandStack();
            if (stack != null) {
                stack.dispose();
            }
            DDiagramCommandStack diagramStack = new DDiagramCommandStack(this.getDiagramEditDomain());
            diagramStack.setOperationHistory(this.getOperationHistory());
            diagramStack.setUndoContext(this.getUndoContext());
            editDomain.setCommandStack((CommandStack)diagramStack);
        }
    }

    public DRepresentation getRepresentation() {
        Diagram diag = this.getDiagram();
        if (diag != null && diag.eResource() != null && diag.getElement() instanceof DRepresentation) {
            return (DRepresentation)diag.getElement();
        }
        return null;
    }

    public Diagram getDiagram() {
        IDiagramDocument document;
        if (this.getDocumentProvider() != null && (document = (IDiagramDocument)this.getDocumentProvider().getDocument((Object)this.getEditorInput())) != null) {
            return document.getDiagram();
        }
        return super.getDiagram();
    }

    protected IUndoContext getUndoContext() {
        return this.undoContext;
    }

    protected void setUndoContext(IUndoContext context) {
        this.undoContext = context;
    }

    protected void stopListening() {
        if (this.getDocumentProvider() != null && this.getEditingDomain() == null) {
            super.stopListening();
        } else {
            IUndoContext savUndoContext = this.getUndoContext();
            this.setUndoContext(null);
            super.stopListening();
            this.setUndoContext(savUndoContext);
        }
    }

    public SiriusInformationPresenter getQuickOutlinePresenter() {
        SiriusInformationPresenter informationPresenter = new SiriusInformationPresenter(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new QuickOutlineControl(parent, 16, DDiagramEditorImpl.this);
            }
        });
        informationPresenter.install(this.getGraphicalControl());
        SiriusQuickOutlineInformationProvider provider = new SiriusQuickOutlineInformationProvider(this);
        informationPresenter.setInformationProvider(provider, "__dftl_partition_content_type");
        informationPresenter.setSizeConstraints(50, 30, true, false);
        informationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        return informationPresenter;
    }

    public void setDialogFactory(DialectEditorDialogFactory dialogFactory) {
        this.myDialogFactory = dialogFactory;
    }

    @Override
    public PaletteManager getPaletteManager() {
        return this.paletteManager;
    }

    @Override
    public IToolBarManager getTabBarManager() {
        if (this.getTabbar() != null) {
            return this.getTabbar().getToolBarManager();
        }
        return null;
    }

    private void gogo(IMarker marker) {
        if (marker.getAttribute("uri", null) == null) {
            super.gotoMarker(marker);
        } else {
            View targetView = this.getTargetView(marker);
            if (targetView != null) {
                Map editPartRegistry = this.getDiagramGraphicalViewer().getEditPartRegistry();
                EditPart targetEditPart = (EditPart)editPartRegistry.get(targetView);
                if (targetEditPart != null) {
                    SiriusDiagramEditorUtil.selectElementsInDiagram((IDiagramWorkbenchPart)this, Arrays.asList(targetEditPart));
                }
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this);
            }
        }
    }

    private View getTargetView(IMarker marker) {
        DRepresentationElement representationElement;
        EObject semanticDiagram;
        URI markerDDiagramURI;
        String representationURI = marker.getAttribute("REPRESENTATION_URI", null);
        String representationElementId = marker.getAttribute("REPRESENTATION_ELEMENT_ID", null);
        if (representationElementId != null && representationURI != null && (markerDDiagramURI = URI.createURI((String)representationURI)) != null && (semanticDiagram = this.getDiagram().eResource().getResourceSet().getEObject(markerDDiagramURI, true)) != null && (representationElement = (DRepresentationElement)semanticDiagram.eResource().getEObject(representationElementId)) != null) {
            return SiriusGMFHelper.getGmfView((DDiagramElement)representationElement);
        }
        return null;
    }

    @Override
    public void gotoMarker(IMarker marker) {
        if (TraceabilityMarkerNavigationProvider.isTraceabilityMarker((IMarker)marker)) {
            new TraceabilityMarkerNavigationProvider((DialectEditor)this).gotoMarker(marker);
        } else {
            this.gogo(marker);
        }
    }

    protected void stopDiagramEventBrokerListener(TransactionalEditingDomain ted) {
        int nbGMFDiagramEditorsOfSameTED = 0;
        if (this.getSite() != null && this.getSite().getPage() != null) {
            IEditorReference[] iEditorReferenceArray = this.getSite().getPage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                IEditorPart editorPart = editorRef.getEditor(false);
                if (editorPart instanceof DiagramEditor && !editorPart.equals(this) && ted != null && ted.equals(((DiagramEditor)editorPart).getEditingDomain())) {
                    ++nbGMFDiagramEditorsOfSameTED;
                }
                ++n2;
            }
        }
        if (nbGMFDiagramEditorsOfSameTED == 0 && ted != null) {
            DiagramEventBroker.stopListening((TransactionalEditingDomain)ted);
        }
    }

    @Override
    public AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = DiagramUIPlugin.getPlugin().getNewAdapterFactory();
        }
        return this.adapterFactory;
    }

    public void setInput(IEditorInput input) {
        DRepresentation representation;
        IEditorInput updatedEditorInput = input;
        if (this.session != null && input instanceof URIEditorInput) {
            EObject eObject;
            URI uri = ((URIEditorInput)input).getURI();
            URI repDescURI = Optional.of(input).filter(SessionEditorInput.class::isInstance).map(SessionEditorInput.class::cast).map(s -> s.getRepDescUri()).orElse(null);
            Optional<DDiagram> dDiagramOptional = Optional.ofNullable(repDescURI).map(rduri -> this.session.getTransactionalEditingDomain().getResourceSet().getEObject(rduri, false)).filter(DRepresentationDescriptor.class::isInstance).map(rd -> ((DRepresentationDescriptor)rd).getRepresentation()).map(DDiagram.class::cast);
            DDiagram dDiagram = dDiagramOptional.orElse(null);
            if (dDiagram == null && uri != null && !StringUtil.isEmpty((String)uri.fragment()) && (eObject = this.session.getTransactionalEditingDomain().getResourceSet().getEObject(uri, false)) instanceof DDiagram) {
                dDiagram = (DDiagram)eObject;
            }
            if (dDiagram != null) {
                DiagramCreationUtil util = new DiagramCreationUtil(dDiagram);
                if (!util.findAssociatedGMFDiagram()) {
                    DiagramPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.diagram", Messages.DDiagramEditorImpl_noAssociatedGMFDiagramMsg));
                }
                Diagram gmfDiag = util.getAssociatedGMFDiagram();
                updatedEditorInput = new SessionEditorInput(EcoreUtil.getURI((EObject)gmfDiag), repDescURI, dDiagram.getName(), this.session);
            }
        }
        super.setInput(updatedEditorInput);
        if (this.getGraphicalViewer() != null) {
            this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection());
        }
        if ((representation = this.getRepresentation()) instanceof DSemanticDecorator) {
            DSemanticDecorator dSemanticDecorator = (DSemanticDecorator)representation;
            DRepresentationPermissionStatusQuery dRepresentationPermissionStatusQuery = new DRepresentationPermissionStatusQuery(dSemanticDecorator);
            IPermissionAuthority permissionAuthority = this.getPermissionAuthority();
            LockStatus lockStatus = LockStatus.NOT_LOCKED;
            LockStatus dSemanticDecoratorLockStatus = permissionAuthority.getLockStatus((EObject)dSemanticDecorator);
            if (dSemanticDecoratorLockStatus != LockStatus.NOT_LOCKED) {
                lockStatus = dSemanticDecoratorLockStatus;
            }
            int associatedSessionListenerEvent = dRepresentationPermissionStatusQuery.getAssociatedSessionListenerEvent(lockStatus);
            this.notify(associatedSessionListenerEvent);
        }
        if (this.diagramHeaderComposite != null && !this.diagramHeaderComposite.isDisposed()) {
            this.diagramHeaderComposite.rebuildHeaderSection();
        }
        if (this.gmfDiagramUpdater != null) {
            this.gmfDiagramUpdater.dispose();
            this.gmfDiagramUpdater = null;
        }
        if (representation instanceof DDiagram) {
            this.gmfDiagramUpdater = new GMFDiagramUpdater(this.getSession(), (DDiagram)representation);
        }
    }

    public DialectEditorDialogFactory getDialogFactory() {
        return this.myDialogFactory;
    }

    public Saveable[] getSaveables() {
        IEditingSession uiSession;
        if (this.session != null && this.session.isOpen() && (uiSession = SessionUIManager.INSTANCE.getUISession(this.session)) instanceof ISaveablesSource) {
            return ((ISaveablesSource)uiSession).getSaveables();
        }
        return new Saveable[0];
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    public int promptToSaveOnClose() {
        IEditingSession uiSession;
        this.choice = 3;
        if (this.session != null && this.session.isOpen() && (uiSession = SessionUIManager.INSTANCE.getUISession(this.session)) != null && uiSession.needToBeSavedOnClose((IEditorPart)this)) {
            this.choice = uiSession.promptToSaveOnClose();
        }
        return this.choice;
    }

    public DiagramHeaderComposite getDiagramHeader() {
        return this.diagramHeaderComposite;
    }

    public void rebuildStatusLine() {
        super.rebuildStatusLine();
    }

    public void preClose() {
        if (this.getTabbar() != null) {
            this.getTabbar().dispose();
            this.setTabbar(null);
        }
        if (this.getSite() instanceof PartSite) {
            IActionBars actionBars = ((PartSite)this.getSite()).getActionBars();
            if (actionBars instanceof SubActionBars) {
                ((SubActionBars)actionBars).dispose();
            } else {
                ((PartSite)this.getSite()).deactivateActionBars(false);
            }
        }
        for (Object actionID : this.getSelectionActions()) {
            IAction action;
            if (!(actionID instanceof String) || !((action = this.getActionRegistry().getAction(actionID)) instanceof Disposable)) continue;
            ((Disposable)action).dispose();
        }
    }

    protected class DDiagramEditorTransferDropTargetListener
    extends AbstractTransferDropTargetListener {
        protected DDiagramEditorTransferDropTargetListener(EditPartViewer viewer, Transfer xfer) {
            super(viewer, xfer);
        }

        protected Request createTargetRequest() {
            LocalSelectionTransfer localSelectionTransfer;
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"drop");
            ArrayList<DragAndDropWrapper> list = new ArrayList<DragAndDropWrapper>(1);
            if (this.getCurrentEvent().data instanceof IStructuredSelection) {
                list.add(new DragAndDropWrapper(this.getCurrentEvent().data));
            } else if (this.getTransfer() instanceof LocalSelectionTransfer && (localSelectionTransfer = (LocalSelectionTransfer)this.getTransfer()).getSelection() instanceof IStructuredSelection) {
                list.add(new DragAndDropWrapper(localSelectionTransfer.getSelection()));
            }
            request.setEditParts(list);
            return request;
        }

        public void setCurrentEvent(DropTargetEvent currentEvent) {
            if (currentEvent != null && currentEvent.getSource() instanceof DropTarget) {
                Transfer[] transferArray;
                Transfer[] transferArray2 = transferArray = ((DropTarget)currentEvent.getSource()).getTransfer();
                int n = transferArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeSelection localSelectionTransfer;
                    Transfer transfer = transferArray2[n2];
                    if (transfer instanceof LocalSelectionTransfer && ((LocalSelectionTransfer)transfer).getSelection() instanceof TreeSelection && Iterables.isEmpty((Iterable)Iterables.filter((Iterable)(localSelectionTransfer = (TreeSelection)((LocalSelectionTransfer)transfer).getSelection()).toList(), DSemanticDecorator.class))) {
                        currentEvent.detail = 1;
                    }
                    ++n2;
                }
            }
            super.setCurrentEvent(currentEvent);
        }

        protected void updateTargetRequest() {
            Request request = this.getTargetRequest();
            ((ChangeBoundsRequest)request).setLocation(this.getDropLocation());
        }
    }

    private static final class SessionHandlingForEditor
    extends SessionManagerListener.Stub {
        private DDiagramEditorImpl editor;

        SessionHandlingForEditor(DDiagramEditorImpl editor) {
            this.editor = editor;
        }

        public void notifyAddSession(Session newSession) {
            IEditingSession editingSession = SessionUIManager.INSTANCE.getOrCreateUISession(newSession);
            if (!editingSession.isOpen()) {
                editingSession.open();
                editingSession.attachEditor((ISiriusEditor)this.editor);
                this.editor.initCommandFactoryProviders();
                this.editor = null;
                SessionManager.INSTANCE.removeSessionsListener((SessionManagerListener)this);
            }
        }
    }
}

