/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.business.internal.session.danalysis.DRepresentationDescriptorAdapter;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.sirius.viewpoint.description.DAnnotation;

public class DRepresentationQuery {
    private DRepresentation representation;
    private Session session;

    public DRepresentationQuery(DRepresentation representation) {
        this.representation = representation;
    }

    public DRepresentationQuery(DRepresentation representation, Session session) {
        this.representation = representation;
        this.session = session;
    }

    public Option<AnnotationEntry> getAnnotation(String source, EObject eObject) {
        for (AnnotationEntry annotation : this.representation.getOwnedAnnotationEntries()) {
            if (!source.equals(annotation.getSource()) || !eObject.equals(annotation.getData())) continue;
            return Options.newSome((Object)annotation);
        }
        return Options.newNone();
    }

    public Collection<AnnotationEntry> getAnnotation(String source) {
        ArrayList<AnnotationEntry> annotationEntries = new ArrayList<AnnotationEntry>();
        for (AnnotationEntry annotation : this.representation.getOwnedAnnotationEntries()) {
            if (!source.equals(annotation.getSource())) continue;
            annotationEntries.add(annotation);
        }
        return annotationEntries;
    }

    public Option<DAnnotation> getDAnnotation(String source, String detail) {
        DAnnotation annotation = this.representation.getDAnnotation(source);
        if (annotation != null && annotation.getDetails().get((Object)detail) != null) {
            return Options.newSome((Object)annotation);
        }
        return Options.newNone();
    }

    public boolean isDanglingRepresentation() {
        if (this.representation instanceof DSemanticDecorator) {
            DSemanticDecorator semDecRep = (DSemanticDecorator)((Object)this.representation);
            if (this.session == null) {
                this.session = SessionManager.INSTANCE.getSession(semDecRep.getTarget());
            }
            return semDecRep.getTarget() == null || this.session == null;
        }
        return false;
    }

    public DRepresentationDescriptor getRepresentationDescriptor() {
        DRepresentationDescriptor result = null;
        if (this.representation != null) {
            Optional<DRepresentationDescriptorAdapter> optionalRepDesc = this.representation.eAdapters().stream().filter(a -> a instanceof DRepresentationDescriptorAdapter).map(DRepresentationDescriptorAdapter.class::cast).findFirst();
            if (optionalRepDesc.isPresent()) {
                return optionalRepDesc.get().getdRepresentationDescriptor();
            }
            if (this.representation instanceof DSemanticDecorator) {
                if (this.session == null) {
                    this.session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)((Object)this.representation)).getTarget());
                }
                if (this.session != null) {
                    result = this.findDescriptorFromCrossReferencer();
                    if (result == null) {
                        result = this.findDescriptorFromAnalysis();
                    }
                } else {
                    result = this.findDescriptorFromEResource();
                }
                if (result != null) {
                    DRepresentationDescriptorAdapter representationDescriptorAdaptor = new DRepresentationDescriptorAdapter(result);
                    this.representation.eAdapters().add((Object)representationDescriptorAdaptor);
                }
            }
        }
        return result;
    }

    private DRepresentationDescriptor findDescriptorFromAnalysis() {
        DRepresentationDescriptor result = null;
        Collection<DAnalysis> allAnalyses = ((DAnalysisSessionImpl)this.session).allAnalyses();
        for (DAnalysis dAnalysis : allAnalyses) {
            result = this.findDescriptorFromAnalysis(dAnalysis);
            if (result != null) break;
        }
        return result;
    }

    private DRepresentationDescriptor findDescriptorFromEResource() {
        DRepresentationDescriptor result = null;
        Resource eResource = this.representation.eResource();
        if (eResource != null && eResource.getContents() != null) {
            for (EObject content : eResource.getContents()) {
                if (content instanceof DAnalysis) {
                    result = this.findDescriptorFromAnalysis((DAnalysis)content);
                }
                if (result != null) break;
            }
        }
        return result;
    }

    public DRepresentationDescriptor findDescriptorFromAnalysis(DAnalysis dAnalysis) {
        if (this.representation.eResource() != null) {
            EList<DView> ownedViews = dAnalysis.getOwnedViews();
            for (DView view : ownedViews) {
                EList<DRepresentationDescriptor> ownedRepresentationDescriptors = view.getOwnedRepresentationDescriptors();
                for (DRepresentationDescriptor descriptor : ownedRepresentationDescriptors) {
                    DRepresentation representationTemp;
                    if (!descriptor.isLoadedRepresentation() || !this.representation.equals(representationTemp = descriptor.getRepresentation())) continue;
                    return descriptor;
                }
            }
        }
        return null;
    }

    private DRepresentationDescriptor findDescriptorFromCrossReferencer() {
        DRepresentationDescriptor result = null;
        Collection usages = this.session.getSemanticCrossReferencer().getInverseReferences((EObject)this.representation);
        for (EStructuralFeature.Setting setting : usages) {
            if (!ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR.isInstance((Object)setting.getEObject()) || setting.getEStructuralFeature() != ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__REPRESENTATION) continue;
            result = (DRepresentationDescriptor)setting.getEObject();
            break;
        }
        return result;
    }

    public boolean isAutoRefresh() {
        if (this.session == null) {
            this.session = Session.of(this.representation).orElse(null);
        }
        if (this.session != null) {
            return this.session.getSiriusPreferences().isAutoRefresh();
        }
        return false;
    }
}

