/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.command;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.command.ICommandFactory;
import org.eclipse.sirius.tools.api.command.ui.RefreshFilterManager;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;

public abstract class AbstractCommandFactory
implements ICommandFactory {
    protected final TransactionalEditingDomain domain;
    protected ModelAccessor modelAccessor;
    protected UICallBack uiCallBack;

    public AbstractCommandFactory(TransactionalEditingDomain domain) {
        this.domain = domain;
        this.modelAccessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(domain.getResourceSet());
    }

    @Override
    public CreateRepresentationCommand buildCreateRepresentationFromDescription(RepresentationCreationDescription desc, DRepresentationElement element, String newDiagramName) {
        Session session = SessionManager.INSTANCE.getSession(element.getTarget());
        CreateRepresentationCommand cmd = new CreateRepresentationCommand(session, desc.getRepresentationDescription(), element.getTarget(), newDiagramName, (IProgressMonitor)new NullProgressMonitor());
        cmd.setInitialOperation(desc);
        return cmd;
    }

    @Override
    public void setUserInterfaceCallBack(UICallBack newCB) {
        this.uiCallBack = newCB;
    }

    @Override
    public UICallBack getUserInterfaceCallBack() {
        return this.uiCallBack;
    }

    protected void addRefreshTask(DSemanticDecorator semanticDecorator, DCommand result, final AbstractToolDescription toolDescription, IProgressMonitor monitor) {
        if (semanticDecorator != null) {
            EObject semanticElement = semanticDecorator.getTarget();
            final Session session = SessionManager.INSTANCE.getSession(semanticElement);
            final DRepresentation representationToRefresh = semanticDecorator instanceof DRepresentation ? (DRepresentation)((Object)semanticDecorator) : (semanticDecorator instanceof DRepresentationElement ? new DRepresentationElementQuery((DRepresentationElement)semanticDecorator).getParentRepresentation() : null);
            if (semanticElement != null && session != null && representationToRefresh != null) {
                result.getTasks().add(new AbstractCommandTask(){

                    @Override
                    public String getLabel() {
                        return Messages.AbstractCommandFactory_refreshTasklabel;
                    }

                    @Override
                    public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
                        if (toolDescription == null || toolDescription.isForceRefresh()) {
                            session.getRefreshEditorsListener().setForceRefresh(true);
                        }
                        if (toolDescription == null) {
                            for (DRepresentation dRepresentation : RefreshFilterManager.INSTANCE.getOpenedRepresantationsToRefresh()) {
                                session.getRefreshEditorsListener().addRepresentationToForceRefresh(dRepresentation);
                            }
                        } else {
                            session.getRefreshEditorsListener().addRepresentationToForceRefresh(representationToRefresh);
                        }
                    }
                });
            }
        }
    }

    protected void addRefreshTask(DSemanticDecorator semanticDecorator, DCommand result, AbstractToolDescription toolDescription) {
        this.addRefreshTask(semanticDecorator, result, toolDescription, (IProgressMonitor)new NullProgressMonitor());
    }
}

