/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.dnd;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers.MoveCopyCallback;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class CommonDnD
implements IConfirmCallback {
    public boolean isDraggable(IStructuredSelection selection) {
        Object[] objects;
        if (selection.isEmpty()) {
            return false;
        }
        Object[] objectArray = objects = selection.toArray();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (!this.isDraggableObject(object)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isDraggableObject(Object object) {
        if (object instanceof IFSTreeNode) {
            IFSTreeNode node = (IFSTreeNode)object;
            if (node.isRootDirectory()) {
                return false;
            }
            if (node.isWindowsNode()) {
                return !node.isReadOnly();
            }
            return node.isWritable();
        }
        return false;
    }

    public boolean dropFiles(TreeViewer viewer, String[] files, int operations, IFSTreeNode target) {
        boolean move;
        boolean bl = move = (operations & 2) != 0;
        if (move) {
            String question = files.length == 1 ? NLS.bind((String)Messages.FSDropTargetListener_MovingWarningSingle, (Object)files[0]) : NLS.bind((String)Messages.FSDropTargetListener_MovingWarningMultiple, (Object)files.length);
            Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (!MessageDialog.openQuestion((Shell)parent, (String)Messages.FSDropTargetListener_ConfirmMoveTitle, (String)question)) {
                return false;
            }
        } else if ((operations & 1) == 0) {
            return false;
        }
        IStatus status = UiExecutor.execute(target.operationDropFiles(Arrays.asList(files), (IConfirmCallback)this));
        if (move && status.isOK()) {
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                File file = new File(path);
                file.delete();
                ++n2;
            }
        }
        return status.isOK();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dropLocalSelection(IFSTreeNode target, int operations, IStructuredSelection selection) {
        IOperation operation;
        boolean move;
        List<IFSTreeNode> nodes = this.toNodes(selection);
        boolean bl = move = (operations & 2) != 0;
        if (move && nodes != null) {
            operation = target.operationDropMove(nodes, (IConfirmCallback)new MoveCopyCallback());
        } else {
            if ((operations & 1) == 0) return false;
            if (nodes != null) {
                IFSTreeNode dest = this.getCopyDestination(target, nodes);
                boolean cpPerm = UIPlugin.isCopyPermission();
                boolean cpOwn = UIPlugin.isCopyOwnership();
                operation = dest.operationDropCopy(nodes, cpPerm, cpOwn, (IConfirmCallback)new MoveCopyCallback());
            } else {
                List<String> files = this.toFiles(selection);
                if (files == null) return false;
                operation = target.operationDropFiles(files, (IConfirmCallback)new MoveCopyCallback());
            }
        }
        IStatus status = UiExecutor.execute(operation);
        if (!move) return status.isOK();
        UIPlugin.getClipboard().clear();
        return status.isOK();
    }

    private IFSTreeNode getCopyDestination(IFSTreeNode hovered, List<IFSTreeNode> nodes) {
        if (hovered.isFile()) {
            return hovered.getParent();
        }
        if (hovered.isDirectory()) {
            for (IFSTreeNode node : nodes) {
                if (node != hovered) continue;
                return hovered.getParent();
            }
        }
        return hovered;
    }

    public boolean validateFilesDrop(Object target, int operation, TransferData transferType) {
        FileTransfer transfer = FileTransfer.getInstance();
        String[] elements = (String[])transfer.nativeToJava(transferType);
        if (elements == null) {
            elements = new String[]{};
        }
        boolean moving = (operation & 2) != 0;
        boolean copying = (operation & 1) != 0;
        IFSTreeNode hovered = (IFSTreeNode)target;
        if (hovered.isFile() && copying) {
            hovered = hovered.getParent();
        }
        return hovered.isDirectory() && hovered.isWritable() && (moving || copying);
    }

    public int validateLocalSelectionDrop(Object target, int operation, TransferData transferType) {
        boolean copying;
        IFSTreeNode hovered = (IFSTreeNode)target;
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        IStructuredSelection selection = (IStructuredSelection)transfer.getSelection();
        boolean moving = (operation & 2) != 0;
        boolean bl = copying = (operation & 1) != 0;
        if (!moving && !copying) {
            return 0;
        }
        List<IFSTreeNode> nodes = this.toNodes(selection);
        if (nodes != null) {
            if (hovered.isDirectory() && hovered.isWritable() && (moving || copying)) {
                String tid;
                IFSTreeNode head = nodes.get(0);
                String hid = head.getPeerNode().getPeerId();
                if (hid.equals(tid = hovered.getPeerNode().getPeerId())) {
                    for (IFSTreeNode node : nodes) {
                        if ((!moving || node != hovered) && node.getParent() != hovered && !node.isAncestorOf(hovered)) continue;
                        return 0;
                    }
                    return operation;
                }
            } else if (hovered.isFile() && (copying || moving)) {
                hovered = hovered.getParent();
                return this.validateLocalSelectionDrop(hovered, operation, transferType);
            }
            return 0;
        }
        List<String> files = this.toFiles(selection);
        if (files != null) {
            if (hovered.isDirectory() && hovered.isWritable()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private List<IFSTreeNode> toNodes(IStructuredSelection selection) {
        ArrayList<IFSTreeNode> nodes = new ArrayList<IFSTreeNode>();
        for (Object o : selection.toList()) {
            if (!(o instanceof IFSTreeNode)) {
                return null;
            }
            nodes.add((IFSTreeNode)o);
        }
        return nodes;
    }

    private List<String> toFiles(IStructuredSelection selection) {
        Bundle rb = Platform.getBundle((String)"org.eclipse.core.resources");
        if (rb == null || rb.getState() != 32) {
            return null;
        }
        ArrayList<String> files = new ArrayList<String>();
        for (Object o : selection.toList()) {
            IResource res = (IResource)Platform.getAdapterManager().getAdapter(o, IResource.class);
            if (res == null) {
                return null;
            }
            IPath location = res.getLocation();
            if (location == null) {
                return null;
            }
            files.add(location.toFile().getAbsolutePath());
        }
        return files;
    }

    public boolean requires(Object object) {
        return true;
    }

    public int confirms(final Object object) {
        final int[] results = new int[1];
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                String title = Messages.FSUpload_OverwriteTitle;
                String message = NLS.bind((String)Messages.FSUpload_OverwriteConfirmation, (Object)CommonDnD.this.getName(object));
                final Image titleImage = UIPlugin.getImage("ConfirmReadOnlyDelete");
                MessageDialog qDialog = new MessageDialog(parent, title, null, message, 3, new String[]{Messages.FSUpload_Yes, Messages.FSUpload_YesToAll, Messages.FSUpload_No, Messages.FSUpload_Cancel}, 0){

                    public Image getQuestionImage() {
                        return titleImage;
                    }
                };
                results[0] = qDialog.open();
            }
        });
        return results[0];
    }

    protected String getName(Object object) {
        if (object instanceof File) {
            return ((File)object).getName();
        }
        if (object instanceof IFSTreeNode) {
            return ((IFSTreeNode)object).getName();
        }
        return String.valueOf(object);
    }

    public boolean setDragData(DragSourceEvent anEvent) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(anEvent.dataType)) {
            anEvent.data = LocalSelectionTransfer.getTransfer().getSelection();
            return true;
        }
        return false;
    }
}

