/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.CacheState;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;

public class OpenFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        final IFSTreeNode node = (IFSTreeNode)selection.getFirstElement();
        final IWorkbenchPage page = HandlerUtil.getActiveSite((ExecutionEvent)event).getPage();
        if (node.isBinaryFile()) {
            Shell parent = HandlerUtil.getActiveShell((ExecutionEvent)event);
            MessageDialog.openWarning((Shell)parent, (String)Messages.OpenFileHandler_Warning, (String)Messages.OpenFileHandler_OpeningBinaryNotSupported);
        } else if (UIPlugin.isAutoSaving()) {
            node.operationRefresh(false).runInJob((ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    File file = node.getCacheFile();
                    if (node.getCacheState() == CacheState.outdated) {
                        file.delete();
                    }
                    DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            OpenFileHandler.this.openFile(node, page);
                        }
                    });
                }
            });
        } else {
            this.openFile(node, page);
        }
        return null;
    }

    void openFile(IFSTreeNode node, IWorkbenchPage page) {
        File file = node.getCacheFile();
        if (!file.exists() && !UiExecutor.execute(node.operationDownload(null)).isOK()) {
            return;
        }
        this.openEditor(page, node);
    }

    private void openEditor(final IWorkbenchPage page, final IFSTreeNode node) {
        Display display = page.getWorkbenchWindow().getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Path path = new Path(node.getCacheFile().getAbsolutePath());
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)path);
                String editorID = node.getPreferredEditorID();
                try {
                    if (editorID != null) {
                        FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
                        page.openEditor((IEditorInput)input, editorID, true, 3);
                    } else {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
    }
}

