/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSStorage;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.util.SyncFileWriter;

public class TemplateHandler
extends ResponseHandler {
    @Override
    public String getResponseID() {
        return "Template";
    }

    @Override
    public void handle(Session session, String localDir, IProgressMonitor monitor) throws CVSException {
        block6: {
            session.readLine();
            ICVSFolder localFolder = session.getLocalRoot().getFolder(localDir);
            IContainer container = (IContainer)localFolder.getIResource();
            ICVSStorage templateFile = null;
            if (container != null && container.exists()) {
                try {
                    templateFile = CVSWorkspaceRoot.getCVSFileFor(SyncFileWriter.getTemplateFile(container));
                }
                catch (CVSException e) {
                    CVSProviderPlugin.log((IStatus)new CVSStatus(4, 4, "Could not write template file in " + container.getFullPath() + ": " + e.getMessage(), (Throwable)((Object)e), session.getLocalRoot()));
                }
            }
            if (container == null || templateFile == null) {
                templateFile = new ICVSStorage(){

                    @Override
                    public String getName() {
                        return "Template";
                    }

                    @Override
                    public void setContents(InputStream stream, int responseType, boolean keepLocalHistory, IProgressMonitor monitor) throws CVSException {
                        try {
                            try {
                                Throwable throwable = null;
                                Object var6_8 = null;
                                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                                    int read;
                                    byte[] buffer = new byte[1024];
                                    while ((read = stream.read(buffer)) >= 0) {
                                        Policy.checkCanceled(monitor);
                                        ((OutputStream)out).write(buffer, 0, read);
                                    }
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (IOException e) {
                                throw CVSException.wrapException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }

                    @Override
                    public long getSize() {
                        return 0L;
                    }

                    @Override
                    public InputStream getContents() throws CVSException {
                        return new ByteArrayInputStream(new byte[0]);
                    }
                };
            }
            try {
                session.receiveFile(templateFile, false, 1, monitor);
            }
            catch (CVSException e) {
                if (templateFile instanceof ICVSFile && this.handleInvalidResourceName(session, (ICVSFile)templateFile, e)) break block6;
                throw e;
            }
        }
    }
}

