/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfiguration;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfiguration;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationPlugin;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPairSupport;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CommentSupport;
import org.eclipse.tm4e.languageconfiguration.internal.supports.OnEnterSupport;
import org.eclipse.tm4e.registry.TMResource;
import org.eclipse.tm4e.ui.utils.ContentTypeHelper;

public class LanguageConfigurationDefinition
extends TMResource
implements ILanguageConfigurationDefinition {
    private IContentType contentType;
    private boolean onEnterEnabled = true;
    private boolean bracketAutoClosingEnabled = true;
    private boolean matchingPairsEnabled = true;
    private CharacterPairSupport characterPair;
    private OnEnterSupport onEnter;
    private CommentSupport comment;

    public LanguageConfigurationDefinition(IContentType contentType, String path) {
        super(path);
        this.contentType = contentType;
    }

    public LanguageConfigurationDefinition(IConfigurationElement ce) {
        super(ce);
        this.contentType = ContentTypeHelper.getContentTypeById((String)ce.getAttribute("contentTypeId"));
    }

    public LanguageConfigurationDefinition(IContentType contentType, String path, String pluginId, boolean onEnterEnabled, boolean bracketAutoClosingEnabled, boolean matchingPairsEnabled) {
        super(path, pluginId);
        this.contentType = contentType;
        this.onEnterEnabled = onEnterEnabled;
        this.bracketAutoClosingEnabled = bracketAutoClosingEnabled;
        this.matchingPairsEnabled = matchingPairsEnabled;
    }

    public CharacterPairSupport getCharacterPair() {
        ILanguageConfiguration conf;
        if (this.characterPair == null && (conf = this.getLanguageConfiguration()) != null) {
            this.characterPair = new CharacterPairSupport(conf.getBrackets(), conf.getAutoClosingPairs(), conf.getSurroundingPairs());
        }
        return this.characterPair;
    }

    public OnEnterSupport getOnEnter() {
        ILanguageConfiguration conf;
        if (this.onEnter == null && (conf = this.getLanguageConfiguration()) != null && (conf.getBrackets() != null || conf.getOnEnterRules() != null)) {
            this.onEnter = new OnEnterSupport(conf.getBrackets(), conf.getOnEnterRules());
        }
        return this.onEnter;
    }

    public CommentSupport getCommentSupport() {
        ILanguageConfiguration conf;
        if (this.comment == null && (conf = this.getLanguageConfiguration()) != null) {
            this.comment = new CommentSupport(conf.getComments());
        }
        return this.comment;
    }

    @Override
    public IContentType getContentType() {
        return this.contentType;
    }

    @Override
    public ILanguageConfiguration getLanguageConfiguration() {
        try {
            return LanguageConfiguration.load(new InputStreamReader(this.getInputStream(), Charset.defaultCharset()));
        }
        catch (IOException e) {
            LanguageConfigurationPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.tm4e.languageconfiguration", e.getMessage(), (Throwable)e));
            return null;
        }
    }

    @Override
    public Boolean isOnEnterEnabled() {
        return this.onEnterEnabled;
    }

    @Override
    public void setOnEnterEnabled(boolean onEnterEnabled) {
        this.onEnterEnabled = onEnterEnabled;
    }

    @Override
    public Boolean isBracketAutoClosingEnabled() {
        return this.bracketAutoClosingEnabled;
    }

    @Override
    public void setBracketAutoClosingEnabled(boolean bracketAutoClosingEnabled) {
        this.bracketAutoClosingEnabled = bracketAutoClosingEnabled;
    }

    @Override
    public Boolean isMatchingPairsEnabled() {
        return this.matchingPairsEnabled;
    }

    @Override
    public void setMatchingPairsEnabled(boolean matchingPairsEnabled) {
        this.matchingPairsEnabled = matchingPairsEnabled;
    }
}

