/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.IAnnotation;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.component.ITmfComponent;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class EventAnnotationProvider<@NonNull M extends TimeGraphEntryModel>
implements IOutputAnnotationProvider {
    private static final TmfModelResponse<AnnotationModel> NO_DATA = new TmfModelResponse<AnnotationModel>(new AnnotationModel(Collections.emptyMap()), ITmfResponse.Status.COMPLETED, "");
    private final String fMetadataKey;
    private final Map<String, String> fMarkerColorCache = new HashMap<String, String>();
    private final Class<? extends ITmfEventAspect<?>> fAspect;
    private final Collection<@NonNull ITmfTrace> fMarkerTraces;
    private final BiFunction<Map<@NonNull String, @NonNull Object>, @Nullable IProgressMonitor, TmfModelResponse<@NonNull TmfTreeModel<M>>> fTreeResolver;
    private final Predicate<M> fAdditionalPredicate;
    private final Map<ITmfTrace, TmfEventRequest> fRunningRequests = new HashMap<ITmfTrace, TmfEventRequest>();

    public EventAnnotationProvider(String metadataKey, Predicate<M> additional, Predicate<ITmfTrace> tracefilter, Class<? extends ITmfEventAspect<?>> aspect, ITmfTrace trace, BiFunction<@NonNull Map<@NonNull String, @NonNull Object>, @Nullable IProgressMonitor, TmfModelResponse<TmfTreeModel<M>>> treeResolver) {
        this.fAspect = aspect;
        this.fMetadataKey = metadataKey;
        this.fTreeResolver = treeResolver;
        this.fAdditionalPredicate = additional;
        this.fMarkerTraces = TmfTraceManager.getInstance().getTracesForHost(trace.getHostId()).stream().filter(tracefilter).collect(Collectors.toSet());
    }

    @Override
    public TmfModelResponse<@NonNull AnnotationCategoriesModel> fetchAnnotationCategories(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse<AnnotationCategoriesModel>(new AnnotationCategoriesModel(this.fMarkerTraces.stream().map(ITmfComponent::getName).collect(Collectors.toList())), ITmfResponse.Status.COMPLETED, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TmfModelResponse<@NonNull AnnotationModel> fetchAnnotations(Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        EventAnnotationProvider lock;
        final List<Long> timeRequested = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        List<@NonNull Long> entries = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        @Nullable Set<@NonNull String> categories = DataProviderParameterUtils.extractSelectedCategories(fetchParameters);
        if (timeRequested == null || entries == null) {
            return NO_DATA;
        }
        TmfModelResponse<@NonNull TmfTreeModel<M>> tree = Objects.requireNonNull(this.fTreeResolver.apply(fetchParameters, monitor));
        TmfTreeModel<M> model = tree.getModel();
        if (model == null) {
            return NO_DATA;
        }
        Function<TimeGraphEntryModel, Integer> keyMapper = entry -> (Integer)Iterables.get((Iterable)entry.getMetadata().get((Object)this.fMetadataKey), (int)0);
        Predicate<TimeGraphEntryModel> predicate = entry -> {
            @NonNull Collection collection = entry.getMetadata().get((Object)this.fMetadataKey);
            return !collection.isEmpty() && !Objects.equals(Iterables.get((Iterable)collection, (int)0), -1);
        };
        final LinkedHashMap rowMap = new LinkedHashMap();
        List<@NonNull M> entries2 = model.getEntries();
        entries2.stream().filter(predicate).filter(this.fAdditionalPredicate).forEach(element -> {
            TimeGraphEntryModel timeGraphEntryModel = rowMap.put((Integer)keyMapper.apply((TimeGraphEntryModel)element), element);
        });
        final LinkedHashMap<String, Collection<Annotation>> markers = new LinkedHashMap<String, Collection<Annotation>>();
        TmfTimeRange tr = new TmfTimeRange(TmfTimestamp.fromNanos(timeRequested.get(0)), TmfTimestamp.fromNanos(timeRequested.get(timeRequested.size() - 1)));
        EventAnnotationProvider eventAnnotationProvider = lock = this;
        synchronized (eventAnnotationProvider) {
            TmfEventRequest req;
            for (ITmfTrace source : this.fMarkerTraces) {
                TmfEventRequest old = this.fRunningRequests.remove(source);
                if (old == null || !old.isRunning()) continue;
                old.cancel();
            }
            for (ITmfTrace source : this.fMarkerTraces) {
                if (categories != null && !categories.contains(source.getName())) continue;
                req = new TmfEventRequest(ITmfEvent.class, tr, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND){
                    private int timesliceIndex;
                    private Set<Object> values;
                    {
                        super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                        this.timesliceIndex = 0;
                        this.values = new HashSet<Object>();
                    }

                    private long next() {
                        if (timeRequested.size() > this.timesliceIndex + 1) {
                            return (Long)timeRequested.get(this.timesliceIndex + 1);
                        }
                        return Long.MAX_VALUE;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handleData(ITmfEvent event) {
                        super.handleData(event);
                        while (event.getTimestamp().toNanos() > this.next()) {
                            ++this.timesliceIndex;
                            this.values.clear();
                            if (this.timesliceIndex < timeRequested.size() - 1) continue;
                            this.done();
                            return;
                        }
                        Object value = TmfTraceUtils.resolveEventAspectOfClassForEvent(event.getTrace(), EventAnnotationProvider.this.fAspect, event);
                        if (value != null && !this.values.contains(value)) {
                            this.values.add(value);
                            Map map = markers;
                            synchronized (map) {
                                Collection markerList = markers.computeIfAbsent(String.valueOf(event.getTrace().getName()), string -> new ArrayList());
                                TimeGraphEntryModel entryModel = (TimeGraphEntryModel)rowMap.get(value);
                                if (entryModel != null) {
                                    String name = event.getName();
                                    HashMap<String, Object> style = new HashMap<String, Object>();
                                    style.put("symbol-type", "inverted-triangle");
                                    style.put("color", this.getMarkerColor(name));
                                    style.put("height", 0.3);
                                    style.put("vertical-align", "top");
                                    markerList.add(new Annotation(event.getTimestamp().toNanos(), 0L, entryModel.getId(), IAnnotation.AnnotationType.CHART, name, new OutputElementStyle(name, style)));
                                }
                            }
                        }
                    }

                    private String getMarkerColor(String name) {
                        return Objects.requireNonNull(EventAnnotationProvider.this.fMarkerColorCache.computeIfAbsent(name, label -> Objects.requireNonNull(String.format("#%6x", label.hashCode() & 0xFFFFFF))));
                    }
                };
                this.fRunningRequests.put(source, req);
                source.sendRequest(req);
            }
            try {
                for (ITmfTrace source : this.fMarkerTraces) {
                    req = null;
                    EventAnnotationProvider eventAnnotationProvider2 = lock;
                    synchronized (eventAnnotationProvider2) {
                        req = this.fRunningRequests.get(source);
                    }
                    if (req == null) continue;
                    req.waitForCompletion();
                    this.fRunningRequests.remove(source);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return new TmfModelResponse<AnnotationModel>(new AnnotationModel(markers), ITmfResponse.Status.COMPLETED, "");
    }
}

