/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event.lookup;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;

public class TmfCallsite
implements ITmfCallsite {
    private final @NonNull String fFileName;
    private final @Nullable Long fLineNumber;

    public TmfCallsite(@NonNull String fileName, @Nullable Long lineNumber) {
        this.fFileName = fileName;
        this.fLineNumber = lineNumber;
    }

    public TmfCallsite(@NonNull ITmfCallsite other) {
        this.fFileName = other.getFileName();
        this.fLineNumber = other.getLineNo();
    }

    @Override
    public @NonNull String getFileName() {
        return this.fFileName;
    }

    @Override
    public @Nullable Long getLineNo() {
        return this.fLineNumber;
    }

    public int hashCode() {
        return Objects.hash(this.fFileName, this.fLineNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfCallsite other = (TmfCallsite)obj;
        if (!this.fFileName.equals(other.fFileName)) {
            return false;
        }
        return this.fLineNumber == other.fLineNumber;
    }

    public String toString() {
        Long lineNumber = this.fLineNumber;
        StringBuilder builder = new StringBuilder();
        builder.append(this.fFileName).append(':');
        builder.append(lineNumber == null ? "??" : Long.toString(lineNumber));
        return builder.toString();
    }
}

