/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.minimap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;

public class MinimapWidget {
    private static final float SCALE = 0.2f;
    private final ITextViewer fEditorViewer;
    private final StyledText fMinimapTextWidget;
    private final EditorTracker fEditorTracker;
    private final MinimapTracker fMinimapTracker;

    public MinimapWidget(Composite parent, ITextViewer viewer) {
        this.fEditorViewer = viewer;
        this.fMinimapTextWidget = new StyledText(parent, 10);
        this.fMinimapTextWidget.setEditable(false);
        this.fMinimapTextWidget.setCursor(this.fMinimapTextWidget.getDisplay().getSystemCursor(0));
        this.fEditorTracker = new EditorTracker();
        this.fMinimapTracker = new MinimapTracker();
    }

    public void install() {
        this.fEditorTracker.install();
        this.fMinimapTracker.install();
    }

    public void uninstall() {
        this.fEditorTracker.uninstall();
        this.fMinimapTracker.uninstall();
    }

    public Control getControl() {
        return this.fMinimapTextWidget;
    }

    float getScale() {
        return 0.2f;
    }

    class EditorTracker
    implements TextChangeListener,
    ControlListener,
    ITextPresentationListener,
    ITextInputListener,
    IViewportListener {
        private Map<Font, Font> fScaledFonts;

        EditorTracker() {
        }

        public void textSet(TextChangedEvent event) {
            this.synchText();
        }

        public void textChanging(TextChangingEvent event) {
            try {
                MinimapWidget.this.fMinimapTracker.replaceTextRange(event);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.ui.workbench.texteditor", 0, "Minimap text content synchronization failed", (Throwable)e);
                TextEditorPlugin.getDefault().getLog().log((IStatus)status);
                this.synchText();
            }
        }

        public void textChanged(TextChangedEvent event) {
            this.updateMinimapAfterTextChange();
        }

        public void applyTextPresentation(TextPresentation presentation) {
            try {
                this.addPresentation(presentation);
            }
            catch (Exception e) {
                this.synchTextAndStyles();
                Status status = new Status(4, "org.eclipse.ui.workbench.texteditor", 0, "Minimap styles synchronization failed", (Throwable)e);
                TextEditorPlugin.getDefault().getLog().log((IStatus)status);
            }
        }

        private StyleRange modelStyleRange2WidgetStyleRange(StyleRange range) {
            IRegion region = this.modelRange2WidgetRange((IRegion)new Region(range.start, range.length));
            if (region != null) {
                StyleRange result = (StyleRange)range.clone();
                result.start = region.getOffset();
                result.length = region.getLength();
                return result;
            }
            return null;
        }

        private IRegion modelRange2WidgetRange(IRegion region) {
            if (MinimapWidget.this.fEditorViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)MinimapWidget.this.fEditorViewer;
                return extension.modelRange2WidgetRange(region);
            }
            if (MinimapWidget.this.fEditorViewer instanceof TextViewer) {
                return ((TextViewer)MinimapWidget.this.fEditorViewer).modelRange2WidgetRange(region);
            }
            IRegion visibleRegion = MinimapWidget.this.fEditorViewer.getVisibleRegion();
            int start = region.getOffset() - visibleRegion.getOffset();
            int end = start + region.getLength();
            if (end > visibleRegion.getLength()) {
                end = visibleRegion.getLength();
            }
            return new Region(start, end - start);
        }

        private void addPresentation(TextPresentation presentation) {
            StyleRange range = presentation.getDefaultStyleRange();
            if (range != null) {
                if ((range = this.modelStyleRange2WidgetStyleRange(range)) != null) {
                    this.updateStyle(range);
                    MinimapWidget.this.fMinimapTextWidget.setStyleRange(range);
                }
                ArrayList<StyleRange> ranges = new ArrayList<StyleRange>(presentation.getDenumerableRanges());
                Iterator e = presentation.getNonDefaultStyleRangeIterator();
                while (e.hasNext()) {
                    range = (StyleRange)e.next();
                    if ((range = this.modelStyleRange2WidgetStyleRange(range)) == null) continue;
                    this.updateStyle(range);
                    ranges.add(range);
                }
                if (!ranges.isEmpty()) {
                    MinimapWidget.this.fMinimapTextWidget.replaceStyleRanges(0, 0, ranges.toArray(new StyleRange[ranges.size()]));
                }
            } else {
                IRegion region = this.modelRange2WidgetRange(presentation.getCoverage());
                if (region == null) {
                    return;
                }
                ArrayList<StyleRange> list = new ArrayList<StyleRange>(presentation.getDenumerableRanges());
                Iterator e = presentation.getAllStyleRangeIterator();
                while (e.hasNext()) {
                    range = (StyleRange)e.next();
                    if ((range = this.modelStyleRange2WidgetStyleRange(range)) == null) continue;
                    this.updateStyle(range);
                    list.add(range);
                }
                if (!list.isEmpty()) {
                    StyleRange[] ranges = new StyleRange[list.size()];
                    list.toArray(ranges);
                    MinimapWidget.this.fMinimapTextWidget.replaceStyleRanges(region.getOffset(), region.getLength(), ranges);
                }
            }
        }

        void updateStyle(StyleRange range) {
            range.font = this.getScaledFont(range.font);
            range.metrics = null;
        }

        Font getScaledFont(Font editorFont) {
            if (editorFont == null) {
                return null;
            }
            Font scaledFont = this.fScaledFonts.get(editorFont);
            if (scaledFont != null) {
                return scaledFont;
            }
            FontData[] fontData = editorFont.getFontData();
            FontData fontDatum = fontData[0];
            scaledFont = new Font(editorFont.getDevice(), fontDatum.getName(), (int)Math.ceil((float)fontDatum.getHeight() * MinimapWidget.this.getScale()), fontDatum.getStyle());
            this.fScaledFonts.put(editorFont, scaledFont);
            return scaledFont;
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            this.updateMinimapAfterResize();
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput != newInput) {
                this.synchTextAndStyles();
            }
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void viewportChanged(int verticalOffset) {
            MinimapWidget.this.fMinimapTextWidget.getDisplay().asyncExec(() -> {
                if (!MinimapWidget.this.fMinimapTextWidget.isDisposed()) {
                    this.updateMinimapAfterResize();
                }
            });
        }

        void updateMinimapAfterResize() {
            this.updateMinimap(false);
        }

        void updateMinimapAfterTextChange() {
            this.updateMinimap(true);
        }

        void updateMinimap(boolean textChanged) {
            StyledText editorTextWidget = MinimapWidget.this.fEditorViewer.getTextWidget();
            int editorTopIndex = JFaceTextUtil.getPartialTopIndex((StyledText)editorTextWidget);
            int editorBottomIndex = JFaceTextUtil.getPartialBottomIndex((StyledText)editorTextWidget);
            int maximalLines = MinimapWidget.this.fEditorViewer.getTextWidget().getClientArea().height / MinimapWidget.this.fEditorViewer.getTextWidget().getLineHeight();
            MinimapWidget.this.fMinimapTracker.updateMinimap(editorTopIndex, editorBottomIndex, maximalLines, textChanged);
        }

        void install() {
            StyledText editorTextWidget = MinimapWidget.this.fEditorViewer.getTextWidget();
            this.fScaledFonts = new HashMap<Font, Font>();
            Font scaledFont = this.getScaledFont(editorTextWidget.getFont());
            MinimapWidget.this.fMinimapTextWidget.setFont(scaledFont);
            editorTextWidget.getContent().addTextChangeListener((TextChangeListener)this);
            MinimapWidget.this.fMinimapTextWidget.setBackground(editorTextWidget.getBackground());
            MinimapWidget.this.fMinimapTextWidget.setForeground(editorTextWidget.getForeground());
            if (MinimapWidget.this.fEditorViewer instanceof ITextViewerExtension4) {
                ((ITextViewerExtension4)MinimapWidget.this.fEditorViewer).addTextPresentationListener((ITextPresentationListener)this);
            }
            MinimapWidget.this.fEditorViewer.addTextInputListener((ITextInputListener)this);
            MinimapWidget.this.fEditorViewer.addViewportListener((IViewportListener)this);
            editorTextWidget.addControlListener((ControlListener)this);
            this.synchTextAndStyles();
        }

        void synchTextAndStyles() {
            this.synchText();
            this.synchStyles();
        }

        private void synchStyles() {
            StyledText editorTextWidget = MinimapWidget.this.fEditorViewer.getTextWidget();
            StyleRange[] ranges = editorTextWidget.getStyleRanges();
            if (ranges != null) {
                StyleRange[] styleRangeArray = ranges;
                int n = ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    StyleRange range = styleRangeArray[n2];
                    this.updateStyle(range);
                    ++n2;
                }
            }
            MinimapWidget.this.fMinimapTextWidget.setStyleRanges(ranges);
        }

        private void synchText() {
            StyledText editorTextWidget = MinimapWidget.this.fEditorViewer.getTextWidget();
            MinimapWidget.this.fMinimapTextWidget.setText(editorTextWidget.getText());
        }

        void uninstall() {
            StyledText editorTextWidget = MinimapWidget.this.fEditorViewer.getTextWidget();
            if (editorTextWidget.getContent() != null) {
                editorTextWidget.getContent().removeTextChangeListener((TextChangeListener)this);
            }
            if (MinimapWidget.this.fEditorViewer instanceof ITextViewerExtension4) {
                ((ITextViewerExtension4)MinimapWidget.this.fEditorViewer).removeTextPresentationListener((ITextPresentationListener)this);
            }
            MinimapWidget.this.fEditorViewer.removeTextInputListener((ITextInputListener)this);
            MinimapWidget.this.fEditorViewer.removeViewportListener((IViewportListener)this);
            editorTextWidget.removeControlListener((ControlListener)this);
            this.fScaledFonts.values().forEach(Resource::dispose);
        }
    }

    class MinimapTracker
    implements CaretListener,
    SelectionListener,
    PaintListener,
    MouseWheelListener {
        private static final int NB_LINES_SCROLL = 10;
        private int fEditorTopIndex;
        private int fEditorBottomIndex;
        private int fTopIndexY;
        private int fBottomIndexY;
        private int fMinimalHeight;
        private int fMaximalLines;
        private boolean fTextChanging;

        MinimapTracker() {
        }

        public void caretMoved(CaretEvent event) {
            if (this.fTextChanging) {
                return;
            }
            this.updateEditorTopIndex();
        }

        private void updateEditorTopIndex() {
            int lineAtOffset;
            int caretOffset = MinimapWidget.this.fMinimapTextWidget.getCaretOffset();
            int newTopIndex = lineAtOffset = MinimapWidget.this.fMinimapTextWidget.getLineAtOffset(caretOffset);
            if (MinimapWidget.this.fEditorViewer instanceof ITextViewerExtension5) {
                newTopIndex = ((ITextViewerExtension5)MinimapWidget.this.fEditorViewer).widgetLine2ModelLine(lineAtOffset);
            }
            MinimapWidget.this.fEditorViewer.setTopIndex(newTopIndex);
        }

        void updateMinimap(int editorTopIndex, int editorBottomIndex, int maximalLines, boolean textChanged) {
            if (editorTopIndex != this.fEditorTopIndex || editorBottomIndex != this.fEditorBottomIndex || maximalLines != this.fMaximalLines || textChanged) {
                this.fEditorTopIndex = editorTopIndex;
                this.fEditorBottomIndex = editorBottomIndex;
                this.fMaximalLines = maximalLines;
                MinimapWidget.this.fMinimapTextWidget.setRedraw(false);
                int newMinimapTopIndex = editorTopIndex;
                if (editorTopIndex != 0 && editorBottomIndex != MinimapWidget.this.fMinimapTextWidget.getLineAtOffset(MinimapWidget.this.fMinimapTextWidget.getCharCount())) {
                    int minimapTopIndex = JFaceTextUtil.getPartialTopIndex((StyledText)MinimapWidget.this.fMinimapTextWidget);
                    int minimapBottomIndex = JFaceTextUtil.getPartialBottomIndex((StyledText)MinimapWidget.this.fMinimapTextWidget);
                    int minimapVisibleLineCount = minimapBottomIndex - minimapTopIndex;
                    int editorVisibleLineCount = editorBottomIndex - editorTopIndex;
                    newMinimapTopIndex = Math.max(0, editorTopIndex + editorVisibleLineCount - minimapVisibleLineCount / 2);
                }
                MinimapWidget.this.fMinimapTextWidget.setTopIndex(newMinimapTopIndex);
                this.fTopIndexY = MinimapWidget.this.fMinimapTextWidget.getLinePixel(this.fEditorTopIndex);
                this.fBottomIndexY = MinimapWidget.this.fMinimapTextWidget.getLinePixel(this.fEditorBottomIndex + 1);
                this.fMinimalHeight = maximalLines > MinimapWidget.this.fMinimapTextWidget.getLineCount() ? maximalLines * MinimapWidget.this.fMinimapTextWidget.getLineHeight() : 0;
                MinimapWidget.this.fMinimapTextWidget.setRedraw(true);
            }
        }

        void replaceTextRange(TextChangingEvent event) {
            this.fTextChanging = true;
            int start = event.start;
            int length = event.replaceCharCount;
            String text = event.newText;
            if (event.newLineCount > 0 || event.replaceLineCount > 0) {
                Rectangle clientArea = MinimapWidget.this.fMinimapTextWidget.getClientArea();
                MinimapWidget.this.fMinimapTextWidget.setRedraw(false);
                MinimapWidget.this.fMinimapTextWidget.replaceTextRange(start, length, text);
                MinimapWidget.this.fMinimapTextWidget.redraw(0, this.fTopIndexY, clientArea.width, clientArea.height, false);
                MinimapWidget.this.fMinimapTextWidget.setRedraw(true);
            } else {
                MinimapWidget.this.fMinimapTextWidget.replaceTextRange(start, length, text);
            }
            this.fTextChanging = false;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            MinimapWidget.this.fMinimapTextWidget.setSelection(MinimapWidget.this.fMinimapTextWidget.getCaretOffset());
        }

        public void paintControl(PaintEvent event) {
            GC gc = event.gc;
            int clientAreaWidth = MinimapWidget.this.fMinimapTextWidget.getClientArea().width;
            gc.setBackground(MinimapWidget.this.fMinimapTextWidget.getSelectionBackground());
            Rectangle rect = new Rectangle(0, this.fTopIndexY, clientAreaWidth, Math.max(this.fBottomIndexY - this.fTopIndexY, this.fMinimalHeight));
            gc.drawRectangle(rect.x, rect.y, Math.max(1, rect.width - 1), Math.max(1, rect.height - 1));
            gc.setAdvanced(true);
            if (gc.getAdvanced()) {
                gc.setAlpha(20);
                gc.fillRectangle(rect);
                gc.setAdvanced(false);
            }
        }

        public void mouseScrolled(MouseEvent e) {
            int caretOffset = MinimapWidget.this.fMinimapTextWidget.getOffsetAtPoint(new Point(0, this.fTopIndexY));
            int lineIndex = MinimapWidget.this.fMinimapTextWidget.getLineAtOffset(caretOffset);
            lineIndex = e.count > 0 ? Math.max(0, lineIndex - 10) : Math.min(MinimapWidget.this.fMinimapTextWidget.getCharCount(), lineIndex + 10);
            caretOffset = MinimapWidget.this.fMinimapTextWidget.getOffsetAtLine(lineIndex);
            MinimapWidget.this.fMinimapTextWidget.setCaretOffset(caretOffset);
        }

        void install() {
            MinimapWidget.this.fMinimapTextWidget.addCaretListener((CaretListener)this);
            MinimapWidget.this.fMinimapTextWidget.addSelectionListener((SelectionListener)this);
            MinimapWidget.this.fMinimapTextWidget.addPaintListener((PaintListener)this);
            MinimapWidget.this.fMinimapTextWidget.addMouseWheelListener((MouseWheelListener)this);
        }

        void uninstall() {
            if (!MinimapWidget.this.fMinimapTextWidget.isDisposed()) {
                MinimapWidget.this.fMinimapTextWidget.removeCaretListener((CaretListener)this);
                MinimapWidget.this.fMinimapTextWidget.removeSelectionListener((SelectionListener)this);
                MinimapWidget.this.fMinimapTextWidget.removePaintListener((PaintListener)this);
                MinimapWidget.this.fMinimapTextWidget.removeMouseWheelListener((MouseWheelListener)this);
            }
        }
    }
}

