/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

public final class CFlatButton
extends Canvas {
    private static final Color COLOR_FACE = DrawUtils.getShiftedColor(IColorConstants.button, 12);
    private static final Color COLOR_FACE_SELECTED = IColorConstants.buttonDarker;
    private static final Color COLOR_BORDER_GRADIENT1 = DrawUtils.getShiftedColor(IColorConstants.button, -12);
    private static final Color COLOR_BORDER_GRADIENT1_SELECTED = DrawUtils.getShiftedColor(IColorConstants.buttonDarker, 64);
    private static final Color COLOR_BORDER_GRADIENT2 = DrawUtils.getShiftedColor(COLOR_FACE, -8);
    private static final Color COLOR_BORDER_GRADIENT2_SELECTED = DrawUtils.getShiftedColor(COLOR_FACE_SELECTED, -8);
    private Image m_image;
    private boolean m_down;
    private boolean m_selected;

    public CFlatButton(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                boolean isSelected = CFlatButton.this.m_down | CFlatButton.this.m_selected;
                Color faceColor = isSelected ? COLOR_FACE_SELECTED : COLOR_FACE;
                Color borderGradientColor1 = isSelected ? COLOR_BORDER_GRADIENT1_SELECTED : COLOR_BORDER_GRADIENT1;
                Color borderGradientColor2 = isSelected ? COLOR_BORDER_GRADIENT2_SELECTED : COLOR_BORDER_GRADIENT2;
                GC gc = e.gc;
                Rectangle ca = CFlatButton.this.getClientArea();
                gc.setForeground(IColorConstants.buttonDarker);
                gc.drawRectangle(ca.x, ca.y, ca.width - 1, ca.height - 1);
                CFlatButton.this.cropClientArea(ca);
                gc.setForeground(borderGradientColor1);
                gc.setBackground(borderGradientColor2);
                gc.fillGradientRectangle(ca.x, ca.y, ca.width, ca.height, true);
                CFlatButton.this.cropClientArea(ca);
                gc.setBackground(faceColor);
                gc.fillRectangle(ca);
                Rectangle ca1 = CFlatButton.this.getClientArea();
                CFlatButton.this.cropClientArea(ca1);
                gc.setForeground(faceColor);
                gc.setBackground(borderGradientColor1);
                gc.fillGradientRectangle(ca1.x, ca1.y, ca1.width, ca1.height / 4, true);
                ++ca1.x;
                ca1.width -= 2;
                gc.setForeground(borderGradientColor1);
                gc.setBackground(faceColor);
                gc.fillGradientRectangle(ca1.x, ca1.y + ca1.height / 4 - 1, ca1.width, ca1.height / 2, true);
                Image image = CFlatButton.this.getImage();
                if (image != null) {
                    Rectangle imageBounds = image.getBounds();
                    int x = ca.x + (ca.width - imageBounds.width) / 2;
                    int y = ca.y + (ca.height - imageBounds.height) / 2;
                    gc.drawImage(image, x, y);
                }
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                CFlatButton.this.m_down = true;
                CFlatButton.this.redraw();
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                CFlatButton.this.m_down = false;
                CFlatButton.this.redraw();
                CFlatButton.this.update();
                if (CFlatButton.this.getClientArea().contains(e.x, e.y)) {
                    CFlatButton.this.fireSelectionEvent(e.time, e.stateMask);
                }
            }
        });
    }

    private void fireSelectionEvent(int time, int stateMask) {
        Event event = new Event();
        event.time = time;
        event.stateMask = stateMask;
        this.notifyListeners(13, event);
    }

    private void cropClientArea(Rectangle ca) {
        ++ca.x;
        ++ca.y;
        ca.width -= 2;
        ca.height -= 2;
    }

    public final Image getImage() {
        return this.m_image;
    }

    public void setImage(Image image) {
        this.m_image = image;
    }

    public void setSelected(boolean selected) {
        this.m_selected = selected;
    }
}

