/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.infer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.core.infer.InferEngine;

public class InferOptions {
    public static final String OPTION_UseAssignments = "org.eclipse.wst.jsdt.core.infer.useAssignments";
    public static final String OPTION_UseInitMethod = "org.eclipse.wst.jsdt.core.infer.useInitMethod";
    public static final String OPTION_SaveArgumentComments = "org.eclipse.wst.jsdt.core.infer.saveArgumentComments";
    public static final String OPTION_DocLocation = "org.eclipse.wst.jsdt.core.infer.docLocation";
    public static final int DOC_LOCATION_BEFORE = 1;
    public static final int DOC_LOCATION_AFTER = 2;
    public char[][] systemClassMethod = null;
    public boolean useAssignments = true;
    public boolean useInitMethod;
    public String engineClass;
    public boolean saveArgumentComments;
    public int docLocation = 1;

    public InferOptions() {
        this.setDefaultOptions();
    }

    public InferOptions(Map settings) {
        if (settings == null) {
            return;
        }
        this.set(settings);
    }

    public void setDefaultOptions() {
        this.useAssignments = true;
        this.useInitMethod = true;
        this.saveArgumentComments = true;
    }

    public Map getMap() {
        HashMap<String, String> optionsMap = new HashMap<String, String>(30);
        optionsMap.put(OPTION_UseAssignments, this.useAssignments ? "true" : "false");
        optionsMap.put(OPTION_UseInitMethod, this.useInitMethod ? "true" : "false");
        optionsMap.put(OPTION_SaveArgumentComments, this.saveArgumentComments ? "true" : "false");
        optionsMap.put(OPTION_DocLocation, String.valueOf(this.docLocation));
        return optionsMap;
    }

    public void set(Map optionsMap) {
        Object optionValue = optionsMap.get(OPTION_UseAssignments);
        if (optionValue != null) {
            this.useAssignments = "true".equals(optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_UseInitMethod)) != null) {
            this.useInitMethod = "true".equals(optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_SaveArgumentComments)) != null) {
            this.saveArgumentComments = "true".equals(optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_DocLocation)) != null) {
            this.docLocation = Integer.parseInt((String)optionValue);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("InferOptions:");
        buf.append("\n\t- use assignments: ").append(this.useAssignments ? "ON" : " OFF");
        buf.append("\n\t- use initialization method : ").append(this.useInitMethod ? "ON" : " OFF");
        return buf.toString();
    }

    public InferEngine createEngine() {
        if (this.engineClass != null) {
            try {
                InferEngine engine = (InferEngine)Class.forName(this.engineClass).newInstance();
                engine.inferOptions = this;
                return engine;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return new InferEngine(this);
    }
}

