/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.ast;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.ast.StatementWithBody;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.util.Pair;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.output.InsertionPointSupport;
import org.eclipse.xpand2.output.VetoException;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatement
extends StatementWithBody {
    private static final Log LOG = LogFactory.getLog(FileStatement.class);
    private Expression fileNameExpression;
    private Identifier outletNameIdentifier;

    public FileStatement(Expression fileName, Statement[] body, Identifier mode) {
        super(body);
        this.fileNameExpression = fileName;
        this.outletNameIdentifier = mode;
    }

    public Expression getTargetFileName() {
        return this.fileNameExpression;
    }

    public Identifier getMode() {
        return this.outletNameIdentifier;
    }

    public String getOutletName() {
        if (this.outletNameIdentifier == null) {
            return null;
        }
        return this.outletNameIdentifier.toString();
    }

    @Override
    public void analyzeInternal(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type result = this.getTargetFileName().analyze((ExecutionContext)ctx, issues);
        if (!(ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable("FILENAME", (Object)result))).getStringType().isAssignableFrom(result)) {
            issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "String expected!", (SyntaxElement)this.getTargetFileName()));
        }
        int i = 0;
        while (i < this.body.length) {
            this.body[i].analyze(ctx, issues);
            ++i;
        }
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        block5: {
            Object result = this.getFilename(ctx);
            String fileName = result.toString();
            String outletName = this.getOutletName();
            ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable("FILENAME", result));
            try {
                ctx.getOutput().openFile(fileName, outletName);
                int i = 0;
                while (i < this.body.length) {
                    this.body[i].evaluate(ctx);
                    ++i;
                }
                for (Pair<XpandExecutionContextImpl, Statement> deferredStatement : ((XpandExecutionContextImpl)ctx).getDeferredStatements()) {
                    Statement stmt = (Statement)deferredStatement.getSecond();
                    if (!(ctx.getOutput() instanceof InsertionPointSupport)) {
                        throw new IllegalStateException("Output does not support insertion points.");
                    }
                    ((InsertionPointSupport)((Object)ctx.getOutput())).activateInsertionPoint(stmt);
                    stmt.evaluate((XpandExecutionContext)deferredStatement.getFirst());
                    ((InsertionPointSupport)((Object)ctx.getOutput())).deactivateInsertionPoint(stmt);
                }
                ctx.getOutput().closeFile();
            }
            catch (VetoException e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug((Object)("Generation of file '" + fileName + "' on outlet '" + outletName + "' skipped due to veto."));
            }
        }
    }

    public String getNameString(ExecutionContext context) {
        return "FILE";
    }

    private Object getFilename(XpandExecutionContext ctx) {
        Object result = this.getTargetFileName().evaluate((ExecutionContext)ctx);
        if (result == null) {
            throw new EvaluationException("Nullevaluation", (SyntaxElement)this.getTargetFileName(), (ExecutionContext)ctx);
        }
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("\u00abFILE ");
        b.append(this.fileNameExpression);
        if (this.outletNameIdentifier != null) {
            b.append(" " + this.outletNameIdentifier);
        }
        b.append("\u00bb...\u00abENDFILE\u00bb");
        return b.toString();
    }
}

