/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.xtend.typesystem.emf.EcoreUtil2;
import org.eclipse.xtend.typesystem.xsd.OawXMLResource;
import org.eclipse.xtend.typesystem.xsd.XSDMetaModel;
import org.eclipse.xtend.typesystem.xsd.util.Msg;
import org.eclipse.xtend.typesystem.xsd.util.XSDLog;
import org.eclipse.xtend.typesystem.xsd.util.XSDUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLReaderImpl {
    private static Log log = XSDLog.getLog(XMLReaderImpl.class);
    private URI baseURI = null;
    private XSDMetaModel metaModel;
    private Map<String, Object> options = new HashMap<String, Object>();
    private ResourceSet resourceSet;
    private String uri;
    private boolean useDocumentRoot = false;

    public static EObject read(EObject obj, String file, boolean useDocRoot) {
        log.info((Object)Msg.create("Reading XML file ").uri(file).txt(". Context ").uri(obj));
        if (!(obj.eResource() instanceof OawXMLResource)) {
            throw new WorkflowInterruptedException("The supplied EObject for readXML('" + file + "') has not been loaded using the XSD Adapter's XMLReader.");
        }
        OawXMLResource res = (OawXMLResource)obj.eResource();
        ResourceSetImpl rs = res.getResourceSet() == null ? new ResourceSetImpl() : res.getResourceSet();
        XMLReaderImpl reader = new XMLReaderImpl((ResourceSet)rs, res.getMetaModel());
        if (res.getURI() != null) {
            reader.setBaseURI(res.getURI());
        }
        return reader.readXML(file, useDocRoot);
    }

    public static EObject read(String file, boolean useDocRoot) {
        log.info((Object)Msg.create("Reading XML file ").uri(file));
        ResourceSetImpl rs = new ResourceSetImpl();
        XSDMetaModel mm = new XSDMetaModel();
        XMLReaderImpl reader = new XMLReaderImpl((ResourceSet)rs, mm);
        return reader.readXML(file, useDocRoot);
    }

    public static EObject read(String file, XSDMetaModel metaModel, boolean useDocRoot) {
        log.info((Object)Msg.create("Reading XML file ").uri(file).txt(". XSDMetaModel-ID '").txt(metaModel.getID()).txt("'"));
        XMLReaderImpl reader = new XMLReaderImpl((ResourceSet)new ResourceSetImpl(), metaModel);
        return reader.readXML(file, useDocRoot);
    }

    public XMLReaderImpl(ResourceSet resourceSet, XSDMetaModel metaModel) {
        this.resourceSet = resourceSet;
        this.metaModel = metaModel;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public EObject readXML() {
        this.resourceSet.setPackageRegistry((EPackage.Registry)new EPackageRegistryImpl(this.metaModel.getXsdManager().getPackageRegistry()));
        URI xmlUri = this.resolveURI();
        OawXMLResource res = new OawXMLResource(xmlUri, this.metaModel);
        this.resourceSet.getResources().add((Object)res);
        try {
            res.load(this.options);
        }
        catch (Throwable e) {
            throw new WorkflowInterruptedException("Error loading XML file XML-File:" + xmlUri + ": " + e);
        }
        if (this.metaModel.getXsdManager().hasErrors()) {
            throw new WorkflowInterruptedException("There were errors loading the XSD meta models.");
        }
        if (res.getContents().size() < 1) {
            throw new WorkflowInterruptedException("Error loading XML file: contents is empty");
        }
        EObject docroot = (EObject)res.getContents().get(0);
        if (this.useDocumentRoot) {
            return docroot;
        }
        if (docroot.eContents().size() < 1) {
            throw new WorkflowInterruptedException("Error loading XML file: DocumentRoot is empty");
        }
        return (EObject)docroot.eContents().get(0);
    }

    private EObject readXML(String file, boolean useDocumentRoot) {
        this.setUri(file);
        this.setUseDocumentRoot(useDocumentRoot);
        return this.readXML();
    }

    private URI resolveURI() {
        if (this.baseURI == null) {
            return EcoreUtil2.getURI((String)this.uri);
        }
        return XSDUtil.resolve(this.resourceSet.getURIConverter(), this.baseURI, this.uri);
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setUseDocumentRoot(boolean useDocumentRoot) {
        this.useDocumentRoot = useDocumentRoot;
    }
}

