/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.databinding;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.xwt.IMultiValueConverter;
import org.eclipse.xwt.XWT;

public class AggregateObservableValue
extends AbstractObservableValue {
    private IObservableValue[] observableValues;
    private boolean updating = false;
    private IMultiValueConverter converter;
    private Object currentValue;
    private IValueChangeListener listener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            if (!AggregateObservableValue.this.updating) {
                AggregateObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)AggregateObservableValue.this.currentValue, (Object)AggregateObservableValue.this.doGetValue()));
            }
        }
    };

    public AggregateObservableValue(IObservableValue[] observableValues, IMultiValueConverter converter) {
        super(AggregateObservableValue.findRealm(observableValues));
        this.converter = converter;
        this.observableValues = observableValues;
        int i = 0;
        while (i < observableValues.length) {
            observableValues[i].addValueChangeListener(this.listener);
            ++i;
        }
        this.doGetValue();
    }

    private static Realm findRealm(IObservableValue[] observableValues) {
        IObservableValue[] iObservableValueArray = observableValues;
        if (observableValues.length != 0) {
            IObservableValue observableValue = iObservableValueArray[0];
            return observableValue.getRealm();
        }
        return XWT.getRealm();
    }

    public void doSetValue(Object value) {
        Object oldValue = this.doGetValue();
        try {
            this.updating = true;
            Object[] values = this.converter.convertBack(value);
            int i = 0;
            while (i < this.observableValues.length) {
                if (i < values.length) {
                    this.observableValues[i].setValue(values[i]);
                } else {
                    this.observableValues[i].setValue(null);
                }
                ++i;
            }
        }
        finally {
            this.updating = false;
        }
        this.doGetValue();
        this.currentValue = value;
        this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
    }

    public Object doGetValue() {
        Object[] values = new Object[this.observableValues.length];
        int i = 0;
        while (i < values.length) {
            values[i] = this.observableValues[i].getValue();
            ++i;
        }
        return this.converter.convert(values);
    }

    public Object getValueType() {
        return String[].class;
    }

    public synchronized void dispose() {
        int i = 0;
        while (i < this.observableValues.length) {
            this.observableValues[i].removeValueChangeListener(this.listener);
            ++i;
        }
        super.dispose();
    }
}

