/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Chars;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.rhino.TokenStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class DefaultNameGenerator
implements NameGenerator {
    private Map<Character, CharPriority> priorityLookupMap;
    static final char[] FIRST_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$".toCharArray();
    static final char[] NONFIRST_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789$".toCharArray();
    private Set<String> reservedNames;
    private String prefix;
    private int nameCount;
    private CharPriority[] firstChars;
    private CharPriority[] nonFirstChars;

    public DefaultNameGenerator() {
        this.buildPriorityLookupMap();
        HashSet reservedNames = Sets.newHashSetWithExpectedSize((int)0);
        this.reset(reservedNames, "", null);
    }

    public DefaultNameGenerator(Set<String> reservedNames, String prefix, @Nullable char[] reservedCharacters) {
        this.buildPriorityLookupMap();
        this.reset(reservedNames, prefix, reservedCharacters);
    }

    private DefaultNameGenerator(Set<String> reservedNames, String prefix, @Nullable char[] reservedCharacters, Map<Character, CharPriority> priorityLookupMap) {
        this.priorityLookupMap = Maps.newHashMapWithExpectedSize((int)NONFIRST_CHAR.length);
        for (Map.Entry<Character, CharPriority> entry : priorityLookupMap.entrySet()) {
            this.priorityLookupMap.put(entry.getKey(), entry.getValue().clone());
        }
        this.reset(reservedNames, prefix, reservedCharacters);
    }

    private void buildPriorityLookupMap() {
        this.priorityLookupMap = Maps.newHashMapWithExpectedSize((int)NONFIRST_CHAR.length);
        int order = 0;
        for (char c : NONFIRST_CHAR) {
            this.priorityLookupMap.put(Character.valueOf(c), new CharPriority(c, order));
            ++order;
        }
    }

    @Override
    public void reset(Set<String> reservedNames, String prefix, @Nullable char[] reservedCharacters) {
        this.reservedNames = reservedNames;
        this.prefix = prefix;
        this.nameCount = 0;
        this.firstChars = this.reserveCharacters(FIRST_CHAR, reservedCharacters);
        this.nonFirstChars = this.reserveCharacters(NONFIRST_CHAR, reservedCharacters);
        Arrays.sort(this.firstChars);
        Arrays.sort(this.nonFirstChars);
        this.checkPrefix(prefix);
    }

    @Override
    public NameGenerator clone(Set<String> reservedNames, String prefix, @Nullable char[] reservedCharacters) {
        return new DefaultNameGenerator(reservedNames, prefix, reservedCharacters, this.priorityLookupMap);
    }

    void favors(CharSequence sequence) {
        for (int i = 0; i < sequence.length(); ++i) {
            CharPriority c = this.priorityLookupMap.get(Character.valueOf(sequence.charAt(i)));
            if (c == null) continue;
            ++c.occurrence;
        }
    }

    CharPriority[] reserveCharacters(char[] chars, char[] reservedCharacters) {
        if (reservedCharacters == null || reservedCharacters.length == 0) {
            CharPriority[] result = new CharPriority[chars.length];
            for (int i = 0; i < chars.length; ++i) {
                result[i] = this.priorityLookupMap.get(Character.valueOf(chars[i]));
            }
            return result;
        }
        LinkedHashSet charSet = new LinkedHashSet(Chars.asList((char[])chars));
        for (char reservedCharacter : reservedCharacters) {
            charSet.remove(Character.valueOf(reservedCharacter));
        }
        CharPriority[] result = new CharPriority[charSet.size()];
        int index = 0;
        Iterator iterator = charSet.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            result[index++] = this.priorityLookupMap.get(Character.valueOf(c));
        }
        return result;
    }

    private void checkPrefix(String prefix) {
        if (prefix.length() > 0) {
            if (!DefaultNameGenerator.contains(this.firstChars, prefix.charAt(0))) {
                char[] chars = new char[this.firstChars.length];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = this.firstChars[i].name;
                }
                throw new IllegalArgumentException("prefix must start with one of: " + Arrays.toString(chars));
            }
            for (int pos = 1; pos < prefix.length(); ++pos) {
                char[] chars = new char[this.nonFirstChars.length];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = this.nonFirstChars[i].name;
                }
                if (DefaultNameGenerator.contains(this.nonFirstChars, prefix.charAt(pos))) continue;
                throw new IllegalArgumentException("prefix has invalid characters, must be one of: " + Arrays.toString(chars));
            }
        }
    }

    private static boolean contains(CharPriority[] arr, char c) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].name != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public String generateNextName() {
        String name;
        do {
            int pos;
            name = this.prefix;
            int i = this.nameCount;
            if (name.isEmpty()) {
                pos = i % this.firstChars.length;
                name = name + this.firstChars[pos].name;
                i /= this.firstChars.length;
            }
            while (i > 0) {
                pos = --i % this.nonFirstChars.length;
                name = name + this.nonFirstChars[pos].name;
                i /= this.nonFirstChars.length;
            }
            ++this.nameCount;
        } while (TokenStream.isKeyword(name) || this.reservedNames.contains(name));
        return name;
    }

    private static final class CharPriority
    implements Comparable<CharPriority> {
        final char name;
        int occurrence;
        final int order;

        CharPriority(char name, int order) {
            this.name = name;
            this.order = order;
            this.occurrence = 0;
        }

        public CharPriority clone() {
            CharPriority result = new CharPriority(this.name, this.order);
            result.occurrence = this.occurrence;
            return result;
        }

        @Override
        public int compareTo(CharPriority other) {
            int result = other.occurrence - this.occurrence;
            if (result != 0) {
                return result;
            }
            result = this.order - other.order;
            return result;
        }
    }
}

