/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.cmake.core.internal.ICMakeExecutionMarkerFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class CMakeErrorParser
implements AutoCloseable {
    private static final Pattern PTN_MSG_START;
    private static Map<String, MessageHandler> handlersByMessageStart;
    private MessageHandler currentHandler = new MhNull();
    private final ICMakeExecutionMarkerFactory markerFactory;
    private final StringBuilder buffer;

    static {
        handlersByMessageStart = new HashMap<String, MessageHandler>();
        StringBuilder ptnbuf = new StringBuilder("^");
        List<MessageHandler> markerHandlers = Arrays.asList(new MhStartLog(), new MhStatus(), new MhDeprError(), new MhDeprWarning(), new MhErrorDev(), new MhError(), new MhInternalError(), new MhWarningDev(), new MhWarning());
        Iterator<MessageHandler> it = markerHandlers.iterator();
        while (it.hasNext()) {
            MessageHandler h = it.next();
            handlersByMessageStart.put(h.getMessageStart(), h);
            ptnbuf.append(Pattern.quote(h.getMessageStart()));
            if (!it.hasNext()) continue;
            ptnbuf.append('|');
        }
        PTN_MSG_START = Pattern.compile(ptnbuf.toString());
    }

    public CMakeErrorParser(ICMakeExecutionMarkerFactory markerFactory) {
        this.markerFactory = Objects.requireNonNull(markerFactory);
        this.buffer = new StringBuilder(512);
    }

    public void addInput(CharSequence input) {
        this.buffer.append(input);
        this.processBuffer();
    }

    @Override
    public void close() {
        this.processMessage(this.currentHandler, this.buffer.toString().trim());
        this.buffer.delete(0, this.buffer.length());
    }

    private void processBuffer() {
        Matcher matcher = PTN_MSG_START.matcher("");
        while (true) {
            matcher.reset(this.buffer.subSequence(this.currentHandler.getMessageStart().length(), this.buffer.length()));
            if (!matcher.find()) break;
            String handlerId = matcher.group();
            MessageHandler newHandler = handlersByMessageStart.get(handlerId);
            int end = matcher.start() + this.currentHandler.getMessageStart().length();
            String message = this.buffer.substring(0, end);
            this.processMessage(this.currentHandler, message.trim());
            this.currentHandler = newHandler;
            this.buffer.delete(0, end);
        }
    }

    private void processMessage(MessageHandler handler, String fullMessage) {
        try {
            handler.processMessage(this.markerFactory, fullMessage);
        }
        catch (CoreException e) {
            Activator.getPlugin().getLog().log((IStatus)new Status(2, Activator.getId(), "CMake output error parsing failed", (Throwable)e));
        }
    }

    private static abstract class MessageHandler {
        private static final Pattern[] PTN_LOCATION = new Pattern[]{Pattern.compile("(?m)^ at (?<File>.+):(?<Lineno>\\d+).*$"), Pattern.compile("(?s)^: Error in cmake code at.(?<File>.+):(?<Lineno>\\d+).*$"), Pattern.compile("(?m)^ in (?<File>.+):(?<Lineno>\\d+).*$"), Pattern.compile("(?m)^ in (?<File>.+?):.*$"), Pattern.compile("(?m)^:\\s.+$")};
        private static final String GRP_FILE = "File";
        private static final String GRP_LINE = "Lineno";

        private MessageHandler() {
        }

        abstract String getMessageStart();

        abstract int getSeverity();

        public void processMessage(ICMakeExecutionMarkerFactory markerFactory, String fullMessage) throws CoreException {
            String content = fullMessage.substring(this.getMessageStart().length());
            HashMap<String, Object> attributes = new HashMap<String, Object>(3);
            attributes.put("location", this.getClass().getSimpleName());
            String filename = null;
            Pattern[] patternArray = PTN_LOCATION;
            int n = PTN_LOCATION.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern ptn = patternArray[n2];
                Matcher matcher = ptn.matcher(content);
                if (matcher.find()) {
                    try {
                        filename = matcher.group(GRP_FILE);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    try {
                        String lineno = matcher.group(GRP_LINE);
                        Integer lineNumber = Integer.parseInt(lineno);
                        attributes.put("lineNumber", lineNumber);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
                ++n2;
            }
            markerFactory.createMarker(fullMessage, this.getSeverity(), filename, attributes);
        }
    }

    private static class MhDeprError
    extends MessageHandler {
        private static final String START_DERROR = "CMake Deprecation Error";

        private MhDeprError() {
        }

        @Override
        String getMessageStart() {
            return START_DERROR;
        }

        @Override
        int getSeverity() {
            return 2;
        }

        public String toString() {
            return String.valueOf(super.toString()) + ": " + this.getMessageStart();
        }
    }

    private static class MhDeprWarning
    extends MessageHandler {
        private static final String START_DWARNING = "CMake Deprecation Warning";

        private MhDeprWarning() {
        }

        @Override
        String getMessageStart() {
            return START_DWARNING;
        }

        @Override
        int getSeverity() {
            return 1;
        }

        public String toString() {
            return String.valueOf(super.toString()) + ": " + this.getMessageStart();
        }
    }

    private static class MhError
    extends MessageHandler {
        private static final String START_ERROR = "CMake Error";

        private MhError() {
        }

        @Override
        String getMessageStart() {
            return START_ERROR;
        }

        @Override
        int getSeverity() {
            return 2;
        }

        public String toString() {
            return String.valueOf(super.toString()) + ": " + this.getMessageStart();
        }
    }

    private static class MhErrorDev
    extends MessageHandler {
        private static final String START_ERROR_DEV = "CMake Error (dev)";

        private MhErrorDev() {
        }

        @Override
        String getMessageStart() {
            return START_ERROR_DEV;
        }

        @Override
        int getSeverity() {
            return 2;
        }

        public String toString() {
            return String.valueOf(super.toString()) + ": " + this.getMessageStart();
        }
    }

    private static class MhInternalError
    extends MessageHandler {
        private static final String START_IERROR = "CMake Internal Error (please report a bug)";

        private MhInternalError() {
        }

        @Override
        String getMessageStart() {
            return START_IERROR;
        }

        @Override
        int getSeverity() {
            return 2;
        }

        public String toString() {
            return String.valueOf(super.toString()) + ": " + this.getMessageStart();
        }
    }

    private static class MhNull
    extends MessageHandler {
        private MhNull() {
        }

        @Override
        public void processMessage(ICMakeExecutionMarkerFactory markerFactory, String fullMessage) throws CoreException {
        }

        @Override
        String getMessageStart() {
            return "";
        }

        @Override
        int getSeverity() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(super.toString()) + ": " + this.getMessageStart();
        }
    }

    private static class MhStartLog
    extends MhNull {
        private static final String START_LOG = "CMake Debug Log";

        private MhStartLog() {
        }

        @Override
        String getMessageStart() {
            return START_LOG;
        }

        @Override
        int getSeverity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ": " + this.getMessageStart();
        }
    }

    private static class MhStatus
    extends MhNull {
        private static final String START_STATUS = "-- ";

        private MhStatus() {
        }

        @Override
        String getMessageStart() {
            return START_STATUS;
        }

        @Override
        int getSeverity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ": " + this.getMessageStart();
        }
    }

    private static class MhWarning
    extends MessageHandler {
        private static final String START_WARNING = "CMake Warning";

        private MhWarning() {
        }

        @Override
        String getMessageStart() {
            return START_WARNING;
        }

        @Override
        int getSeverity() {
            return 1;
        }

        public String toString() {
            return String.valueOf(super.toString()) + ": " + this.getMessageStart();
        }
    }

    private static class MhWarningDev
    extends MessageHandler {
        private static final String START_WARNING_DEV = "CMake Warning (dev)";

        private MhWarningDev() {
        }

        @Override
        String getMessageStart() {
            return START_WARNING_DEV;
        }

        @Override
        int getSeverity() {
            return 1;
        }

        public String toString() {
            return String.valueOf(super.toString()) + ": " + this.getMessageStart();
        }
    }
}

