/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.core.scannerconfig;

import org.eclipse.cdt.build.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public class ScannerConfigNature
implements IProjectNature {
    public static final String NATURE_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ScannerConfigNature";
    private IProject fProject;

    public void configure() throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(ScannerConfigBuilder.BUILDER_ID)) {
                return;
            }
            ++i;
        }
        ICommand command = description.newCommand();
        command.setBuilderName(ScannerConfigBuilder.BUILDER_ID);
        command.setBuilding(9, false);
        command.setBuilding(15, false);
        command.setBuilding(6, true);
        command.setBuilding(10, true);
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        newCommands[commands.length] = command;
        description.setBuildSpec(newCommands);
        this.getProject().setDescription(description, null);
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(ScannerConfigBuilder.BUILDER_ID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                break;
            }
            ++i;
        }
        this.getProject().setDescription(description, null);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public static void addScannerConfigNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        if (description.hasNature(NATURE_ID)) {
            return;
        }
        String[] ids = description.getNatureIds();
        String[] newIds = new String[ids.length + 1];
        System.arraycopy(ids, 0, newIds, 0, ids.length);
        newIds[ids.length] = NATURE_ID;
        description.setNatureIds(newIds);
        project.setDescription(description, null);
    }

    public static void removeScannerConfigNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        if (!description.hasNature(NATURE_ID)) {
            return;
        }
        String[] ids = description.getNatureIds();
        int i = 0;
        while (i < ids.length) {
            if (ids[i].equals(NATURE_ID)) {
                String[] newIds = new String[ids.length - 1];
                System.arraycopy(ids, 0, newIds, 0, i);
                System.arraycopy(ids, i + 1, newIds, i, ids.length - i - 1);
                description.setNatureIds(newIds);
                project.setDescription(description, null);
            }
            ++i;
        }
    }

    public static ICommand getBuildSpec(IProjectDescription description, String builderID) {
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    public static IProjectDescription setBuildSpec(IProjectDescription description, ICommand newCommand) {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldCommand = ScannerConfigNature.getBuildSpec(description, newCommand.getBuilderName());
        if (oldCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
            newCommands[oldCommands.length] = newCommand;
        } else {
            int i = 0;
            while (i < oldCommands.length) {
                if (oldCommands[i] == oldCommand) {
                    oldCommands[i] = newCommand;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
        return description;
    }
}

