/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.search.CSearchElement;
import org.eclipse.cdt.internal.ui.search.CSearchListContentProvider;
import org.eclipse.cdt.internal.ui.search.CSearchListLabelProvider;
import org.eclipse.cdt.internal.ui.search.CSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchTreeContentProvider;
import org.eclipse.cdt.internal.ui.search.CSearchTreeLabelProvider;
import org.eclipse.cdt.internal.ui.search.IPDOMSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.LineSearchElement;
import org.eclipse.cdt.internal.ui.search.TypeInfoSearchElement;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class CSearchViewPage
extends AbstractTextSearchViewPage {
    public static final int LOCATION_COLUMN_INDEX = 0;
    public static final int DEFINITION_COLUMN_INDEX = 1;
    public static final int MATCH_COLUMN_INDEX = 2;
    private static final String[] fColumnLabels = new String[]{CSearchMessages.PDOMSearchViewPageLocationColumn_label, CSearchMessages.PDOMSearchViewPageDefinitionColumn_label, CSearchMessages.PDOMSearchViewPageMatchColumn_label};
    private static final String KEY_LOCATION_COLUMN_WIDTH = "locationColumnWidth";
    private static final String KEY_DEFINITION_COLUMN_WIDTH = "definitionColumnWidth";
    private static final String KEY_MATCH_COLUMN_WIDTH = "matchColumnWidth";
    private static final String KEY_SHOW_ENCLOSING_DEFINITIONS = "showEnclosingDefinitions";
    private IPDOMSearchContentProvider contentProvider;
    private boolean fShowEnclosingDefinitions;
    private ShowEnclosingDefinitionsAction fShowEnclosingDefinitionsAction;
    private final int[] fColumnWidths = new int[]{300, 150, 300};

    public CSearchViewPage(int supportedLayouts) {
        super(supportedLayouts);
    }

    public CSearchViewPage() {
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.fShowEnclosingDefinitionsAction = new ShowEnclosingDefinitionsAction();
        IMenuManager menuManager = pageSite.getActionBars().getMenuManager();
        menuManager.add((IAction)this.fShowEnclosingDefinitionsAction);
        menuManager.updateAll(true);
        pageSite.getActionBars().updateActionBars();
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        IDialogSettings settings = this.getSettings();
        boolean showEnclosingDefinitions = true;
        if (settings.get(KEY_SHOW_ENCLOSING_DEFINITIONS) != null) {
            showEnclosingDefinitions = settings.getBoolean(KEY_SHOW_ENCLOSING_DEFINITIONS);
        }
        if (memento != null) {
            Boolean value = memento.getBoolean(KEY_SHOW_ENCLOSING_DEFINITIONS);
            if (value != null) {
                showEnclosingDefinitions = value;
            }
            String[] keys = new String[]{KEY_LOCATION_COLUMN_WIDTH, KEY_DEFINITION_COLUMN_WIDTH, KEY_MATCH_COLUMN_WIDTH};
            int i = 0;
            while (i < keys.length) {
                Integer width = memento.getInteger(keys[i]);
                if (width != null && width > 0) {
                    this.fColumnWidths[i] = width;
                }
                ++i;
            }
        }
        this.setShowEnclosingDefinitions(showEnclosingDefinitions);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.saveColumnWidths();
        memento.putInteger(KEY_DEFINITION_COLUMN_WIDTH, this.fColumnWidths[1]);
        memento.putInteger(KEY_LOCATION_COLUMN_WIDTH, this.fColumnWidths[0]);
        memento.putInteger(KEY_MATCH_COLUMN_WIDTH, this.fColumnWidths[2]);
        memento.putBoolean(KEY_SHOW_ENCLOSING_DEFINITIONS, this.fShowEnclosingDefinitions);
    }

    public void setShowEnclosingDefinitions(boolean showEnclosingDefinitions) {
        StructuredViewer viewer;
        if (this.fShowEnclosingDefinitions == showEnclosingDefinitions) {
            return;
        }
        this.fShowEnclosingDefinitions = showEnclosingDefinitions;
        this.getSettings().put(KEY_SHOW_ENCLOSING_DEFINITIONS, this.fShowEnclosingDefinitions);
        if (this.fShowEnclosingDefinitionsAction.isChecked() != showEnclosingDefinitions) {
            this.fShowEnclosingDefinitionsAction.setChecked(showEnclosingDefinitions);
        }
        if ((viewer = this.getViewer()) instanceof TableViewer) {
            TableViewer tableViewer = (TableViewer)viewer;
            TableColumn tableColumn = tableViewer.getTable().getColumn(1);
            if (this.fShowEnclosingDefinitions) {
                tableColumn.setWidth(this.fColumnWidths[1]);
                tableColumn.setResizable(true);
            } else {
                this.fColumnWidths[1] = tableColumn.getWidth();
                tableColumn.setWidth(0);
                tableColumn.setResizable(false);
            }
        }
        if (viewer != null) {
            viewer.refresh();
        }
    }

    public boolean isShowEnclosingDefinitions() {
        return this.fShowEnclosingDefinitions;
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            this.contentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.contentProvider = new CSearchTreeContentProvider(this);
        viewer.setComparator((ViewerComparator)new SearchViewerComparator());
        viewer.setContentProvider((IContentProvider)((CSearchTreeContentProvider)this.contentProvider));
        CSearchTreeLabelProvider innerLabelProvider = new CSearchTreeLabelProvider(this);
        ColoringLabelProvider labelProvider = new ColoringLabelProvider(innerLabelProvider);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.createColumns(viewer);
        this.contentProvider = new CSearchListContentProvider(this);
        viewer.setComparator((ViewerComparator)new SearchViewerComparator());
        viewer.setContentProvider((IContentProvider)((CSearchListContentProvider)this.contentProvider));
    }

    protected TableViewer createTableViewer(Composite parent) {
        TableViewer tableViewer = new TableViewer(parent, 66306);
        tableViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CSearchViewPage.this.saveColumnWidths();
            }
        });
        return tableViewer;
    }

    private void saveColumnWidths() {
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TableViewer) {
            TableViewer tableViewer = (TableViewer)viewer;
            int i = 0;
            while (i < fColumnLabels.length) {
                if (i != 1 || this.fShowEnclosingDefinitions) {
                    this.fColumnWidths[i] = tableViewer.getTable().getColumn(i).getWidth();
                }
                ++i;
            }
        }
    }

    private void createColumns(TableViewer viewer) {
        int i = 0;
        while (i < fColumnLabels.length) {
            TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
            viewerColumn.setLabelProvider((CellLabelProvider)new CSearchListLabelProvider(this, i));
            TableColumn tableColumn = viewerColumn.getColumn();
            tableColumn.setText(fColumnLabels[i]);
            tableColumn.setWidth(this.fColumnWidths[i]);
            tableColumn.setResizable(true);
            tableColumn.setMoveable(false);
            if (i == 1 && !this.fShowEnclosingDefinitions) {
                tableColumn.setWidth(0);
                tableColumn.setResizable(false);
            }
            ++i;
        }
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        if (!(match instanceof CSearchMatch)) {
            return;
        }
        try {
            Object element = ((CSearchMatch)match).getElement();
            IIndexFileLocation ifl = ((CSearchElement)element).getLocation();
            IPath path = IndexLocationFactory.getPath((IIndexFileLocation)ifl);
            IEditorPart editor = EditorUtility.openInEditor(path, null, activate);
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(currentOffset, currentLength);
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    private class SearchViewerComparator
    extends ViewerComparator {
        private SearchViewerComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof LineSearchElement && e2 instanceof LineSearchElement) {
                String p2;
                String p1;
                int cmp;
                LineSearchElement l1 = (LineSearchElement)e1;
                LineSearchElement l2 = (LineSearchElement)e2;
                if (viewer instanceof TableViewer && (cmp = (p1 = l1.getLocation().getURI().getPath()).compareTo(p2 = l2.getLocation().getURI().getPath())) != 0) {
                    return cmp;
                }
                return l1.getLineNumber() - l2.getLineNumber();
            }
            return super.compare(viewer, e1, e2);
        }

        public int category(Object element) {
            if (element instanceof IStatus) {
                return -1000;
            }
            if (element instanceof TypeInfoSearchElement) {
                TypeInfoSearchElement searchElement = (TypeInfoSearchElement)element;
                int type = searchElement.getTypeInfo().getCElementType();
                if (type < 0) {
                    type = 0;
                }
                return type;
            }
            if (element instanceof ICElement) {
                int type = ((ICElement)element).getElementType();
                if (type < 0) {
                    type = 0;
                }
                return Math.min(Math.max(0, type), 900);
            }
            if (element instanceof IPath || element instanceof IIndexFileLocation) {
                return 999;
            }
            if (element == IPDOMSearchContentProvider.URI_CONTAINER) {
                return 1000;
            }
            return 2000;
        }
    }

    private class ShowEnclosingDefinitionsAction
    extends Action {
        public ShowEnclosingDefinitionsAction() {
            super(CSearchMessages.PDOMSearchViewPage_ShowEnclosingDefinitions_actionLabel, 32);
            this.setChecked(CSearchViewPage.this.fShowEnclosingDefinitions);
        }

        public void run() {
            CSearchViewPage.this.setShowEnclosingDefinitions(this.isChecked());
        }
    }
}

