/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public abstract class LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate2 {
    private static final String DEBUG_CORE = "org.eclipse.debug.core";
    private static final String DEBUG_UI = "org.eclipse.debug.ui";
    protected static final IStatus promptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    protected static final IStatus switchToDebugPromptStatus = new Status(1, "org.eclipse.debug.core", 201, "", null);
    protected static final IStatus complileErrorPromptStatus = new Status(1, "org.eclipse.debug.core", 202, "", null);
    protected static final IStatus saveScopedDirtyEditors = new Status(1, "org.eclipse.debug.core", 222, "", null);
    protected static final IStatus complileErrorProjectPromptStatus = new Status(1, "org.eclipse.debug.core", 203, "", null);

    @Override
    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return null;
    }

    @Override
    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IProject[] projects = this.getBuildOrder(configuration, mode);
        if (projects == null) {
            return true;
        }
        this.buildProjects(projects, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        return false;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return null;
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return null;
    }

    @Override
    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        try {
            IProject[] projects = this.getProjectsForProblemSearch(configuration, mode);
            if (projects == null) {
                return true;
            }
            boolean continueLaunch = true;
            monitor.subTask(DebugCoreMessages.LaunchConfigurationDelegate_6);
            ArrayList<Object> errors = new ArrayList<Object>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                monitor.subTask(MessageFormat.format(DebugCoreMessages.LaunchConfigurationDelegate_7, project.getName()));
                if (this.existsProblems(project)) {
                    errors.add(project);
                }
                ++n2;
            }
            if (!errors.isEmpty()) {
                errors.add(0, configuration);
                IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(promptStatus);
                if (prompter != null) {
                    continueLaunch = (Boolean)prompter.handleStatus(complileErrorProjectPromptStatus, errors);
                }
            }
            boolean bl = continueLaunch;
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (!this.saveBeforeLaunch(configuration, mode, monitor)) {
            return false;
        }
        if (mode.equals("run") && configuration.supportsMode("debug")) {
            IBreakpoint[] breakpoints = this.getBreakpoints(configuration);
            if (breakpoints == null) {
                return true;
            }
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint.isEnabled()) {
                    boolean launchInDebugModeInstead;
                    IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(promptStatus);
                    return prompter == null || !(launchInDebugModeInstead = ((Boolean)prompter.handleStatus(switchToDebugPromptStatus, configuration)).booleanValue());
                }
                ++n2;
            }
        }
        return true;
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        try {
            IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(promptStatus);
            if (prompter != null) {
                IProject[] buildOrder = this.getBuildOrder(configuration, mode);
                if (!((Boolean)prompter.handleStatus(saveScopedDirtyEditors, new Object[]{configuration, buildOrder})).booleanValue()) {
                    return false;
                }
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }

    protected IBreakpoint[] getBreakpoints(ILaunchConfiguration configuration) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (!breakpointManager.isEnabled()) {
            return null;
        }
        return breakpointManager.getBreakpoints();
    }

    protected IProject[] computeReferencedBuildOrder(IProject[] baseProjects) throws CoreException {
        HashSet<IProject> unorderedProjects = new HashSet<IProject>();
        IProject[] iProjectArray = baseProjects;
        int n = baseProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject baseProject = iProjectArray[n2];
            unorderedProjects.add(baseProject);
            this.addReferencedProjects(baseProject, unorderedProjects);
            ++n2;
        }
        IProject[] projectSet = unorderedProjects.toArray(new IProject[unorderedProjects.size()]);
        return this.computeBuildOrder(projectSet);
    }

    protected void addReferencedProjects(IProject project, Set<IProject> references) throws CoreException {
        if (project.isOpen()) {
            IProject[] iProjectArray = project.getReferencedProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject refProject = iProjectArray[n2];
                if (refProject.exists() && !references.contains(refProject)) {
                    references.add(refProject);
                    this.addReferencedProjects(refProject, references);
                }
                ++n2;
            }
        }
    }

    protected IProject[] computeBuildOrder(IProject[] projects) {
        String[] orderedNames = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
        if (orderedNames != null) {
            ArrayList<Object> orderedProjects = new ArrayList<Object>(projects.length);
            ArrayList unorderedProjects = new ArrayList(projects.length);
            Collections.addAll(unorderedProjects, projects);
            String[] stringArray = orderedNames;
            int n = orderedNames.length;
            int n2 = 0;
            while (n2 < n) {
                String projectName = stringArray[n2];
                Iterator iterator = unorderedProjects.iterator();
                while (iterator.hasNext()) {
                    IProject project = (IProject)iterator.next();
                    if (!project.getName().equals(projectName)) continue;
                    orderedProjects.add(project);
                    iterator.remove();
                    break;
                }
                ++n2;
            }
            orderedProjects.addAll(unorderedProjects);
            return orderedProjects.toArray(new IProject[orderedProjects.size()]);
        }
        IWorkspace.ProjectOrder po = ResourcesPlugin.getWorkspace().computeProjectOrder(projects);
        return po.projects;
    }

    protected boolean existsProblems(IProject proj) throws CoreException {
        IMarker[] markers = proj.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        if (markers.length > 0) {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (this.isLaunchProblem(marker)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean isLaunchProblem(IMarker problemMarker) throws CoreException {
        Integer severity = (Integer)problemMarker.getAttribute("severity");
        if (severity != null) {
            return severity >= 2;
        }
        return false;
    }

    protected void buildProjects(IProject[] projects, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable build = pm -> {
            SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)pm, (String)DebugCoreMessages.LaunchConfigurationDelegate_scoped_incremental_build, (int)projects.length);
            try {
                IProject[] iProjectArray2 = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray2[n2];
                    if (localmonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    project.build(10, (IProgressMonitor)localmonitor.newChild(1));
                    ++n2;
                }
            }
            finally {
                localmonitor.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(build, monitor);
    }
}

