/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;

public class ScrollBarLayout
extends AbstractLayout {
    public static final String UP_ARROW = "up arrow";
    public static final String DOWN_ARROW = "down arrow";
    public static final String THUMB = "thumb";
    public static final String PAGE_UP = "page_up";
    public static final String PAGE_DOWN = "page_down";
    IFigure up;
    IFigure down;
    IFigure thumb;
    IFigure pageUp;
    IFigure pageDown;
    protected final Transposer transposer;

    public ScrollBarLayout(Transposer t) {
        this.transposer = t;
    }

    @Override
    public void setConstraint(IFigure figure, Object constraint) {
        if (constraint.equals(UP_ARROW)) {
            this.up = figure;
        } else if (constraint.equals(DOWN_ARROW)) {
            this.down = figure;
        } else if (constraint.equals(THUMB)) {
            this.thumb = figure;
        } else if (constraint.equals(PAGE_UP)) {
            this.pageUp = figure;
        } else if (constraint.equals(PAGE_DOWN)) {
            this.pageDown = figure;
        }
    }

    @Override
    protected Dimension calculatePreferredSize(IFigure parent, int w, int h) {
        Insets insets = this.transposer.t(parent.getInsets());
        Dimension d = new Dimension(16, 64);
        d.expand(insets.getWidth(), insets.getHeight());
        return this.transposer.t(d);
    }

    @Override
    public void layout(IFigure parent) {
        int min;
        ScrollBar scrollBar = (ScrollBar)parent;
        Rectangle trackBounds = this.layoutButtons(scrollBar);
        int extent = scrollBar.getExtent();
        int max = scrollBar.getMaximum();
        int totalRange = max - (min = scrollBar.getMinimum());
        int valueRange = totalRange - extent;
        if (valueRange < 1 || !scrollBar.isEnabled()) {
            Rectangle boundsUpper = new Rectangle(trackBounds);
            Rectangle boundsLower = new Rectangle(trackBounds);
            boundsUpper.height /= 2;
            boundsLower.y += boundsUpper.height;
            boundsLower.height = trackBounds.height - boundsUpper.height;
            if (this.pageUp != null) {
                this.pageUp.setBounds(this.transposer.t(boundsUpper));
            }
            if (this.pageDown != null) {
                this.pageDown.setBounds(this.transposer.t(boundsLower));
            }
            return;
        }
        if (totalRange == 0) {
            return;
        }
        int thumbHeight = Math.max(this.thumb == null ? 0 : this.thumb.getMinimumSize().height, trackBounds.height * extent / totalRange);
        if (this.thumb != null) {
            this.thumb.setVisible(trackBounds.height > thumbHeight);
        }
        int thumbY = trackBounds.y + (trackBounds.height - thumbHeight) * (scrollBar.getValue() - min) / valueRange;
        Rectangle thumbBounds = new Rectangle(trackBounds.x, thumbY, trackBounds.width, thumbHeight);
        if (this.thumb != null) {
            this.thumb.setBounds(this.transposer.t(thumbBounds));
        }
        if (this.pageUp != null) {
            this.pageUp.setBounds(this.transposer.t(new Rectangle(trackBounds.x, trackBounds.y, trackBounds.width, thumbBounds.y - trackBounds.y)));
        }
        if (this.pageDown != null) {
            this.pageDown.setBounds(this.transposer.t(new Rectangle(trackBounds.x, thumbBounds.y + thumbHeight, trackBounds.width, trackBounds.bottom() - thumbBounds.bottom())));
        }
    }

    protected Rectangle layoutButtons(ScrollBar scrollBar) {
        Rectangle bounds = this.transposer.t(scrollBar.getClientArea());
        Dimension buttonSize = new Dimension(bounds.width, Math.min(bounds.width, bounds.height / 2));
        if (this.up != null) {
            this.up.setBounds(this.transposer.t(new Rectangle(bounds.getTopLeft(), buttonSize)));
        }
        if (this.down != null) {
            Rectangle r = new Rectangle(bounds.x, bounds.bottom() - buttonSize.height, buttonSize.width, buttonSize.height);
            this.down.setBounds(this.transposer.t(r));
        }
        Rectangle trackBounds = bounds.getCropped(new Insets(this.up == null ? 0 : buttonSize.height, 0, this.down == null ? 0 : buttonSize.height, 0));
        return trackBounds;
    }

    @Override
    public void remove(IFigure child) {
        if (child == this.up) {
            this.up = null;
        } else if (child == this.down) {
            this.down = null;
        } else if (child == this.thumb) {
            this.thumb = null;
        } else if (child == this.pageUp) {
            this.pageUp = null;
        } else if (child == this.pageDown) {
            this.pageDown = null;
        }
    }
}

