/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.graph.Vertex;

class Segment {
    Vertex start;
    Vertex end;

    Segment(Vertex start, Vertex end) {
        this.start = start;
        this.end = end;
    }

    double cosine(Segment otherSegment) {
        double cos = (double)((this.start.x - this.end.x) * (otherSegment.end.x - otherSegment.start.x) + (this.start.y - this.end.y) * (otherSegment.end.y - otherSegment.start.y)) / (this.getLength() * otherSegment.getLength());
        double sin = (this.start.x - this.end.x) * (otherSegment.end.y - otherSegment.start.y) - (this.start.y - this.end.y) * (otherSegment.end.x - otherSegment.start.x);
        if (sin < 0.0) {
            return 1.0 + cos;
        }
        return -(1.0 + cos);
    }

    long crossProduct(Segment otherSegment) {
        return (this.start.x - this.end.x) * (otherSegment.end.y - this.end.y) - (this.start.y - this.end.y) * (otherSegment.end.x - this.end.x);
    }

    private double getLength() {
        return this.end.getDistance(this.start);
    }

    double getSlope() {
        if (this.end.x - this.start.x >= 0) {
            return this.end.y - this.start.y;
        }
        return -(this.end.y - this.start.y);
    }

    boolean intersects(int sx, int sy, int tx, int ty) {
        return Geometry.linesIntersect(this.start.x, this.start.y, this.end.x, this.end.y, sx, sy, tx, ty);
    }

    boolean intersects(Point s, Point t) {
        return this.intersects(s.x, s.y, t.x, t.y);
    }

    public String toString() {
        return this.start + "---" + this.end;
    }
}

