/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;

class EclipseProxySelector
extends ProxySelector {
    private final IProxyService service;

    EclipseProxySelector(IProxyService s) {
        this.service = s;
    }

    @Override
    public List<Proxy> select(URI uri) {
        ArrayList<Proxy> r = new ArrayList<Proxy>();
        String host = uri.getHost();
        if (host != null) {
            String type = "SOCKS";
            if ("http".equals(uri.getScheme())) {
                type = "HTTP";
            } else if ("ftp".equals(uri.getScheme())) {
                type = "HTTP";
            } else if ("https".equals(uri.getScheme())) {
                type = "HTTPS";
            }
            try {
                IProxyData[] dataArray;
                URI queryUri = new URI(type, "//" + host, null);
                IProxyData[] iProxyDataArray = dataArray = this.service.select(queryUri);
                int n = dataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProxyData data = iProxyDataArray[n2];
                    if ("HTTP".equals(data.getType())) {
                        this.addProxy(r, Proxy.Type.HTTP, data);
                    } else if ("HTTPS".equals(data.getType())) {
                        this.addProxy(r, Proxy.Type.HTTP, data);
                    } else if ("SOCKS".equals(data.getType())) {
                        this.addProxy(r, Proxy.Type.SOCKS, data);
                    }
                    ++n2;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (r.isEmpty()) {
            r.add(Proxy.NO_PROXY);
        }
        return r;
    }

    private void addProxy(ArrayList<Proxy> r, Proxy.Type type, IProxyData d) {
        try {
            r.add(new Proxy(type, new InetSocketAddress(InetAddress.getByName(d.getHost()), d.getPort())));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }
}

