/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public class PushOperation {
    private final Repository localDb;
    private final PushOperationSpecification specification;
    private final boolean dryRun;
    private final String remoteName;
    private final int timeout;
    private OutputStream out;
    private PushOperationResult operationResult;
    private CredentialsProvider credentialsProvider;

    public PushOperation(Repository localDb, PushOperationSpecification specification, boolean dryRun, int timeout) {
        this(localDb, null, specification, dryRun, timeout);
    }

    public PushOperation(Repository localDb, String remoteName, boolean dryRun, int timeout) {
        this(localDb, remoteName, null, dryRun, timeout);
    }

    private PushOperation(Repository localDb, String remoteName, PushOperationSpecification specification, boolean dryRun, int timeout) {
        this.localDb = localDb;
        this.specification = specification;
        this.dryRun = dryRun;
        this.remoteName = remoteName;
        this.timeout = timeout;
    }

    public static RemoteConfig getRemote(String branch, Config config) {
        List allRemotes;
        if (branch == null) {
            return null;
        }
        String defaultPushRemote = config.getString("remote", branch, "pushDefault");
        String remoteName = null;
        if (!ObjectId.isId((String)branch) && (remoteName = config.getString("branch", branch, "pushRemote")) == null) {
            remoteName = defaultPushRemote != null ? defaultPushRemote : config.getString("branch", branch, "remote");
        }
        if (defaultPushRemote == null) {
            defaultPushRemote = "origin";
        }
        try {
            allRemotes = RemoteConfig.getAllRemoteConfigs((Config)config);
        }
        catch (URISyntaxException e) {
            return null;
        }
        RemoteConfig defaultConfig = null;
        for (RemoteConfig cfg : allRemotes) {
            if (remoteName != null && cfg.getName().equals(remoteName)) {
                return cfg;
            }
            if (cfg.getName().equals(defaultPushRemote)) {
                defaultConfig = cfg;
                continue;
            }
            if (defaultConfig != null || !cfg.getName().equals("origin")) continue;
            defaultConfig = cfg;
        }
        return defaultConfig;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public PushOperationResult getOperationResult() {
        if (this.operationResult == null) {
            throw new IllegalStateException(CoreText.OperationNotYetExecuted);
        }
        return this.operationResult;
    }

    public PushOperationSpecification getSpecification() {
        return this.specification;
    }

    public void run(IProgressMonitor actMonitor) throws InvocationTargetException {
        block33: {
            if (this.operationResult != null) {
                throw new IllegalStateException(CoreText.OperationAlreadyExecuted);
            }
            if (this.specification != null) {
                for (URIish uri : this.specification.getURIs()) {
                    for (RemoteRefUpdate update : this.specification.getRefUpdates(uri)) {
                        if (update.getStatus() == RemoteRefUpdate.Status.NOT_ATTEMPTED) continue;
                        throw new IllegalStateException(CoreText.RemoteRefUpdateCantBeReused);
                    }
                }
            }
            int totalWork = this.specification != null ? this.specification.getURIsNumber() : 1;
            String taskName = this.dryRun ? CoreText.PushOperation_taskNameDryRun : CoreText.PushOperation_taskNameNormalRun;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)actMonitor, (int)totalWork);
            progress.setTaskName(taskName);
            this.operationResult = new PushOperationResult();
            Object object = null;
            Object var6_8 = null;
            try (Git git = new Git(this.localDb);){
                if (this.specification != null) {
                    for (URIish uri : this.specification.getURIs()) {
                        if (progress.isCanceled()) {
                            this.operationResult.addOperationResult(uri, CoreText.PushOperation_resultCancelled);
                            progress.worked(1);
                            continue;
                        }
                        Collection<RemoteRefUpdate> refUpdates = this.specification.getRefUpdates(uri);
                        EclipseGitProgressTransformer gitSubMonitor = new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(1));
                        try {
                            Throwable throwable = null;
                            Object var13_29 = null;
                            try (Transport transport = Transport.open((Repository)this.localDb, (URIish)uri);){
                                transport.setDryRun(this.dryRun);
                                transport.setTimeout(this.timeout);
                                if (this.credentialsProvider != null) {
                                    transport.setCredentialsProvider(this.credentialsProvider);
                                }
                                PushResult result = transport.push((ProgressMonitor)gitSubMonitor, refUpdates, this.out);
                                this.operationResult.addOperationResult(result.getURI(), result);
                                this.specification.addURIRefUpdates(result.getURI(), result.getRemoteUpdates());
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (JGitInternalException e) {
                            String errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                            String userMessage = NLS.bind((String)CoreText.PushOperation_InternalExceptionOccurredMessage, (Object)errorMessage);
                            this.handleException(uri, (Exception)((Object)e), userMessage);
                        }
                        catch (Exception e) {
                            this.handleException(uri, e, e.getMessage());
                        }
                    }
                    break block33;
                }
                EclipseGitProgressTransformer gitMonitor = new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(totalWork));
                try {
                    Iterable results = ((PushCommand)((PushCommand)git.push().setRemote(this.remoteName).setDryRun(this.dryRun).setTimeout(this.timeout)).setProgressMonitor((ProgressMonitor)gitMonitor).setCredentialsProvider(this.credentialsProvider)).setOutputStream(this.out).call();
                    for (PushResult result : results) {
                        this.operationResult.addOperationResult(result.getURI(), result);
                    }
                }
                catch (JGitInternalException e) {
                    String errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                    String userMessage = NLS.bind((String)CoreText.PushOperation_InternalExceptionOccurredMessage, (Object)errorMessage);
                    URIish uri = this.getPushURIForErrorHandling();
                    this.handleException(uri, (Exception)((Object)e), userMessage);
                }
                catch (Exception e) {
                    URIish uri = this.getPushURIForErrorHandling();
                    this.handleException(uri, e, e.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
    }

    private void handleException(URIish uri, Exception e, String userMessage) {
        String uriString;
        if (uri != null) {
            this.operationResult.addOperationResult(uri, userMessage);
            uriString = uri.toString();
        } else {
            uriString = "retrieving URI failed";
        }
        String userMessageForUri = NLS.bind((String)CoreText.PushOperation_ExceptionOccurredDuringPushOnUriMessage, (Object)uriString, (Object)userMessage);
        Activator.logError(userMessageForUri, e);
    }

    private URIish getPushURIForErrorHandling() {
        RemoteConfig rc = null;
        try {
            rc = new RemoteConfig((Config)this.localDb.getConfig(), this.remoteName);
            return rc.getPushURIs().isEmpty() ? (URIish)rc.getURIs().get(0) : (URIish)rc.getPushURIs().get(0);
        }
        catch (URISyntaxException e) {
            Activator.logError("Reading RemoteConfig failed", e);
            return null;
        }
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }
}

