/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.history;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitHistory;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.history.Branch;
import org.eclipse.emf.cdo.internal.ui.history.Commit;
import org.eclipse.emf.cdo.internal.ui.history.Net;
import org.eclipse.emf.cdo.internal.ui.history.Segment;
import org.eclipse.emf.cdo.internal.ui.history.Track;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransactionCommentator;
import org.eclipse.emf.cdo.ui.widgets.CommitHistoryComposite;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public final class NetRenderer
implements Listener {
    private static final int ROUND_EDGE = 3;
    private static final int ARC_SIZE = 8;
    private static final int TRACK_OFFSET = 4;
    private static final int TRACK_WIDTH = 14;
    private static final int LINE_WIDTH = 2;
    private static final int UNKNOWN = -1;
    private final Color colorDotFill;
    private final Color colorDotOutline;
    private final Color colorBadgeFill;
    private final Color colorBadgeOutline;
    private Net net;
    private GC gc;
    private boolean antiAliasing = true;
    private int dotSize = -1;
    private int dotSizeHalf;
    private int textHeight = -1;
    private int cellHeight = -1;
    private int cellHeightHalf;
    private int cellX;
    private int cellY;
    private Color cellForeground;
    private Color cellBackground;
    private CommitHistoryComposite.LabelProvider labelProvider;

    public NetRenderer(TableViewer tableViewer) {
        this.labelProvider = (CommitHistoryComposite.LabelProvider)tableViewer.getLabelProvider();
        ResourceManager resourceManager = this.labelProvider.getResourceManager();
        this.colorDotFill = resourceManager.createColor(new RGB(220, 220, 220));
        this.colorDotOutline = resourceManager.createColor(new RGB(110, 110, 110));
        this.colorBadgeFill = resourceManager.createColor(new RGB(188, 220, 188));
        this.colorBadgeOutline = resourceManager.createColor(new RGB(0, 128, 0));
        Table table = tableViewer.getTable();
        table.addListener(41, (Listener)this);
        table.addListener(42, (Listener)this);
        table.addListener(40, (Listener)this);
    }

    public Net getNet() {
        return this.net;
    }

    public void addCommit(CDOCommitInfo commitInfo) {
        if (this.net != null && !(commitInfo instanceof CDOCommitHistory.TriggerLoadElement)) {
            this.net.addCommit(commitInfo);
        }
    }

    public void setInput(CommitHistoryComposite.Input input) {
        if (input != null) {
            CDOSession session = input.getSession();
            CDOObject object = input.getObject();
            CDOID objectID = object == null ? null : object.cdoID();
            ResourceManager resourceManager = this.labelProvider.getResourceManager();
            this.net = new Net(session, objectID, resourceManager);
        } else {
            this.net = null;
        }
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 41: {
                event.width = this.handlePaintEvent(event, true) + 4;
                break;
            }
            case 42: {
                this.handlePaintEvent(event, false);
                break;
            }
            case 40: {
                event.detail &= 0xFFFFFFEF;
            }
        }
    }

    public int handlePaintEvent(Event event, boolean justMeasureWidth) {
        try {
            this.gc = event.gc;
            if (this.antiAliasing) {
                try {
                    this.gc.setAntialias(1);
                }
                catch (SWTException ex) {
                    this.antiAliasing = false;
                }
            }
            if (this.textHeight == -1) {
                this.textHeight = this.gc.stringExtent((String)"/").y;
                this.cellHeight = event.height;
                this.cellHeightHalf = this.cellHeight / 2;
                this.dotSize = (int)((float)Math.min(this.cellHeight, 14) * 0.5f);
                this.dotSize += this.dotSize & 1;
                this.dotSizeHalf = this.dotSize / 2;
            }
            this.cellX = event.x;
            this.cellY = event.y;
            this.cellForeground = this.gc.getForeground();
            this.cellBackground = this.gc.getBackground();
            CDOCommitInfo commitInfo = (CDOCommitInfo)((TableItem)event.item).getData();
            return this.drawCell(commitInfo, event.index, justMeasureWidth);
        }
        catch (Throwable ex) {
            if (!this.net.isHideExceptions()) {
                OM.LOG.error(ex);
                this.net.hideExceptions();
            }
            return 0;
        }
    }

    private int drawCell(CDOCommitInfo commitInfo, int columnIndex, boolean justMeasureWidth) {
        CDOBranchPoint mergeSource;
        int x = 4;
        if (columnIndex == 1) {
            if (!(commitInfo instanceof CDOCommitHistory.TriggerLoadElement)) {
                x += this.drawCommit(commitInfo, justMeasureWidth);
            }
        } else {
            Image image = this.labelProvider.getColumnImage(commitInfo, columnIndex);
            if (image != null) {
                Rectangle bounds = image.getBounds();
                x += 2;
                if (!justMeasureWidth) {
                    this.gc.drawImage(image, bounds.x, bounds.y, bounds.width, bounds.height, this.cellX + x - 4, this.cellY + 1, bounds.width, bounds.height);
                }
                x += bounds.width;
            }
        }
        String text = this.labelProvider.getColumnText(commitInfo, columnIndex);
        if (columnIndex == 1 && (mergeSource = commitInfo.getMergeSource()) != null && !text.startsWith("Merge from ")) {
            StringBuilder builder = new StringBuilder();
            CDOTransactionCommentator.appendMerge((StringBuilder)builder, (CDOBranchPoint)mergeSource);
            if (text.length() != 0) {
                builder.append(", ");
                builder.append(text);
            }
            text = builder.toString();
        }
        int width = this.drawText(text, x, this.cellHeightHalf, false, justMeasureWidth);
        x += width;
        if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
            if (width != 0) {
                width += 16;
            }
            if (!justMeasureWidth) {
                int y = this.cellHeightHalf + 1;
                int x2 = this.gc.getClipping().width;
                this.drawLine(width, y, x2, y, this.colorDotOutline);
            }
        }
        return x;
    }

    private int drawCommit(CDOCommitInfo commitInfo, boolean justMeasureWidth) {
        Commit commit = this.net.getOrAddCommit(commitInfo);
        Branch commitBranch = commit.getBranch();
        Segment[] segments = commit.getRowSegments();
        Segment commitSegment = commit.getSegment();
        long commitTime = commit.getTime();
        boolean commitLastInBranch = commit.isLastInBranch();
        if (!justMeasureWidth) {
            Segment mergeSegment;
            Track commitTrack = commitSegment.getTrack();
            Color commitColor = commitBranch.getColor();
            int commitTrackPosition = commitTrack.getPosition();
            int commitTrackCenter = this.getTrackCenter(commitTrackPosition);
            int i = 0;
            while (i < segments.length) {
                Segment segment = segments[i];
                if (segment != null && segment != commitSegment) {
                    Branch branch = segment.getBranch();
                    boolean merge = segment.isMerge();
                    Color color = branch.getColor();
                    int lineStyle = merge ? 3 : 1;
                    int trackCenter = this.getTrackCenter(i);
                    int positionDelta = Math.abs(i - commitTrackPosition);
                    int horizontal = (positionDelta - 1) * 14 + 6 + 3;
                    if (i < commitTrackPosition) {
                        horizontal = -horizontal;
                    }
                    if (merge ? commitTime == segment.getLastCommitTime() || commitTime == segment.getFirstCommitTime() : commitTime == segment.getFirstVisualTime() && segment.isComplete()) {
                        boolean down = merge && commitTime == segment.getLastCommitTime();
                        this.drawHorizontalLineWithRoundEdge(color, lineStyle, commitTrackCenter, trackCenter, horizontal, down);
                    } else {
                        Commit mergeSource = commit.getMergeSource();
                        if (mergeSource != null && mergeSource == segment.getMergeSource()) {
                            this.drawHorizontalLineWithRoundEdge(color, lineStyle, commitTrackCenter, trackCenter, horizontal, true);
                        }
                        this.drawLine(trackCenter, 0, trackCenter, this.cellHeight, color, lineStyle);
                    }
                }
                ++i;
            }
            if (!commitLastInBranch) {
                this.drawLine(commitTrackCenter, 0, commitTrackCenter, this.cellHeightHalf, commitColor);
            } else if (commit.getMergeTargets() != null && (mergeSegment = commit.getMergeSegment()) != null && mergeSegment.getTrack() == commitTrack) {
                this.drawLine(commitTrackCenter, 0, commitTrackCenter, this.cellHeightHalf, commitColor, 3);
            }
            if (!(commitTime <= commitSegment.getFirstVisualTime() && commitSegment.isComplete() || commitInfo.isInitialCommit())) {
                this.drawLine(commitTrackCenter, this.cellHeightHalf, commitTrackCenter, this.cellHeight, commitColor);
            }
            int dotX = commitTrackCenter - this.dotSizeHalf - 1;
            int dotY = this.cellHeightHalf - this.dotSizeHalf;
            this.drawDot(dotX, dotY, this.dotSize, this.dotSize);
        }
        int x = this.getTrackX(segments.length);
        if (commitLastInBranch) {
            String branchLabel = this.labelProvider.getBranchString(commit.getBranch().getCDOBranch());
            x += 4;
            x += this.drawText(branchLabel, x + 4, this.cellHeightHalf, true, justMeasureWidth);
        }
        return x;
    }

    private void drawHorizontalLineWithRoundEdge(Color color, int lineStyle, int commitTrackCenter, int trackCenter, int horizontal, boolean down) {
        LinePlotter plotter = new LinePlotter(color, lineStyle, commitTrackCenter, this.cellHeightHalf);
        plotter.relative(horizontal, 0);
        plotter.absolute(trackCenter, down ? this.cellHeight - 3 : 3);
        plotter.relative(0, down ? 3 : -3);
    }

    private void drawLine(int x1, int y1, int x2, int y2, Color color) {
        this.drawLine(x1, y1, x2, y2, color, 1);
    }

    private void drawLine(int x1, int y1, int x2, int y2, Color color, int lineStyle) {
        this.gc.setForeground(color);
        this.gc.setLineWidth(2);
        this.gc.setLineStyle(lineStyle);
        this.gc.drawLine(this.cellX + x1, this.cellY + y1, this.cellX + x2, this.cellY + y2);
    }

    private void drawDot(int x, int y, int w, int h) {
        int dotX = this.cellX + x + 2;
        int dotY = this.cellY + y + 1;
        int dotW = w - 2;
        int dotH = h - 2;
        this.gc.setBackground(this.colorDotFill);
        this.gc.fillOval(dotX, dotY, dotW, dotH);
        this.gc.setForeground(this.colorDotOutline);
        this.gc.setLineWidth(2);
        this.gc.setLineStyle(1);
        this.gc.drawOval(dotX, dotY, dotW, dotH);
    }

    private int drawText(String msg, int x, int y, boolean badge, boolean justMeasureWidth) {
        Point extent = this.gc.textExtent(msg);
        int width = extent.x;
        if (badge) {
            width += 8;
        }
        if (!justMeasureWidth) {
            x += this.cellX;
            y = (y * 2 - extent.y) / 2 + this.cellY - 1;
            int height = extent.y + 1;
            if (badge) {
                this.gc.setBackground(this.colorBadgeFill);
                this.gc.fillRoundRectangle(x + 2, y + 2, width - 3, height - 3, 8, 8);
                this.gc.setLineWidth(1);
                this.gc.setLineStyle(1);
                this.gc.setForeground(this.colorBadgeOutline);
                this.gc.drawRoundRectangle(x, y, width, height, 8, 8);
            } else {
                this.gc.setBackground(this.cellBackground);
            }
            this.gc.setForeground(this.cellForeground);
            this.gc.drawString(msg, x + 4 + 1, y + 1, true);
        }
        return width;
    }

    private int getTrackX(int position) {
        return 4 + 14 * position;
    }

    private int getTrackCenter(int position) {
        return this.getTrackX(position) + 7;
    }

    private final class LinePlotter {
        private final Color color;
        private final int lineStyle;
        private int x;
        private int y;

        public LinePlotter(Color color, int lineStyle, int x, int y) {
            this.color = color;
            this.lineStyle = lineStyle;
            this.x = x;
            this.y = y;
        }

        public void relative(int width, int height) {
            int fromX = this.x;
            int fromY = this.y;
            this.x += width;
            this.y += height;
            NetRenderer.this.drawLine(fromX, fromY, this.x, this.y, this.color, this.lineStyle);
        }

        public void absolute(int x, int y) {
            NetRenderer.this.drawLine(this.x, this.y, x, y, this.color, this.lineStyle);
            this.x = x;
            this.y = y;
        }
    }
}

