/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.Factory;

public abstract class CDOSessionFactory
extends Factory {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.sessions";

    public CDOSessionFactory(String type) {
        super(PRODUCT_GROUP, type);
    }

    public CDOSession create(String description) {
        try {
            URI uri = new URI(description);
            String query = uri.getQuery();
            if (StringUtil.isEmpty((String)query)) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOSessionFactory.1"), description));
            }
            Map<String, String> parameters = CDOURIUtil.getParameters(query);
            return this.createSession(uri, parameters);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Deprecated
    protected InternalCDOSession createSession(String repositoryName, boolean automaticPackageRegistry) {
        throw new UnsupportedOperationException();
    }

    protected abstract InternalCDOSession createSession(URI var1, Map<String, String> var2);
}

