/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.net4j.util.container.Container;

public abstract class AbstractRegistry<T, R>
extends Container<R> {
    public static final int NOT_REGISTERED = 0;
    private final Map<Integer, R> registrationsByID = new HashMap<Integer, R>();
    private final Map<T, R> registrationsByElement = new HashMap<T, R>();
    private int lastID;

    public T[] getRegisteredElements() {
        R[] registrations = this.getElements();
        T[] registeredElements = this.newArray(registrations.length);
        int i = 0;
        while (i < registeredElements.length) {
            registeredElements[i] = this.getRegisteredElement(registrations[i]);
            ++i;
        }
        return registeredElements;
    }

    public synchronized R[] getElements() {
        int size = this.registrationsByID.size();
        R[] array = this.newRegistrationArray(size);
        return this.registrationsByID.values().toArray(array);
    }

    public synchronized T getElement(int id) {
        R registration = this.registrationsByID.get(id);
        if (registration != null) {
            return this.getRegisteredElement(registration);
        }
        return null;
    }

    public synchronized int[] getIDs() {
        int[] result = new int[this.registrationsByID.size()];
        int i = 0;
        for (Integer id : this.registrationsByID.keySet()) {
            result[i++] = id;
        }
        return result;
    }

    public synchronized int getID(T element) {
        R registration = this.registrationsByElement.get(element);
        if (registration != null) {
            return this.getRegisteredID(registration);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void registerElement(T element) {
        R registration;
        AbstractRegistry abstractRegistry = this;
        synchronized (abstractRegistry) {
            if (this.registrationsByElement.containsKey(element)) {
                return;
            }
            int id = ++this.lastID;
            registration = this.newRegistration(id, element);
            this.registrationsByID.put(id, registration);
            this.registrationsByElement.put(element, registration);
        }
        this.fireElementAddedEvent(registration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deregisterElement(T element) {
        R registration;
        AbstractRegistry abstractRegistry = this;
        synchronized (abstractRegistry) {
            registration = this.registrationsByElement.remove(element);
            if (registration != null) {
                int id = this.getRegisteredID(registration);
                this.registrationsByID.remove(id);
            }
        }
        this.fireElementRemovedEvent(registration);
    }

    protected abstract T[] newArray(int var1);

    protected abstract R[] newRegistrationArray(int var1);

    protected abstract R newRegistration(int var1, T var2);

    protected abstract int getRegisteredID(R var1);

    protected abstract T getRegisteredElement(R var1);
}

