/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class CDOChangeSubscriptionAdapter
extends AdapterImpl {
    private CDOView view;
    private CDOAdapterPolicy policy = new CDOAdapterPolicy(){

        @Override
        public boolean isValid(EObject eObject, Adapter adapter) {
            return adapter == CDOChangeSubscriptionAdapter.this;
        }
    };
    private Set<CDOObject> notifiers = new HashSet<CDOObject>();

    public CDOChangeSubscriptionAdapter(CDOView view) {
        this.view = view;
        view.options().addChangeSubscriptionPolicy(this.policy);
    }

    public void dispose() {
        this.reset();
        this.view.options().removeChangeSubscriptionPolicy(this.policy);
        this.view = null;
    }

    public CDOView getView() {
        return this.view;
    }

    public Set<CDOObject> getNotifiers() {
        return this.notifiers;
    }

    public void attach(CDOObject notifier) {
        if (this.notifiers.add(notifier)) {
            notifier.eAdapters().add((Object)this);
        }
    }

    public void reset() {
        for (CDOObject notifier : this.notifiers) {
            try {
                EList adapters;
                if (notifier == null || (adapters = notifier.eAdapters()) == null) continue;
                adapters.remove((Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.notifiers.clear();
    }
}

