/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.refactoring;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xcore.ui.XcoreJavaProjectProvider;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.util.jdt.JavaElementFinder;

public class XcoreJavaElementFinder
extends JavaElementFinder {
    @Inject
    private XcoreJavaProjectProvider projectProvider;

    protected IJavaElement internalFindElementFor(JvmIdentifiableElement element, boolean isExactMatchOnly) {
        Resource resource;
        if (element != null && (resource = element.eResource()) != null) {
            for (IJavaProject javaProject : this.projectProvider.getJavaProjects(resource)) {
                Finder implementation = new Finder(javaProject, isExactMatchOnly);
                IJavaElement result = implementation.doSwitch((EObject)element);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static class Finder
    extends JavaElementFinder.Implementation {
        private static final Method GET_PARAMETERS_METHOD;

        static {
            Method getParametersMethod = null;
            try {
                getParametersMethod = IMethod.class.getMethod("getParameters", new Class[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            GET_PARAMETERS_METHOD = getParametersMethod;
        }

        public Finder(IJavaProject javaProject, boolean isExactMatchOnly) {
            super(javaProject, isExactMatchOnly);
        }

        public IJavaElement caseJvmTypeParameter(JvmTypeParameter jvmTypeParameter) {
            JvmTypeParameterDeclarator declarator = jvmTypeParameter.getDeclarator();
            IJavaElement javaElement = this.doSwitch((EObject)declarator);
            return javaElement instanceof IType ? ((IType)javaElement).getTypeParameter(jvmTypeParameter.getName()) : (javaElement instanceof IMethod ? ((IMethod)javaElement).getTypeParameter(jvmTypeParameter.getName()) : null);
        }

        public IJavaElement caseJvmFormalParameter(JvmFormalParameter jvmFormalParameter) {
            IJavaElement javaElement = this.doSwitch(jvmFormalParameter.eContainer());
            if (javaElement instanceof IMethod) {
                String name = jvmFormalParameter.getName();
                ILocalVariable[] iLocalVariableArray = this.getParameters((IMethod)javaElement);
                int n = iLocalVariableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILocalVariable parameter = iLocalVariableArray[n2];
                    if (name.equals(parameter.getElementName())) {
                        return parameter;
                    }
                    ++n2;
                }
            }
            return null;
        }

        private ILocalVariable[] getParameters(IMethod method) {
            try {
                return (ILocalVariable[])GET_PARAMETERS_METHOD.invoke((Object)method, new Object[0]);
            }
            catch (Throwable exception) {
                return new ILocalVariable[0];
            }
        }
    }
}

