/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.common.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.contexts.ContextObjectSupplier;
import org.eclipse.e4.core.internal.di.Requestor;

public abstract class ContextBasedObjectSupplier<A extends Annotation, T>
extends ExtendedObjectSupplier {
    private final Class<A> qualifierType;
    private final Class<T> valueType;

    protected ContextBasedObjectSupplier(Class<A> qualifierType, Class<T> valueType) {
        this.qualifierType = qualifierType;
        this.valueType = valueType;
    }

    public Object get(IObjectDescriptor descriptor, final IRequestor requestor, boolean track, boolean group) {
        Class<?> desiredType = ContextBasedObjectSupplier.getRawType(descriptor.getDesiredType());
        Annotation qualifier = descriptor.getQualifier(this.qualifierType);
        if (!this.valueType.isAssignableFrom(desiredType)) {
            return IInjector.NOT_A_VALUE;
        }
        Class<T> requestedType = desiredType.asSubclass(this.valueType);
        IEclipseContext ctx = ContextBasedObjectSupplier.getContext(requestor);
        if (ctx == null) {
            return IInjector.NOT_A_VALUE;
        }
        if (!this.checkDependencies(qualifier, requestedType, ctx)) {
            return IInjector.NOT_A_VALUE;
        }
        final Object[] result = new Object[1];
        final Runnable compute = () -> {
            Optional<Object> computedResult = this.compute(qualifier, requestedType, ctx);
            if (computedResult == null) {
                throw new InjectionException(String.format("null computation for @%s injection", this.qualifierType.getSimpleName()));
            }
            objectArray[0] = computedResult.map(Object.class::cast).orElse(IInjector.NOT_A_VALUE);
        };
        if (track) {
            ctx.runAndTrack(new RunAndTrack(){

                public boolean changed(IEclipseContext context) {
                    boolean notify;
                    boolean valid = requestor.isValid();
                    boolean bl = notify = result[0] != null && requestor.isValid();
                    if (valid) {
                        compute.run();
                    }
                    if (notify) {
                        requestor.resolveArguments(false);
                        requestor.execute();
                    }
                    return valid;
                }
            });
        } else {
            compute.run();
        }
        return result[0];
    }

    protected boolean checkDependencies(A qualifier, Class<? extends T> requestedType, IEclipseContext context) {
        Optional<T> test = this.compute(qualifier, requestedType, context);
        return test != null && test.isPresent();
    }

    protected abstract Optional<? extends T> compute(A var1, Class<? extends T> var2, IEclipseContext var3);

    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ContextBasedObjectSupplier.getRawType(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }

    private static IEclipseContext getContext(IRequestor requestor) {
        PrimaryObjectSupplier supplier = null;
        if (requestor instanceof Requestor) {
            supplier = ((Requestor)requestor).getPrimarySupplier();
        }
        if (supplier instanceof ContextObjectSupplier) {
            return ((ContextObjectSupplier)supplier).getContext();
        }
        return null;
    }
}

