/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.ui.initializer.actions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.eef.codegen.EEFCodegenPlugin;
import org.eclipse.emf.eef.codegen.core.initializer.AbstractPropertiesInitializer;
import org.eclipse.emf.eef.codegen.ui.initializer.ui.InitializeEEFModelsDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class InitializeEEFModelsAction
implements IObjectActionDelegate {
    private Shell shell;
    private URI modelURI;
    private IFile selectedFile = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.selectedFile != null) {
            InitializeEEFModelsDialog dialog = new InitializeEEFModelsDialog(this.shell, this.selectedFile.getParent(), false, "Select a destination container for models :");
            dialog.setTitle("Container Selection");
            dialog.open();
            Object[] result = dialog.getResult();
            if (result != null && result.length >= 1) {
                try {
                    IPath path = (IPath)result[0];
                    Object container = path.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(path.toString()) : ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                    this.modelURI = URI.createPlatformResourceURI((String)this.selectedFile.getFullPath().toString(), (boolean)false);
                    AbstractPropertiesInitializer initializer = dialog.getInitializer();
                    initializer.initialize(this.modelURI, (IContainer)container);
                    container.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    EEFCodegenPlugin.getDefault().logError(e);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection sSelection;
        if (selection instanceof StructuredSelection && (sSelection = (StructuredSelection)selection).getFirstElement() instanceof IFile) {
            this.selectedFile = (IFile)sSelection.getFirstElement();
        }
    }
}

