/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class Pipe {
    protected InputStream input;
    private PipedInputStream pipedInputStream;
    protected PipedOutputStream pipedOutputStream;

    public Pipe(InputStream original) throws IOException {
        this.input = original;
        this.pipedInputStream = new PipedInputStream(){
            protected IOException failure;
            private boolean started = false;
            protected Object lock = this;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void start() throws IOException {
                Object object = this.lock;
                synchronized (object) {
                    if (this.failure != null) {
                        IOException e = new IOException("Problem piping the stream.");
                        e.fillInStackTrace();
                        e.initCause(this.failure);
                        throw e;
                    }
                    if (!this.started) {
                        this.started = true;
                        Thread pipeThread = new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    Pipe.this.pipeInput((this).Pipe.this.input, (this).Pipe.this.pipedOutputStream);
                                    (this).Pipe.this.pipedOutputStream.close();
                                }
                                catch (IOException e) {
                                    Object object = lock;
                                    synchronized (object) {
                                        failure = e;
                                    }
                                }
                            }
                        });
                        pipeThread.start();
                    }
                }
            }

            @Override
            public synchronized int available() throws IOException {
                this.start();
                return super.available();
            }

            @Override
            public synchronized int read() throws IOException {
                this.start();
                int c = super.read();
                return c;
            }

            @Override
            public int read(byte[] b) throws IOException {
                this.start();
                return super.read(b);
            }

            @Override
            public synchronized int read(byte[] b, int off, int len) throws IOException {
                this.start();
                return super.read(b, off, len);
            }

            @Override
            public synchronized void reset() throws IOException {
                this.started = false;
                this.failure = null;
                Pipe.this.input.reset();
                super.reset();
            }
        };
        this.pipedOutputStream = new PipedOutputStream(this.pipedInputStream);
    }

    public InputStream getPipedInputStream() {
        return this.pipedInputStream;
    }

    protected void pipeInput(InputStream original, OutputStream result) throws IOException {
        byte[] buffer = new byte[2048];
        int len = 0;
        while ((len = original.read(buffer)) != 0) {
            result.write(buffer, 0, len);
        }
    }
}

