/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.swt.controls;

import java.util.ArrayList;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.embed.swt.FXCanvas;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.eclipse.gef.fx.swt.controls.FXColorPicker;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FXAdvancedLinearGradientPicker
extends Composite {
    public static final String ADVANCED_LINEAR_GRADIENT_PROPERTY = "advancedLinearGradient";
    private static final int DIRECTION_RADIUS = 16;
    private static final double OFFSET_THRESHOLD = 0.005;
    private Property<LinearGradient> advancedLinearGradient = new SimpleObjectProperty((Object)this, "advancedLinearGradient");
    private double directionX = 1.0;
    private double directionY = 0.0;
    private AnchorPane root;
    private Rectangle preview;
    private Group pickerGroup;
    private Line directionLine;

    public static LinearGradient createAdvancedLinearGradient(Color c1, Color c2, Color c3) {
        Stop[] stops = new Stop[]{new Stop(0.0, c1), new Stop(0.5, c2), new Stop(1.0, c3)};
        return new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stops);
    }

    public static boolean isAdvancedLinearGradient(Paint paint) {
        if (paint instanceof LinearGradient) {
            return ((LinearGradient)paint).getStops().size() > 2;
        }
        return paint instanceof RadialGradient;
    }

    public FXAdvancedLinearGradientPicker(Composite parent, Color color1, Color color2, Color color3) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        FXCanvas canvas = new FXCanvas((Composite)this, 0);
        this.root = new AnchorPane();
        this.root.setStyle("-fx-background-color: transparent;");
        final Pane previewPane = new Pane();
        Circle directionCircle = new Circle(16.0, (Paint)Color.WHITE);
        this.directionLine = new Line();
        this.directionLine.setMouseTransparent(true);
        this.directionLine.setEndX(16.0);
        this.directionLine.setEndY(0.0);
        this.directionLine.startXProperty().bind((ObservableValue)directionCircle.centerXProperty());
        this.directionLine.startYProperty().bind((ObservableValue)directionCircle.centerYProperty());
        this.directionLine.translateXProperty().bind((ObservableValue)directionCircle.layoutXProperty());
        this.directionLine.translateYProperty().bind((ObservableValue)directionCircle.layoutYProperty());
        this.root.getChildren().addAll((Object[])new Node[]{previewPane, directionCircle, this.directionLine});
        AnchorPane.setTopAnchor((Node)previewPane, (Double)2.0);
        AnchorPane.setBottomAnchor((Node)previewPane, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)previewPane, (Double)15.0);
        AnchorPane.setRightAnchor((Node)previewPane, (Double)40.0);
        AnchorPane.setTopAnchor((Node)directionCircle, (Double)5.0);
        AnchorPane.setRightAnchor((Node)directionCircle, (Double)0.0);
        this.preview = new Rectangle();
        this.preview.setStroke((Paint)Color.DARKGRAY);
        this.pickerGroup = new Group();
        this.root.getChildren().addAll((Object[])new Node[]{this.preview, this.pickerGroup});
        this.preview.xProperty().bind((ObservableValue)previewPane.layoutXProperty());
        this.preview.yProperty().bind((ObservableValue)previewPane.layoutYProperty());
        this.preview.widthProperty().bind((ObservableValue)previewPane.widthProperty());
        this.preview.heightProperty().bind((ObservableValue)previewPane.heightProperty());
        this.preview.setFill((Paint)this.advancedLinearGradient.getValue());
        final Rectangle highlightSpotCreation = new Rectangle();
        highlightSpotCreation.setStroke((Paint)Color.TRANSPARENT);
        highlightSpotCreation.setFill((Paint)new Color(1.0, 1.0, 0.0, 0.5));
        highlightSpotCreation.heightProperty().bind((ObservableValue)this.preview.heightProperty().add(10));
        highlightSpotCreation.yProperty().bind((ObservableValue)this.preview.yProperty());
        highlightSpotCreation.setWidth(3.0);
        highlightSpotCreation.setTranslateX(-1.5);
        highlightSpotCreation.setVisible(false);
        highlightSpotCreation.setMouseTransparent(true);
        this.root.getChildren().add((Object)highlightSpotCreation);
        this.preview.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                highlightSpotCreation.setVisible(true);
            }
        });
        this.preview.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                highlightSpotCreation.setX(event.getX());
            }
        });
        this.preview.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                highlightSpotCreation.setVisible(false);
            }
        });
        this.preview.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (MouseButton.PRIMARY.equals((Object)event.getButton())) {
                    Point2D previewPosition = previewPane.sceneToLocal(event.getSceneX(), event.getSceneY());
                    double offset = previewPosition.getX() / FXAdvancedLinearGradientPicker.this.preview.getWidth();
                    offset = Math.max(0.0, Math.min(1.0, offset));
                    FXAdvancedLinearGradientPicker.this.createStop(offset);
                }
            }
        });
        directionCircle.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (FXAdvancedLinearGradientPicker.this.directionX == 1.0) {
                    FXAdvancedLinearGradientPicker.this.directionX = 0.0;
                    FXAdvancedLinearGradientPicker.this.directionY = 1.0;
                } else {
                    FXAdvancedLinearGradientPicker.this.directionX = 1.0;
                    FXAdvancedLinearGradientPicker.this.directionY = 0.0;
                }
                FXAdvancedLinearGradientPicker.this.updateDirectionLine();
                ArrayList<Stop> newStops = new ArrayList<Stop>(FXAdvancedLinearGradientPicker.this.getStops());
                FXAdvancedLinearGradientPicker.this.updateGradient(newStops);
            }
        });
        Scene scene = new Scene((Parent)this.root);
        org.eclipse.swt.graphics.Color backgroundColor = parent.getBackground();
        scene.setFill((Paint)Color.rgb((int)backgroundColor.getRed(), (int)backgroundColor.getGreen(), (int)backgroundColor.getBlue()));
        canvas.setScene(scene);
        this.setAdvancedGradient(FXAdvancedLinearGradientPicker.createAdvancedLinearGradient(color1, color2, color3));
    }

    public Property<LinearGradient> advancedLinearGradientProperty() {
        return this.advancedLinearGradient;
    }

    protected void createStop(double offset) {
        ArrayList<Stop> newStops = new ArrayList<Stop>(this.getStops());
        int addIndex = newStops.size();
        int i = 0;
        while (i < newStops.size()) {
            if (((Stop)newStops.get(i)).getOffset() > offset) {
                addIndex = i;
                break;
            }
            ++i;
        }
        newStops.add(addIndex, new Stop(offset, Color.WHITE));
        this.updateGradient(newStops);
    }

    public LinearGradient getAdvancedLinearGradient() {
        return (LinearGradient)this.advancedLinearGradient.getValue();
    }

    protected double getNextOffset(int stopIndex) {
        if (stopIndex == this.getStops().size() - 1) {
            return 0.995;
        }
        return this.getStops().get(stopIndex + 1).getOffset() - 0.005;
    }

    protected double getPrevOffset(int stopIndex) {
        if (stopIndex == 0) {
            return 0.005;
        }
        return this.getStops().get(stopIndex - 1).getOffset() + 0.005;
    }

    protected List<Stop> getStops() {
        return ((LinearGradient)this.advancedLinearGradient.getValue()).getStops();
    }

    protected void removeStop(int index) {
        ArrayList<Stop> newStops = new ArrayList<Stop>(this.getStops());
        newStops.remove(index);
        this.updateGradient(newStops);
    }

    public void setAdvancedGradient(LinearGradient advancedLinearGradient) {
        if (!FXAdvancedLinearGradientPicker.isAdvancedLinearGradient((Paint)advancedLinearGradient)) {
            throw new IllegalArgumentException("Given value '" + advancedLinearGradient + "' is no advanced linear gradient");
        }
        this.advancedLinearGradient.setValue((Object)advancedLinearGradient);
        this.preview.setFill((Paint)advancedLinearGradient);
        this.directionX = advancedLinearGradient.getEndX();
        if (this.directionX == 1.0) {
            this.directionY = 0.0;
        } else {
            this.directionX = 0.0;
            this.directionY = 1.0;
        }
        this.updateDirectionLine();
        List<Stop> stops = this.getStops();
        int i = 0;
        while (i < stops.size()) {
            if (this.pickerGroup.getChildren().size() > i) {
                ((StopPicker)((Object)this.pickerGroup.getChildren().get(i))).refresh();
            } else {
                StopPicker stopPicker = new StopPicker(i);
                this.pickerGroup.getChildren().add((Object)stopPicker);
                stopPicker.layoutXProperty().bind((ObservableValue)this.preview.xProperty());
                stopPicker.layoutYProperty().bind((ObservableValue)this.preview.yProperty().add((ObservableNumberValue)this.preview.heightProperty()));
            }
            ++i;
        }
        i = this.pickerGroup.getChildren().size() - 1;
        while (i >= stops.size()) {
            this.pickerGroup.getChildren().remove(i);
            --i;
        }
    }

    protected void updateDirectionLine() {
        this.directionLine.setEndX(this.directionX * 16.0);
        this.directionLine.setEndY(this.directionY * 16.0);
    }

    protected void updateGradient(List<Stop> newStops) {
        this.setAdvancedGradient(new LinearGradient(0.0, 0.0, this.directionX, this.directionY, true, CycleMethod.NO_CYCLE, newStops));
    }

    protected void updateStop(int index, double offset, Color color) {
        ArrayList<Stop> newStops = new ArrayList<Stop>(this.getStops());
        newStops.set(index, new Stop(offset, color));
        this.updateGradient(newStops);
    }

    private class StopPicker
    extends Group {
        private static final double SIZE = 8.0;
        private int index = 0;
        private DoubleProperty offsetProperty = new SimpleDoubleProperty();
        private ObjectProperty<Color> colorProperty = new SimpleObjectProperty((Object)Color.WHITE);
        private Polygon tip;
        private Rectangle picker;
        private double initialMouseX;
        private double initialTx;
        private boolean draggable;
        private EventHandler<? super MouseEvent> onDrag = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (StopPicker.this.draggable) {
                    double dx = event.getSceneX() - StopPicker.this.initialMouseX;
                    double newOffset = (StopPicker.this.initialTx + dx) / FXAdvancedLinearGradientPicker.this.preview.getWidth();
                    newOffset = Math.max(FXAdvancedLinearGradientPicker.this.getPrevOffset(StopPicker.this.index), Math.min(FXAdvancedLinearGradientPicker.this.getNextOffset(StopPicker.this.index), newOffset));
                    StopPicker.this.offsetProperty.set(newOffset);
                    FXAdvancedLinearGradientPicker.this.updateStop(StopPicker.this.index, StopPicker.this.offsetProperty.get(), (Color)StopPicker.this.colorProperty.get());
                }
            }
        };

        public StopPicker(int index) {
            this.tip = new Polygon(new double[]{0.0, 0.0, 4.0, 4.0, -4.0, 4.0});
            this.tip.setStroke((Paint)Color.BLACK);
            this.tip.setFill((Paint)Color.BLACK);
            this.picker = new Rectangle(-4.0, 4.0, 8.0, 8.0);
            this.picker.setStroke((Paint)Color.BLACK);
            this.picker.fillProperty().bind(this.colorProperty);
            this.getChildren().addAll((Object[])new Node[]{this.tip, this.picker});
            this.index = index;
            this.translateXProperty().bind((ObservableValue)FXAdvancedLinearGradientPicker.this.preview.widthProperty().multiply((ObservableNumberValue)this.offsetProperty));
            this.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (StopPicker.this.draggable) {
                        BoxBlur boxBlur = new BoxBlur(0.0, 0.0, 1);
                        StopPicker.this.setEffect((Effect)boxBlur);
                        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)boxBlur.widthProperty(), (Object)0), new KeyValue((WritableValue)boxBlur.heightProperty(), (Object)0)}), new KeyFrame(Duration.millis((double)150.0), new KeyValue[]{new KeyValue((WritableValue)boxBlur.widthProperty(), (Object)3), new KeyValue((WritableValue)boxBlur.heightProperty(), (Object)3)})});
                        timeline.play();
                    }
                }
            });
            this.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (!StopPicker.this.isPressed()) {
                        StopPicker.this.setEffect(null);
                    }
                }
            });
            this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    StopPicker.this.initialMouseX = event.getSceneX();
                    StopPicker.this.initialTx = StopPicker.this.getTranslateX();
                }
            });
            this.setOnMouseDragged(this.onDrag);
            this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    StopPicker.this.onDrag.handle((Event)event);
                    if (!StopPicker.this.isHover()) {
                        StopPicker.this.setEffect(null);
                    }
                }
            });
            this.refresh();
            this.picker.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (event.getClickCount() > 1) {
                        StopPicker.this.colorProperty.set((Object)FXColorPicker.pickColor(FXAdvancedLinearGradientPicker.this.getShell(), (Color)StopPicker.this.colorProperty.get()));
                        FXAdvancedLinearGradientPicker.this.updateStop(StopPicker.this.index, StopPicker.this.offsetProperty.get(), (Color)StopPicker.this.colorProperty.get());
                    } else if (StopPicker.this.draggable && MouseButton.SECONDARY.equals((Object)event.getButton())) {
                        FXAdvancedLinearGradientPicker.this.removeStop(StopPicker.this.index);
                    }
                }
            });
        }

        public void refresh() {
            this.offsetProperty.set(FXAdvancedLinearGradientPicker.this.getStops().get(this.index).getOffset());
            this.colorProperty.set((Object)FXAdvancedLinearGradientPicker.this.getStops().get(this.index).getColor());
            this.draggable = this.offsetProperty.get() != 0.0 && this.offsetProperty.get() != 1.0;
        }
    }
}

